/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.enchanter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class EnchanterRecipeSerializer<T extends EnchanterRecipe>
implements class_1865<T> {
    public final RecipeFactory<T> recipeFactory;

    public EnchanterRecipeSerializer(RecipeFactory<T> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public T read(class_2960 identifier, JsonObject jsonObject) {
        String group = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
        JsonArray ingredientArray = class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients");
        class_2371 craftingInputs = class_2371.method_37434((int)ingredientArray.size());
        for (int i = 0; i < ingredientArray.size(); ++i) {
            craftingInputs.add((Object)class_1856.method_8102((JsonElement)ingredientArray.get(i)));
        }
        class_1799 output = RecipeUtils.outputWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
        int requiredExperience = class_3518.method_15282((JsonObject)jsonObject, (String)"required_experience", (int)0);
        int craftingTime = class_3518.method_15282((JsonObject)jsonObject, (String)"time", (int)200);
        boolean noBenefitsFromYieldAndEfficiencyUpgrades = false;
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"disable_yield_and_efficiency_upgrades")) {
            noBenefitsFromYieldAndEfficiencyUpgrades = class_3518.method_15258((JsonObject)jsonObject, (String)"disable_yield_and_efficiency_upgrades", (boolean)false);
        }
        class_2960 requiredAdvancementIdentifier = null;
        if (class_3518.method_15289((JsonObject)jsonObject, (String)"required_advancement")) {
            requiredAdvancementIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"required_advancement"));
        }
        return this.recipeFactory.create(identifier, group, (class_2371<class_1856>)craftingInputs, output, craftingTime, requiredExperience, noBenefitsFromYieldAndEfficiencyUpgrades, requiredAdvancementIdentifier);
    }

    public void write(class_2540 packetByteBuf, T enchanterRecipe) {
        packetByteBuf.method_10814(((EnchanterRecipe)enchanterRecipe).group);
        packetByteBuf.writeShort(((EnchanterRecipe)enchanterRecipe).inputs.size());
        for (class_1856 ingredient : ((EnchanterRecipe)enchanterRecipe).inputs) {
            ingredient.method_8088(packetByteBuf);
        }
        packetByteBuf.method_10793(((EnchanterRecipe)enchanterRecipe).output);
        packetByteBuf.writeInt(((EnchanterRecipe)enchanterRecipe).craftingTime);
        packetByteBuf.writeInt(((EnchanterRecipe)enchanterRecipe).requiredExperience);
        packetByteBuf.writeBoolean(((EnchanterRecipe)enchanterRecipe).noBenefitsFromYieldAndEfficiencyUpgrades);
        packetByteBuf.method_10812(((EnchanterRecipe)enchanterRecipe).requiredAdvancementIdentifier);
    }

    public T read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        short craftingInputCount = packetByteBuf.readShort();
        class_2371 ingredients = class_2371.method_10213((int)craftingInputCount, (Object)class_1856.field_9017);
        for (short i = 0; i < craftingInputCount; i = (short)(i + 1)) {
            ingredients.set((int)i, (Object)class_1856.method_8086((class_2540)packetByteBuf));
        }
        class_1799 output = packetByteBuf.method_10819();
        int craftingTime = packetByteBuf.readInt();
        int requiredExperience = packetByteBuf.readInt();
        boolean noBenefitsFromYieldAndEfficiencyUpgrades = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = packetByteBuf.method_10810();
        return this.recipeFactory.create(identifier, group, (class_2371<class_1856>)ingredients, output, craftingTime, requiredExperience, noBenefitsFromYieldAndEfficiencyUpgrades, requiredAdvancementIdentifier);
    }

    public static interface RecipeFactory<T extends EnchanterRecipe> {
        public T create(class_2960 var1, String var2, class_2371<class_1856> var3, class_1799 var4, int var5, int var6, boolean var7, @Nullable class_2960 var8);
    }
}

