/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.spectrum.sound.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4587;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class UnlockedRecipeGroupToast
implements class_368 {
    private final class_2960 TEXTURE = new class_2960("spectrum", "textures/gui/toasts.png");
    private final class_2561 title;
    private final class_2561 text;
    private final List<class_1799> itemStacks;
    private final class_3414 soundEvent = SpectrumSoundEvents.NEW_RECIPE;
    private boolean soundPlayed;

    public UnlockedRecipeGroupToast(class_2561 title, class_2561 text, List<class_1799> itemStacks) {
        this.title = title;
        this.text = text;
        this.itemStacks = itemStacks;
        this.soundPlayed = false;
    }

    public static void showRecipeToast(class_310 client, final class_1799 itemStack, UnlockedRecipeToastType type) {
        class_2588 title = type == UnlockedRecipeToastType.PEDESTAL ? new class_2588("spectrum.toast.pedestal_recipe_unlocked.title") : (type == UnlockedRecipeToastType.FUSION_SHRINE ? new class_2588("spectrum.toast.fusion_shrine_recipe_unlocked.title") : new class_2588("spectrum.toast.enchanter_recipe_unlocked.title"));
        class_2561 text = UnlockedRecipeGroupToast.getTextForItemStack(itemStack);
        client.method_1566().method_1999((class_368)new UnlockedRecipeGroupToast((class_2561)title, text, (List<class_1799>)new ArrayList<class_1799>(){
            {
                this.add(itemStack);
            }
        }));
    }

    public static void showRecipeGroupToast(class_310 client, String groupName, List<class_1799> itemStacks, UnlockedRecipeToastType type) {
        class_2588 title = type == UnlockedRecipeToastType.PEDESTAL ? new class_2588("spectrum.toast.pedestal_recipes_unlocked.title") : (type == UnlockedRecipeToastType.FUSION_SHRINE ? new class_2588("spectrum.toast.fusion_shrine_recipes_unlocked.title") : new class_2588("spectrum.toast.enchanter_recipes_unlocked.title"));
        class_2588 text = new class_2588("recipeGroup.spectrum." + groupName);
        client.method_1566().method_1999((class_368)new UnlockedRecipeGroupToast((class_2561)title, (class_2561)text, itemStacks));
    }

    public class_368.class_369 method_1986(class_4587 matrices, class_374 manager, long startTime) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        manager.method_25302(matrices, 0, 0, 0, 32, this.method_29049(), this.method_29050());
        manager.method_1995().field_1772.method_30883(matrices, this.title, 30.0f, 7.0f, 0x323232);
        manager.method_1995().field_1772.method_30883(matrices, this.text, 30.0f, 18.0f, 0);
        if (!this.soundPlayed && startTime > 0L) {
            this.soundPlayed = true;
            if (this.soundEvent != null) {
                manager.method_1995().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)this.soundEvent, (float)1.0f, (float)1.0f));
            }
        }
        int itemStackIndex = (int)(startTime / (long)Math.max(1, 5000 / this.itemStacks.size()) % (long)this.itemStacks.size());
        class_1799 currentItemStack = this.itemStacks.get(itemStackIndex);
        manager.method_1995().method_1480().method_27953(currentItemStack, 8, 8);
        return startTime >= 5000L ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
    }

    public static class_2561 getTextForItemStack(class_1799 itemStack) {
        Map enchantments;
        if (itemStack.method_31574(class_1802.field_8598) && (enchantments = class_1890.method_8222((class_1799)itemStack)).size() > 0) {
            Map.Entry firstEnchantment = enchantments.entrySet().iterator().next();
            return new class_2588(((class_1887)firstEnchantment.getKey()).method_8184());
        }
        return itemStack.method_7964();
    }

    public static enum UnlockedRecipeToastType {
        PEDESTAL,
        FUSION_SHRINE,
        ENCHANTER;

    }
}

