/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression;

import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.progression.toast.MessageToast;
import de.dafuqs.spectrum.progression.toast.UnlockedRecipeGroupToast;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ClientRecipeToastManager {
    public static final HashMap<class_2960, List<PedestalCraftingRecipe>> unlockablePedestalRecipes = new HashMap();
    public static final HashMap<class_2960, List<FusionShrineRecipe>> unlockableFusionShrineRecipes = new HashMap();
    public static final HashMap<class_2960, List<EnchanterRecipe>> unlockableEnchanterRecipes = new HashMap();
    public static final HashMap<class_2960, class_3545<class_1799, String>> registeredMessageToasts = new HashMap<class_2960, class_3545<class_1799, String>>(){
        {
            this.put(new class_2960("spectrum", "milestones/unlock_shooting_stars"), new class_3545((Object)new class_1799((class_1935)class_1802.field_27070), (Object)"shooting_stars_unlocked"));
            this.put(new class_2960("spectrum", "milestones/unlock_overenchanting_with_enchanter"), new class_3545((Object)new class_1799((class_1935)SpectrumBlocks.ENCHANTER), (Object)"overchanting_unlocked"));
            this.put(new class_2960("spectrum", "milestones/unlock_conflicted_enchanting_with_enchanter"), new class_3545((Object)new class_1799((class_1935)SpectrumBlocks.ENCHANTER), (Object)"enchant_conflicting_enchantments_unlocked"));
            this.put(new class_2960("spectrum", "midgame/spectrum_midgame"), new class_3545((Object)new class_1799((class_1935)SpectrumBlocks.PEDESTAL_ONYX), (Object)"second_advancement_tree_unlocked"));
            this.put(new class_2960("spectrum", "lategame/spectrum_lategame"), new class_3545((Object)new class_1799((class_1935)SpectrumBlocks.PEDESTAL_MOONSTONE), (Object)"third_advancement_tree_unlocked"));
        }
    };

    public static void registerUnlockablePedestalRecipe(@NotNull PedestalCraftingRecipe recipe) {
        List<class_2960> requiredAdvancementIdentifiers = recipe.getRequiredAdvancementIdentifiers();
        if (requiredAdvancementIdentifiers.size() > 0) {
            for (class_2960 requiredAdvancementIdentifier : requiredAdvancementIdentifiers) {
                if (unlockablePedestalRecipes.containsKey(requiredAdvancementIdentifier)) {
                    if (unlockablePedestalRecipes.get(requiredAdvancementIdentifier).contains(recipe)) continue;
                    unlockablePedestalRecipes.get(requiredAdvancementIdentifier).add(recipe);
                    continue;
                }
                ArrayList<PedestalCraftingRecipe> recipes = new ArrayList<PedestalCraftingRecipe>();
                recipes.add(recipe);
                unlockablePedestalRecipes.put(requiredAdvancementIdentifier, recipes);
            }
        }
    }

    public static void registerUnlockableFusionShrineRecipe(@NotNull FusionShrineRecipe recipe) {
        class_2960 requiredAdvancementIdentifier = recipe.getRequiredAdvancementIdentifier();
        if (requiredAdvancementIdentifier != null) {
            if (unlockableFusionShrineRecipes.containsKey(requiredAdvancementIdentifier)) {
                if (!unlockableFusionShrineRecipes.get(requiredAdvancementIdentifier).contains(recipe)) {
                    unlockableFusionShrineRecipes.get(requiredAdvancementIdentifier).add(recipe);
                }
            } else {
                ArrayList<FusionShrineRecipe> recipes = new ArrayList<FusionShrineRecipe>();
                recipes.add(recipe);
                unlockableFusionShrineRecipes.put(requiredAdvancementIdentifier, recipes);
            }
        }
    }

    public static void registerUnlockableEnchanterRecipe(@NotNull EnchanterRecipe recipe) {
        class_2960 requiredAdvancementIdentifier = recipe.getRequiredAdvancementIdentifier();
        if (requiredAdvancementIdentifier != null) {
            if (unlockableEnchanterRecipes.containsKey(requiredAdvancementIdentifier)) {
                if (!unlockableEnchanterRecipes.get(requiredAdvancementIdentifier).contains(recipe)) {
                    unlockableEnchanterRecipes.get(requiredAdvancementIdentifier).add(recipe);
                }
            } else {
                ArrayList<EnchanterRecipe> recipes = new ArrayList<EnchanterRecipe>();
                recipes.add(recipe);
                unlockableEnchanterRecipes.put(requiredAdvancementIdentifier, recipes);
            }
        }
    }

    public static void process(List<class_2960> doneAdvancements, boolean showToast) {
        if (showToast) {
            ArrayList<PedestalCraftingRecipe> pedestalRecipes = new ArrayList<PedestalCraftingRecipe>();
            ArrayList<FusionShrineRecipe> fusionRecipes = new ArrayList<FusionShrineRecipe>();
            ArrayList<EnchanterRecipe> enchanterRecipes = new ArrayList<EnchanterRecipe>();
            ArrayList<class_3545<class_1799, String>> messageToasts = new ArrayList<class_3545<class_1799, String>>();
            for (class_2960 class_29602 : doneAdvancements) {
                Optional<PedestalRecipeTier> newlyUnlockedRecipeTier;
                if (unlockablePedestalRecipes.containsKey(class_29602)) {
                    for (PedestalCraftingRecipe unlockedRecipe : unlockablePedestalRecipes.get(class_29602)) {
                        if (!unlockedRecipe.canPlayerCraft((class_1657)class_310.method_1551().field_1724) || pedestalRecipes.contains(unlockedRecipe)) continue;
                        pedestalRecipes.add(unlockedRecipe);
                    }
                }
                if ((newlyUnlockedRecipeTier = PedestalRecipeTier.hasJustUnlockedANewRecipeTier(class_29602)).isPresent()) {
                    for (PedestalCraftingRecipe pedestalCraftingRecipe : ClientRecipeToastManager.getRecipesForTierWithAllConditionsMet(newlyUnlockedRecipeTier.get())) {
                        if (pedestalRecipes.contains(pedestalCraftingRecipe)) continue;
                        pedestalRecipes.add(pedestalCraftingRecipe);
                    }
                }
                if (unlockableFusionShrineRecipes.containsKey(class_29602)) {
                    for (FusionShrineRecipe fusionShrineRecipe : unlockableFusionShrineRecipes.get(class_29602)) {
                        if (fusionRecipes.contains(fusionShrineRecipe)) continue;
                        fusionRecipes.add(fusionShrineRecipe);
                    }
                }
                if (unlockableEnchanterRecipes.containsKey(class_29602)) {
                    for (EnchanterRecipe enchanterRecipe : unlockableEnchanterRecipes.get(class_29602)) {
                        if (enchanterRecipes.contains(enchanterRecipe)) continue;
                        enchanterRecipes.add(enchanterRecipe);
                    }
                }
                if (!registeredMessageToasts.containsKey(class_29602)) continue;
                messageToasts.add(registeredMessageToasts.get(class_29602));
            }
            if (!pedestalRecipes.isEmpty()) {
                ClientRecipeToastManager.showGroupedRecipeUnlockToasts(pedestalRecipes, UnlockedRecipeGroupToast.UnlockedRecipeToastType.PEDESTAL);
            }
            if (!pedestalRecipes.isEmpty()) {
                ClientRecipeToastManager.showGroupedRecipeUnlockToasts(fusionRecipes, UnlockedRecipeGroupToast.UnlockedRecipeToastType.FUSION_SHRINE);
            }
            if (!enchanterRecipes.isEmpty()) {
                ClientRecipeToastManager.showGroupedRecipeUnlockToasts(enchanterRecipes, UnlockedRecipeGroupToast.UnlockedRecipeToastType.ENCHANTER);
            }
            for (class_3545 class_35452 : messageToasts) {
                MessageToast.showMessageToast(class_310.method_1551(), (class_1799)class_35452.method_15442(), (String)class_35452.method_15441());
            }
        }
    }

    @NotNull
    private static List<PedestalCraftingRecipe> getRecipesForTierWithAllConditionsMet(PedestalRecipeTier pedestalRecipeTier) {
        class_746 player = class_310.method_1551().field_1724;
        ArrayList<PedestalCraftingRecipe> alreadyUnlockedRecipesAtNewTier = new ArrayList<PedestalCraftingRecipe>();
        for (List<PedestalCraftingRecipe> recipes : unlockablePedestalRecipes.values()) {
            for (PedestalCraftingRecipe recipe : recipes) {
                if (recipe.getTier() != pedestalRecipeTier || alreadyUnlockedRecipesAtNewTier.contains(recipe) || !recipe.hasUnlockedRequiredAdvancements((class_1657)player)) continue;
                alreadyUnlockedRecipesAtNewTier.add(recipe);
            }
        }
        return alreadyUnlockedRecipesAtNewTier;
    }

    private static void showGroupedRecipeUnlockToasts(@NotNull List<? extends class_1860> recipes, UnlockedRecipeGroupToast.UnlockedRecipeToastType toastType) {
        HashMap groupedRecipes = new HashMap();
        for (class_1860 class_18602 : recipes) {
            if (class_18602.method_8110().method_7960()) continue;
            if (class_18602.method_8112().isEmpty()) {
                class_1799 displayStack = class_18602.method_8110().method_7972();
                displayStack.method_7939(1);
                UnlockedRecipeGroupToast.showRecipeToast(class_310.method_1551(), displayStack, toastType);
                continue;
            }
            if (groupedRecipes.containsKey(class_18602.method_8112())) {
                ((List)groupedRecipes.get(class_18602.method_8112())).add(class_18602.method_8110());
                continue;
            }
            ArrayList<class_1799> newList = new ArrayList<class_1799>();
            newList.add(new class_1799((class_1935)class_18602.method_8110().method_7909()));
            groupedRecipes.put(class_18602.method_8112(), newList);
        }
        for (String string : groupedRecipes.keySet()) {
            List groupedList = (List)groupedRecipes.get(string);
            if (groupedList.size() == 1) {
                UnlockedRecipeGroupToast.showRecipeToast(class_310.method_1551(), (class_1799)groupedList.get(0), toastType);
                continue;
            }
            UnlockedRecipeGroupToast.showRecipeGroupToast(class_310.method_1551(), string, (List)groupedRecipes.get(string), toastType);
        }
    }
}

