/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression;

import de.dafuqs.spectrum.accessor.WorldRendererAccessor;
import de.dafuqs.spectrum.interfaces.Cloakable;
import de.dafuqs.spectrum.progression.BlockCloakManager;
import de.dafuqs.spectrum.progression.toast.RevelationToast;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.sound.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_761;

@Environment(value=EnvType.CLIENT)
public class ClientBlockCloaker {
    private static final List<class_2680> activeBlockStateSwaps = new ArrayList<class_2680>();
    private static final List<class_1792> activeItemSwaps = new ArrayList<class_1792>();

    public static void process(List<class_2960> doneAdvancements, boolean showToast) {
        ArrayList<Cloakable> cloakableBlocksToTrigger = new ArrayList<Cloakable>();
        for (class_2960 doneAdvancement : doneAdvancements) {
            cloakableBlocksToTrigger.addAll(BlockCloakManager.getBlocksToUncloak(doneAdvancement));
        }
        if (cloakableBlocksToTrigger.size() > 0) {
            for (Cloakable cloakable : cloakableBlocksToTrigger) {
                ClientBlockCloaker.uncloak(cloakable);
            }
            ClientBlockCloaker.rebuildAllChunks();
            if (showToast) {
                RevelationToast.showRevelationToast(class_310.method_1551(), new class_1799((class_1935)SpectrumBlocks.PEDESTAL_BASIC_AMETHYST.method_8389()), SpectrumSoundEvents.NEW_REVELATION);
            }
        }
    }

    static void rebuildAllChunks() {
        class_761 renderer = class_310.method_1551().field_1769;
        ((WorldRendererAccessor)renderer).rebuildAllChunks();
    }

    static void uncloak(Cloakable cloakable) {
        Set<class_2680> cloakBlockStates = cloakable.getBlockStateCloaks().keySet();
        activeBlockStateSwaps.removeAll(cloakBlockStates);
        class_3545<class_1792, class_1792> itemCloak = cloakable.getItemCloak();
        if (itemCloak != null) {
            activeItemSwaps.remove(itemCloak.method_15442());
        }
        cloakable.onUncloak();
    }

    private static void cloak(Cloakable cloakable) {
        class_1792 cloakItem;
        Set<class_2680> cloakBlockStates = cloakable.getBlockStateCloaks().keySet();
        activeBlockStateSwaps.addAll(cloakBlockStates);
        class_3545<class_1792, class_1792> itemCloak = cloakable.getItemCloak();
        if (itemCloak != null && !(cloakItem = (class_1792)itemCloak.method_15442()).equals(class_1802.field_8162)) {
            activeItemSwaps.add(cloakItem);
        }
        cloakable.onCloak();
    }

    public static boolean isCloaked(class_2248 block) {
        return activeBlockStateSwaps.contains(block.method_9564());
    }

    public static boolean isCloaked(class_2680 blockState) {
        return activeBlockStateSwaps.contains(blockState);
    }

    public static class_2680 getCloakTarget(class_2680 blockState) {
        if (ClientBlockCloaker.isCloaked(blockState)) {
            return BlockCloakManager.getBlockStateCloak(blockState);
        }
        return blockState;
    }

    public static boolean isCloaked(class_1792 item) {
        return activeItemSwaps.contains(item);
    }

    public static class_1792 getCloakTarget(class_1792 item) {
        if (ClientBlockCloaker.isCloaked(item)) {
            return BlockCloakManager.getItemCloak(item);
        }
        return item;
    }

    public static void cloakAll() {
        activeItemSwaps.clear();
        activeBlockStateSwaps.clear();
        HashMap<class_2960, List<Cloakable>> registeredCloaks = BlockCloakManager.getAdvancementIdentifiersAndRegisteredCloaks();
        for (List<Cloakable> registeredCloak : registeredCloaks.values()) {
            for (Cloakable cloakable : registeredCloak) {
                ClientBlockCloaker.cloak(cloakable);
            }
        }
    }
}

