/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression;

import de.dafuqs.spectrum.mixin.client.AccessorClientAdvancementManager;
import de.dafuqs.spectrum.progression.ClientBlockCloaker;
import de.dafuqs.spectrum.progression.ClientRecipeToastManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2779;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_632;
import net.minecraft.class_634;

@Environment(value=EnvType.CLIENT)
public class ClientAdvancements {
    private static boolean receivedFirstAdvancementPacket = false;

    public static void onClientPacket(class_2779 packet) {
        boolean showToast = receivedFirstAdvancementPacket;
        receivedFirstAdvancementPacket = true;
        List<class_2960> doneAdvancements = ClientAdvancements.getDoneAdvancements(packet);
        ClientBlockCloaker.process(doneAdvancements, showToast);
        ClientRecipeToastManager.process(doneAdvancements, showToast);
    }

    public static boolean hasDone(class_2960 identifier) {
        class_632 cm;
        class_161 adv;
        class_634 conn;
        if (!receivedFirstAdvancementPacket) {
            return false;
        }
        if (identifier != null && (conn = class_310.method_1551().method_1562()) != null && (adv = (cm = conn.method_2869()).method_2863().method_716(identifier)) != null) {
            Map<class_161, class_167> progressMap = ((AccessorClientAdvancementManager)cm).getAdvancementProgresses();
            class_167 progress = progressMap.get(adv);
            return progress != null && progress.method_740();
        }
        return false;
    }

    public static List<class_2960> getDoneAdvancements(class_2779 packet) {
        ArrayList<class_2960> doneAdvancements = new ArrayList<class_2960>();
        for (Map.Entry earnedEntry : packet.method_11928().entrySet()) {
            class_2960 earnedAdvancementIdentifier = (class_2960)earnedEntry.getKey();
            if (!ClientAdvancements.hasDone(earnedAdvancementIdentifier)) continue;
            doneAdvancements.add(earnedAdvancementIdentifier);
        }
        for (Map.Entry progressedEntry : packet.method_11927().entrySet()) {
            class_2960 progressedAdvancementIdentifier = (class_2960)progressedEntry.getKey();
            if (!ClientAdvancements.hasDone(progressedAdvancementIdentifier) || doneAdvancements.contains(progressedAdvancementIdentifier)) continue;
            doneAdvancements.add(progressedAdvancementIdentifier);
        }
        return doneAdvancements;
    }

    public static void playerLogout() {
        ClientBlockCloaker.cloakAll();
        receivedFirstAdvancementPacket = false;
    }
}

