/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression;

import de.dafuqs.spectrum.interfaces.Cloakable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3545;

public class BlockCloakManager {
    private static final HashMap<class_2960, List<Cloakable>> advancementBlockSwapTriggers = new HashMap();
    private static final HashMap<class_2680, class_2680> blockStateSwaps = new HashMap();
    private static final HashMap<class_1792, class_1792> itemSwaps = new HashMap();

    public static void registerBlockStateCloaks(Hashtable<class_2680, class_2680> blockStates) {
        blockStateSwaps.putAll(blockStates);
    }

    public static class_2680 getBlockStateCloak(class_2680 blockState) {
        return blockStateSwaps.getOrDefault(blockState, blockState);
    }

    public static void registerItemCloak(class_1792 sourceItem, class_1792 targetItem) {
        itemSwaps.put(sourceItem, targetItem);
    }

    public static class_1792 getItemCloak(class_1792 item) {
        return itemSwaps.getOrDefault(item, item);
    }

    public static void registerAdvancementCloak(Cloakable cloakableBlock, class_2960 advancementIdentifier) {
        if (advancementBlockSwapTriggers.containsKey(advancementIdentifier)) {
            if (!advancementBlockSwapTriggers.get(advancementIdentifier).contains(cloakableBlock)) {
                advancementBlockSwapTriggers.get(advancementIdentifier).add(cloakableBlock);
            }
        } else {
            ArrayList<Cloakable> blocks = new ArrayList<Cloakable>();
            blocks.add(cloakableBlock);
            advancementBlockSwapTriggers.put(advancementIdentifier, blocks);
        }
    }

    public static boolean doesAdvancementTriggerRevelation(class_2960 advancementIdentifier) {
        return advancementBlockSwapTriggers.containsKey(advancementIdentifier);
    }

    public static List<Cloakable> getRevelationsForAdvancement(class_2960 advancementIdentifier) {
        if (advancementBlockSwapTriggers.containsKey(advancementIdentifier)) {
            return advancementBlockSwapTriggers.get(advancementIdentifier);
        }
        return new ArrayList<Cloakable>();
    }

    public static List<Cloakable> getBlocksToUncloak(class_2960 advancementIdentifier) {
        if (advancementBlockSwapTriggers.containsKey(advancementIdentifier)) {
            return advancementBlockSwapTriggers.get(advancementIdentifier);
        }
        return new ArrayList<Cloakable>();
    }

    public static HashMap<class_2960, List<Cloakable>> getAdvancementIdentifiersAndRegisteredCloaks() {
        return advancementBlockSwapTriggers;
    }

    public static void setupCloaks() {
        Collection<List<Cloakable>> registeredCloakables = BlockCloakManager.getAdvancementIdentifiersAndRegisteredCloaks().values();
        for (List<Cloakable> cloakablesList : registeredCloakables) {
            for (Cloakable cloakable : cloakablesList) {
                BlockCloakManager.registerBlockStateCloaks(cloakable.getBlockStateCloaks());
                class_3545<class_1792, class_1792> itemCloak = cloakable.getItemCloak();
                if (itemCloak == null) continue;
                BlockCloakManager.registerItemCloak((class_1792)itemCloak.method_15442(), (class_1792)itemCloak.method_15441());
            }
        }
    }
}

