/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.networking;

import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.blocks.particle_spawner.ParticleSpawnerBlockEntity;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlock;
import de.dafuqs.spectrum.blocks.shooting_star.ShootingStarBlock;
import de.dafuqs.spectrum.entity.entity.ShootingStarEntity;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.effect.ExperienceTransfer;
import de.dafuqs.spectrum.particle.effect.ExperienceTransferParticleEffect;
import de.dafuqs.spectrum.particle.effect.ItemTransfer;
import de.dafuqs.spectrum.particle.effect.ItemTransferParticleEffect;
import de.dafuqs.spectrum.particle.effect.ParticleSpawnerParticleEffect;
import de.dafuqs.spectrum.particle.effect.Transphere;
import de.dafuqs.spectrum.particle.effect.TransphereParticleEffect;
import de.dafuqs.spectrum.particle.effect.WirelessRedstoneTransmission;
import de.dafuqs.spectrum.particle.effect.WirelessRedstoneTransmissionParticleEffect;
import de.dafuqs.spectrum.registries.color.ColorRegistry;
import de.dafuqs.spectrum.sound.BlockBoundSoundInstance;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1160;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import org.jetbrains.annotations.NotNull;

public class SpectrumS2CPackets {
    public static final class_2960 PLAY_LIGHT_CREATED_PACKET_ID = new class_2960("spectrum", "play_light_created_particle");
    public static final class_2960 PLAY_PEDESTAL_CRAFTING_FINISHED_PARTICLE_PACKET_ID = new class_2960("spectrum", "play_pedestal_crafting_finished_particle");
    public static final class_2960 PLAY_PEDESTAL_UPGRADED_PARTICLE_PACKET_ID = new class_2960("spectrum", "play_pedestal_upgraded_particle");
    public static final class_2960 PLAY_FUSION_CRAFTING_FINISHED_PARTICLE_PACKET_ID = new class_2960("spectrum", "play_fusion_crafting_finished_particle");
    public static final class_2960 PLAY_PARTICLE_AT_EXACT_BLOCK_POSITION_WITHOUT_VELOCITY_ID = new class_2960("spectrum", "play_particle");
    public static final class_2960 PLAY_PARTICLE_PACKET_WITH_RANDOM_OFFSET_AND_VELOCITY_ID = new class_2960("spectrum", "play_particle_with_offset");
    public static final class_2960 PLAY_PARTICLE_PACKET_WITH_EXACT_OFFSET_AND_VELOCITY_ID = new class_2960("spectrum", "play_particle_with_random_offset_and_velocity");
    public static final class_2960 CHANGE_PARTICLE_SPAWNER_SETTINGS_CLIENT_PACKET_ID = new class_2960("spectrum", "change_particle_spawner_settings_client");
    public static final class_2960 INITIATE_ITEM_TRANSFER = new class_2960("spectrum", "initiate_item_transfer");
    public static final class_2960 INITIATE_TRANSPHERE = new class_2960("spectrum", "initiate_transphere");
    public static final class_2960 INITIATE_EXPERIENCE_TRANSFER = new class_2960("spectrum", "initiate_experience_transfer");
    public static final class_2960 INITIATE_WIRELESS_REDSTONE_TRANSMISSION = new class_2960("spectrum", "initiate_wireless_redstone_transmission");
    public static final class_2960 PLAY_ITEM_ENTITY_ABSORBED_PARTICLE_EFFECT_PACKET_ID = new class_2960("spectrum", "item_entity_absorbed");
    public static final class_2960 PLAY_EXPERIENCE_ORB_ENTITY_ABSORBED_PARTICLE_EFFECT_PACKET_ID = new class_2960("spectrum", "experience_orb_entity_absorbed");
    public static final class_2960 PLAY_BLOCK_BOUND_SOUND_INSTANCE = new class_2960("spectrum", "play_pedestal_crafting_sound_instance");
    public static final class_2960 PLAY_SHOOTING_STAR_PARTICLES = new class_2960("spectrum", "play_shooting_star_particles");

    @Environment(value=EnvType.CLIENT)
    public static void registerS2CReceivers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_PARTICLE_AT_EXACT_BLOCK_POSITION_WITHOUT_VELOCITY_ID, (client, handler, buf, responseSender) -> {
            class_2338 position = buf.method_10811();
            class_2396 particleType = (class_2396)class_2378.field_11141.method_10223(buf.method_10810());
            int amount = buf.readInt();
            if (particleType instanceof class_2394) {
                class_2394 particleEffect = (class_2394)particleType;
                client.execute(() -> {
                    for (int i = 0; i < amount; ++i) {
                        class_310.method_1551().field_1724.method_5770().method_8406(particleEffect, (double)position.method_10263() + 0.5, (double)position.method_10264() + 0.5, (double)position.method_10260() + 0.5, 0.0, 0.0, 0.0);
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_PARTICLE_PACKET_WITH_RANDOM_OFFSET_AND_VELOCITY_ID, (client, handler, buf, responseSender) -> {
            class_243 position = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            class_2396 particleType = (class_2396)class_2378.field_11141.method_10223(buf.method_10810());
            int amount = buf.readInt();
            class_243 randomOffset = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            class_243 randomVelocity = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            if (particleType instanceof class_2394) {
                class_2394 particleEffect = (class_2394)particleType;
                client.execute(() -> {
                    Random random = client.field_1687.field_9229;
                    for (int i = 0; i < amount; ++i) {
                        double randomOffsetX = randomOffset.field_1352 - random.nextDouble() * randomOffset.field_1352 * 2.0;
                        double randomOffsetY = randomOffset.field_1351 - random.nextDouble() * randomOffset.field_1351 * 2.0;
                        double randomOffsetZ = randomOffset.field_1350 - random.nextDouble() * randomOffset.field_1350 * 2.0;
                        double randomVelocityX = randomVelocity.field_1352 - random.nextDouble() * randomVelocity.field_1352 * 2.0;
                        double randomVelocityY = randomVelocity.field_1351 - random.nextDouble() * randomVelocity.field_1351 * 2.0;
                        double randomVelocityZ = randomVelocity.field_1350 - random.nextDouble() * randomVelocity.field_1350 * 2.0;
                        class_310.method_1551().field_1724.method_5770().method_8406(particleEffect, position.method_10216() + randomOffsetX, position.method_10214() + randomOffsetY, position.method_10215() + randomOffsetZ, randomVelocityX, randomVelocityY, randomVelocityZ);
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_PARTICLE_PACKET_WITH_EXACT_OFFSET_AND_VELOCITY_ID, (client, handler, buf, responseSender) -> {
            class_243 position = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            class_2396 particleType = (class_2396)class_2378.field_11141.method_10223(buf.method_10810());
            int amount = buf.readInt();
            class_243 randomOffset = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            class_243 velocity = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            if (particleType instanceof class_2394) {
                class_2394 particleEffect = (class_2394)particleType;
                client.execute(() -> {
                    for (int i = 0; i < amount; ++i) {
                        class_310.method_1551().field_1724.method_5770().method_8406(particleEffect, position.method_10216() + randomOffset.field_1352, position.method_10214() + randomOffset.field_1351, position.method_10215() + randomOffset.field_1350, velocity.field_1352, velocity.field_1351, velocity.field_1350);
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_LIGHT_CREATED_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_2338 position = buf.method_10811();
            client.execute(() -> {
                Random random = client.field_1687.field_9229;
                for (int i = 0; i < 20; ++i) {
                    class_310.method_1551().field_1724.method_5770().method_8406((class_2394)SpectrumParticleTypes.SPARKLESTONE_SPARKLE, (double)position.method_10263() + 0.5, (double)position.method_10264() + 0.5, (double)position.method_10260() + 0.5, 0.3 - (double)random.nextFloat() * 0.6, 0.3 - (double)random.nextFloat() * 0.6, 0.3 - (double)random.nextFloat() * 0.6);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_PEDESTAL_CRAFTING_FINISHED_PARTICLE_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_2338 position = buf.method_10811();
            class_1799 itemStack = buf.method_10819();
            client.execute(() -> {
                Random random = client.field_1687.field_9229;
                for (int i = 0; i < 10; ++i) {
                    class_310.method_1551().field_1724.method_5770().method_8406((class_2394)new class_2392(class_2398.field_11218, itemStack), (double)position.method_10263() + 0.5, (double)(position.method_10264() + 1), (double)position.method_10260() + 0.5, 0.15 - (double)random.nextFloat() * 0.3, (double)random.nextFloat() * 0.15 + 0.1, 0.15 - (double)random.nextFloat() * 0.3);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_SHOOTING_STAR_PARTICLES, (client, handler, buf, responseSender) -> {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            ShootingStarBlock.Type shootingStarType = ShootingStarBlock.Type.getType(buf.readInt());
            client.execute(() -> ShootingStarEntity.playHitParticles(class_310.method_1551().field_1724.method_5770(), x, y, z, shootingStarType, 25));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_FUSION_CRAFTING_FINISHED_PARTICLE_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_2338 position = buf.method_10811();
            class_1767 dyeColor = class_1767.values()[buf.readInt()];
            client.execute(() -> {
                class_243 sourcePos = new class_243((double)position.method_10263() + 0.5, (double)(position.method_10264() + 1), (double)position.method_10260() + 0.5);
                class_1160 color = ColorRegistry.getColor(dyeColor);
                float velocityModifier = 0.25f;
                for (class_243 velocity : Support.VECTORS_16) {
                    class_310.method_1551().field_1724.method_5770().method_8406((class_2394)new ParticleSpawnerParticleEffect(new class_2960("spectrum:particle/liquid_crystal_sparkle"), 0.0f, color, 1.5f, 40, false, true), sourcePos.field_1352, sourcePos.field_1351, sourcePos.field_1350, velocity.field_1352 * (double)velocityModifier, 0.0, velocity.field_1350 * (double)velocityModifier);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_PEDESTAL_UPGRADED_PARTICLE_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_2338 position = buf.method_10811();
            PedestalBlock.PedestalVariant variant = PedestalBlock.PedestalVariant.values()[buf.readInt()];
            client.execute(() -> {
                Random random = client.field_1687.field_9229;
                PedestalBlock.spawnUpgradeParticleEffectsForTier(position, variant);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CHANGE_PARTICLE_SPAWNER_SETTINGS_CLIENT_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            if (class_310.method_1551().field_1687.method_8321(pos) instanceof ParticleSpawnerBlockEntity) {
                ((ParticleSpawnerBlockEntity)class_310.method_1551().field_1687.method_8321(pos)).applySettings(buf);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)INITIATE_ITEM_TRANSFER, (client, handler, buf, responseSender) -> {
            ItemTransfer itemTransfer = ItemTransfer.readFromBuf(buf);
            class_2338 blockPos = itemTransfer.getOrigin();
            client.execute(() -> {
                for (int i = 0; i < 10; ++i) {
                    class_310.method_1551().field_1724.method_5770().method_17452((class_2394)new ItemTransferParticleEffect(itemTransfer), true, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, 0.0, 0.0, 0.0);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)INITIATE_TRANSPHERE, (client, handler, buf, responseSender) -> {
            Transphere transphere = Transphere.readFromBuf(buf);
            class_2338 blockPos = transphere.getOrigin();
            client.execute(() -> {
                for (int i = 0; i < 10; ++i) {
                    class_310.method_1551().field_1724.method_5770().method_17452((class_2394)new TransphereParticleEffect(transphere), true, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, 0.0, 0.0, 0.0);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)INITIATE_EXPERIENCE_TRANSFER, (client, handler, buf, responseSender) -> {
            ExperienceTransfer experienceTransfer = ExperienceTransfer.readFromBuf(buf);
            class_2338 blockPos = experienceTransfer.getOrigin();
            client.execute(() -> {
                for (int i = 0; i < 10; ++i) {
                    class_310.method_1551().field_1724.method_5770().method_17452((class_2394)new ExperienceTransferParticleEffect(experienceTransfer), true, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, 0.0, 0.0, 0.0);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)INITIATE_WIRELESS_REDSTONE_TRANSMISSION, (client, handler, buf, responseSender) -> {
            WirelessRedstoneTransmission wirelessRedstoneTransmission = WirelessRedstoneTransmission.readFromBuf(buf);
            class_2338 blockPos = wirelessRedstoneTransmission.getOrigin();
            client.execute(() -> {
                for (int i = 0; i < 10; ++i) {
                    class_310.method_1551().field_1724.method_5770().method_17452((class_2394)new WirelessRedstoneTransmissionParticleEffect(wirelessRedstoneTransmission), true, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, 0.0, 0.0, 0.0);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_ITEM_ENTITY_ABSORBED_PARTICLE_EFFECT_PACKET_ID, (client, handler, buf, responseSender) -> {
            double posX = buf.readDouble();
            double posY = buf.readDouble();
            double posZ = buf.readDouble();
            client.execute(() -> class_310.method_1551().field_1724.method_5770().method_8406((class_2394)SpectrumParticleTypes.BLUE_BUBBLE_POP, posX, posY, posZ, 0.0, 0.0, 0.0));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_EXPERIENCE_ORB_ENTITY_ABSORBED_PARTICLE_EFFECT_PACKET_ID, (client, handler, buf, responseSender) -> {
            double posX = buf.readDouble();
            double posY = buf.readDouble();
            double posZ = buf.readDouble();
            client.execute(() -> class_310.method_1551().field_1724.method_5770().method_8406((class_2394)SpectrumParticleTypes.GREEN_BUBBLE_POP, posX, posY, posZ, 0.0, 0.0, 0.0));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_BLOCK_BOUND_SOUND_INSTANCE, (client, handler, buf, responseSender) -> {
            class_2960 soundEffectIdentifier = buf.method_10810();
            class_2960 blockIdentifier = buf.method_10810();
            class_2338 blockPos = buf.method_10811();
            int maxDurationTicks = buf.readInt();
            client.execute(() -> {
                if (soundEffectIdentifier.method_12832().equals("stop")) {
                    BlockBoundSoundInstance.stopPlayingOnPos(blockPos);
                } else {
                    class_3414 soundEvent = (class_3414)class_2378.field_11156.method_10223(soundEffectIdentifier);
                    class_2248 block = (class_2248)class_2378.field_11146.method_10223(blockIdentifier);
                    BlockBoundSoundInstance.startSoundInstance(soundEvent, blockPos, block, maxDurationTicks);
                }
            });
        });
    }

    public static void playParticleWithRandomOffsetAndVelocity(class_3218 world, class_2338 position, class_2960 particleEffectIdentifier, int amount) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(position);
        buf.method_10812(particleEffectIdentifier);
        buf.writeInt(amount);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)position)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_PARTICLE_AT_EXACT_BLOCK_POSITION_WITHOUT_VELOCITY_ID, (class_2540)buf);
        }
    }

    public static void playParticleWithRandomOffsetAndVelocity(class_3218 world, class_2338 position, class_2396 particleEffect, int amount) {
        SpectrumS2CPackets.playParticleWithRandomOffsetAndVelocity(world, position, class_2378.field_11141.method_10221((Object)particleEffect), amount);
    }

    public static void playParticleWithRandomOffsetAndVelocity(class_3218 world, class_243 position, class_2960 particleEffectIdentifier, int amount, class_243 randomOffset, class_243 randomVelocity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(position.field_1352);
        buf.writeDouble(position.field_1351);
        buf.writeDouble(position.field_1350);
        buf.method_10812(particleEffectIdentifier);
        buf.writeInt(amount);
        buf.writeDouble(randomOffset.field_1352);
        buf.writeDouble(randomOffset.field_1351);
        buf.writeDouble(randomOffset.field_1350);
        buf.writeDouble(randomVelocity.field_1352);
        buf.writeDouble(randomVelocity.field_1351);
        buf.writeDouble(randomVelocity.field_1350);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)new class_2338(position))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_PARTICLE_PACKET_WITH_RANDOM_OFFSET_AND_VELOCITY_ID, (class_2540)buf);
        }
    }

    public static void playParticleWithExactOffsetAndVelocity(class_3218 world, class_243 position, class_2394 particleEffect, int amount, class_243 randomOffset, class_243 randomVelocity) {
        SpectrumS2CPackets.playParticleWithExactOffsetAndVelocity(world, position, class_2378.field_11141.method_10221((Object)particleEffect.method_10295()), amount, randomOffset, randomVelocity);
    }

    public static void playParticleWithExactOffsetAndVelocity(class_3218 world, class_243 position, class_2960 particleEffectIdentifier, int amount, class_243 randomOffset, class_243 velocity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(position.field_1352);
        buf.writeDouble(position.field_1351);
        buf.writeDouble(position.field_1350);
        buf.method_10812(particleEffectIdentifier);
        buf.writeInt(amount);
        buf.writeDouble(randomOffset.field_1352);
        buf.writeDouble(randomOffset.field_1351);
        buf.writeDouble(randomOffset.field_1350);
        buf.writeDouble(velocity.field_1352);
        buf.writeDouble(velocity.field_1351);
        buf.writeDouble(velocity.field_1350);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)new class_2338(position))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_PARTICLE_PACKET_WITH_EXACT_OFFSET_AND_VELOCITY_ID, (class_2540)buf);
        }
    }

    public static void playParticleWithRandomOffsetAndVelocity(class_3218 world, class_243 position, class_2394 particleEffect, int amount, class_243 randomOffset, class_243 randomVelocity) {
        SpectrumS2CPackets.playParticleWithRandomOffsetAndVelocity(world, position, class_2378.field_11141.method_10221((Object)particleEffect.method_10295()), amount, randomOffset, randomVelocity);
    }

    public static void sendLightCreatedParticle(class_1937 world, class_2338 blockPos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_LIGHT_CREATED_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPlayPedestalCraftingFinishedParticle(class_1937 world, class_2338 blockPos, class_1799 itemStack) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        buf.method_10793(itemStack);
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_PEDESTAL_CRAFTING_FINISHED_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPlayFusionCraftingFinishedParticles(class_1937 world, class_2338 blockPos, class_1799 itemStack) {
        Optional<class_1767> optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(itemStack.method_7909());
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        if (optionalItemColor.isPresent()) {
            buf.writeInt(optionalItemColor.get().ordinal());
        } else {
            buf.writeInt(class_1767.field_7967.ordinal());
        }
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_FUSION_CRAFTING_FINISHED_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendItemTransferPacket(class_3218 world, @NotNull ItemTransfer itemTransfer) {
        class_2338 blockPos = itemTransfer.getOrigin();
        class_2540 buf = PacketByteBufs.create();
        ItemTransfer.writeToBuf(buf, itemTransfer);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)INITIATE_ITEM_TRANSFER, (class_2540)buf);
        }
    }

    public static void playTransphereParticle(class_3218 world, @NotNull Transphere transphere) {
        class_2338 blockPos = transphere.getOrigin();
        class_2540 buf = PacketByteBufs.create();
        Transphere.writeToBuf(buf, transphere);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)INITIATE_TRANSPHERE, (class_2540)buf);
        }
    }

    public static void sendExperienceOrbTransferPacket(class_3218 world, @NotNull ExperienceTransfer experienceTransfer) {
        class_2338 blockPos = experienceTransfer.getOrigin();
        class_2540 buf = PacketByteBufs.create();
        ExperienceTransfer.writeToBuf(buf, experienceTransfer);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)INITIATE_EXPERIENCE_TRANSFER, (class_2540)buf);
        }
    }

    public static void sendWirelessRedstonePacket(class_3218 world, WirelessRedstoneTransmission wirelessRedstoneTransmission) {
        class_2338 blockPos = wirelessRedstoneTransmission.getOrigin();
        class_2540 buf = PacketByteBufs.create();
        WirelessRedstoneTransmission.writeToBuf(buf, wirelessRedstoneTransmission);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)INITIATE_WIRELESS_REDSTONE_TRANSMISSION, (class_2540)buf);
        }
    }

    public static void sendPlayItemEntityAbsorbedParticle(class_1937 world, @NotNull class_1542 itemEntity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(itemEntity.method_19538().field_1352);
        buf.writeDouble(itemEntity.method_19538().field_1351);
        buf.writeDouble(itemEntity.method_19538().field_1350);
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)itemEntity.method_24515())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_ITEM_ENTITY_ABSORBED_PARTICLE_EFFECT_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPlayExperienceOrbEntityAbsorbedParticle(class_1937 world, @NotNull class_1303 experienceOrbEntity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(experienceOrbEntity.method_19538().field_1352);
        buf.writeDouble(experienceOrbEntity.method_19538().field_1351);
        buf.writeDouble(experienceOrbEntity.method_19538().field_1350);
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)experienceOrbEntity.method_24515())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_EXPERIENCE_ORB_ENTITY_ABSORBED_PARTICLE_EFFECT_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPlayBlockBoundSoundInstance(class_3414 soundEvent, class_3218 world, class_2338 blockPos, int maxDurationTicks) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(class_2378.field_11156.method_10221((Object)soundEvent));
        buf.method_10812(class_2378.field_11146.method_10221((Object)world.method_8320(blockPos).method_26204()));
        buf.method_10807(blockPos);
        buf.writeInt(maxDurationTicks);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_BLOCK_BOUND_SOUND_INSTANCE, (class_2540)buf);
        }
    }

    public static void sendCancelBlockBoundSoundInstance(class_3218 world, class_2338 blockPos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(new class_2960("stop"));
        buf.method_10812(class_2378.field_11146.method_10221((Object)world.method_8320(blockPos).method_26204()));
        buf.method_10807(blockPos);
        buf.writeInt(1);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_BLOCK_BOUND_SOUND_INSTANCE, (class_2540)buf);
        }
    }

    public static void spawnPedestalUpgradeParticles(class_1937 world, class_2338 blockPos, PedestalBlock.PedestalVariant newPedestalVariant) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        buf.writeInt(newPedestalVariant.ordinal());
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_PEDESTAL_UPGRADED_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPlayShootingStarParticles(ShootingStarEntity shootingStarEntity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(shootingStarEntity.method_19538().method_10216());
        buf.writeDouble(shootingStarEntity.method_19538().method_10214());
        buf.writeDouble(shootingStarEntity.method_19538().method_10215());
        buf.writeInt(shootingStarEntity.getShootingStarType().ordinal());
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)shootingStarEntity.field_6002), (class_2338)shootingStarEntity.method_24515())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PLAY_SHOOTING_STAR_PARTICLES, (class_2540)buf);
        }
    }
}

