/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.interfaces.GravitableItem;
import de.dafuqs.spectrum.inventories.AutoCompactingInventory;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.anvil_crushing.AnvilCrushingRecipe;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItemStackDamageImmunities;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin {
    private static AutoCompactingInventory autoCompactingInventory;

    @Shadow
    public abstract class_1799 method_6983();

    @Shadow
    public abstract void method_35190();

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;DDD)V"})
    public void ItemEntity(class_1937 world, double x, double y, double z, class_1799 stack, double velocityX, double velocityY, double velocityZ, CallbackInfo ci) {
        if (class_1890.method_8225((class_1887)SpectrumEnchantments.DAMAGE_PROOF, (class_1799)stack) > 0) {
            this.method_35190();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tick(CallbackInfo ci) {
        class_1542 thisItemEntity = (class_1542)this;
        if (!thisItemEntity.method_5740() && thisItemEntity.field_6002.method_8510() % 8L == 0L) {
            int worldMinY = thisItemEntity.field_6002.method_8597().method_29959();
            if (!thisItemEntity.method_24828() && thisItemEntity.method_19538().method_10214() < (double)(worldMinY + 2) && class_1890.method_8225((class_1887)SpectrumEnchantments.DAMAGE_PROOF, (class_1799)thisItemEntity.method_6983()) > 0) {
                if (thisItemEntity.method_19538().method_10214() < (double)(worldMinY + 1)) {
                    thisItemEntity.method_5814(thisItemEntity.method_19538().field_1352, (double)(worldMinY + 1), thisItemEntity.method_19538().field_1350);
                }
                thisItemEntity.method_18800(0.0, 0.0, 0.0);
                thisItemEntity.method_5875(true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, cancellable=true)
    public void spectrumItemStackDamageActions(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (class_1282.field_5865.equals(source) || SpectrumDamageSources.FLOATBLOCK.equals(source)) {
            this.doAnvilCrafting(amount);
            callbackInfoReturnable.setReturnValue((Object)true);
        }
        if (amount > 1.0f && source.method_5535() && this.method_6983().method_31574((class_1792)SpectrumItems.LIGHTNING_STONE)) {
            this.doLightningExplosion();
        }
    }

    private void doAnvilCrafting(float damageAmount) {
        class_1542 thisEntity = (class_1542)this;
        class_1799 thisItemStack = thisEntity.method_6983();
        class_1937 world = thisEntity.method_5770();
        if (autoCompactingInventory == null) {
            autoCompactingInventory = new AutoCompactingInventory();
        }
        autoCompactingInventory.setCompacting(AutoCompactingInventory.AutoCraftingMode.OneXOne, thisItemStack);
        Optional optionalAnvilCrushingRecipe = SpectrumCommon.minecraftServer.method_3772().method_8132(SpectrumRecipeTypes.ANVIL_CRUSHING, (class_1263)autoCompactingInventory, world);
        if (optionalAnvilCrushingRecipe.isPresent()) {
            AnvilCrushingRecipe recipe = (AnvilCrushingRecipe)optionalAnvilCrushingRecipe.get();
            int itemStackAmount = thisEntity.method_6983().method_7947();
            int crushingInputAmount = Math.min(itemStackAmount, (int)(recipe.getCrushedItemsPerPointOfDamage() * damageAmount));
            if (crushingInputAmount > 0) {
                class_3414 soundEvent;
                class_243 position = thisEntity.method_19538();
                class_1799 crushingOutput = recipe.getOutputItemStack();
                crushingOutput.method_7939(crushingOutput.method_7947() * crushingInputAmount);
                int remainingItemStackAmount = itemStackAmount - crushingInputAmount;
                if (remainingItemStackAmount > 0) {
                    thisItemStack.method_7939(remainingItemStackAmount);
                } else {
                    thisEntity.method_5650(class_1297.class_5529.field_26999);
                }
                class_1542 craftedEntity = new class_1542(world, position.field_1352, position.field_1351, position.field_1350, crushingOutput);
                world.method_8649((class_1297)craftedEntity);
                float craftingXPFloat = recipe.getExperience() * (float)crushingInputAmount;
                int craftingXP = Support.getIntFromDecimalWithChance(craftingXPFloat, world.field_9229);
                if (craftingXP > 0) {
                    class_1303 experienceOrbEntity = new class_1303(world, position.field_1352, position.field_1351, position.field_1350, craftingXP);
                    world.method_8649((class_1297)experienceOrbEntity);
                }
                if ((soundEvent = recipe.getSoundEvent()) != null) {
                    float randomVolume = 1.0f + world.method_8409().nextFloat() * 0.2f;
                    float randomPitch = 0.9f + world.method_8409().nextFloat() * 0.2f;
                    world.method_8465(null, position.field_1352, position.field_1351, position.field_1350, soundEvent, class_3419.field_15248, randomVolume, randomPitch);
                }
                SpectrumS2CPackets.playParticleWithRandomOffsetAndVelocity((class_3218)world, new class_2338(position), recipe.getParticleEffectIdentifier(), recipe.getParticleCount());
            }
        }
    }

    private void doLightningExplosion() {
        class_1538 lightningEntity;
        class_1542 thisEntity = (class_1542)this;
        class_1799 thisItemStack = thisEntity.method_6983();
        class_1937 world = thisEntity.method_5770();
        class_2338 blockPos = thisEntity.method_24515();
        class_243 pos = thisEntity.method_19538();
        int count = thisItemStack.method_7947();
        thisEntity.method_5650(class_1297.class_5529.field_26998);
        if (world.method_8311(thisEntity.method_24515()) && (lightningEntity = (class_1538)class_1299.field_6112.method_5883(world)) != null) {
            lightningEntity.method_29495(class_243.method_24955((class_2382)blockPos));
            world.method_8649((class_1297)lightningEntity);
        }
        float powerMod = 1.0f;
        class_1959 biomeAtPos = world.method_23753(blockPos);
        if (!biomeAtPos.method_39929(blockPos) && !biomeAtPos.method_33599(blockPos)) {
            powerMod = world.method_8546() ? 1.5f : (world.method_8419() ? 1.25f : 1.0f);
        }
        world.method_8437((class_1297)thisEntity, pos.method_10216(), pos.method_10214(), pos.method_10215(), (float)count * powerMod, class_1927.class_4179.field_18686);
    }

    @Inject(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isDamageProof(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        boolean isImmune;
        class_1799 itemStack = ((class_1542)this).method_6983();
        if (itemStack != class_1799.field_8037 && source != class_1282.field_5849 && (isImmune = SpectrumItemStackDamageImmunities.isDamageImmune(itemStack, source))) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"Lnet/minecraft/entity/ItemEntity;isFireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isFireProof(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        boolean isImmune;
        class_1799 itemStack = ((class_1542)this).method_6983();
        if (itemStack != class_1799.field_8037 && (isImmune = SpectrumItemStackDamageImmunities.isFireDamageImmune(itemStack))) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void doGravityEffects(CallbackInfo ci) {
        class_1542 itemEntity = (class_1542)this;
        class_1792 item = itemEntity.method_6983().method_7909();
        if (item instanceof GravitableItem) {
            if (itemEntity.method_19538().method_10214() > (double)(itemEntity.method_5770().method_31600() + 200)) {
                itemEntity.method_31472();
            } else {
                double mod = ((GravitableItem)item).getGravityModForItemEntity();
                itemEntity.method_5762(0.0, mod, 0.0);
            }
        }
    }
}

