/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.enchantments.AutoSmeltEnchantment;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2248.class})
public abstract class BlockMixin {
    class_1657 breakingPlayer;

    @Inject(method={"getDroppedStacks(Lnet/minecraft/block/BlockState;Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)Ljava/util/List;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getDroppedStacks(class_2680 state, class_3218 world, class_2338 pos, class_2586 blockEntity, class_1297 entity, class_1799 stack, CallbackInfoReturnable<List<class_1799>> cir) {
        List<class_1799> returnStacks = (List<class_1799>)cir.getReturnValue();
        if (returnStacks.size() > 0) {
            Map enchantmentMap = class_1890.method_8222((class_1799)stack);
            if (enchantmentMap.containsKey((Object)SpectrumEnchantments.VOIDING)) {
                world.method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.05);
                cir.setReturnValue(new ArrayList());
            } else {
                if (enchantmentMap.containsKey((Object)SpectrumEnchantments.AUTO_SMELT) && SpectrumEnchantments.AUTO_SMELT.canEntityUse(entity)) {
                    returnStacks = AutoSmeltEnchantment.applyAutoSmelt(world, returnStacks);
                }
                if (enchantmentMap.containsKey((Object)SpectrumEnchantments.INVENTORY_INSERTION) && SpectrumEnchantments.INVENTORY_INSERTION.canEntityUse(entity)) {
                    ArrayList<class_1799> leftoverReturnStacks = new ArrayList<class_1799>();
                    if (entity instanceof class_1657) {
                        class_1657 playerEntity = (class_1657)entity;
                        for (class_1799 itemStack : returnStacks) {
                            class_1792 item = itemStack.method_7909();
                            int count = itemStack.method_7947();
                            if (playerEntity.method_31548().method_7394(itemStack)) {
                                if (itemStack.method_7960()) {
                                    itemStack.method_7939(count);
                                }
                                playerEntity.method_7342(class_3468.field_15392.method_14956((Object)item), count);
                                continue;
                            }
                            leftoverReturnStacks.add(itemStack);
                        }
                    }
                    returnStacks = leftoverReturnStacks;
                }
                cir.setReturnValue((Object)returnStacks);
            }
        }
    }

    private float getExuberanceMod(class_1657 breakingPlayer) {
        if (breakingPlayer != null && class_1890.method_8225((class_1887)SpectrumEnchantments.EXUBERANCE, (class_1799)breakingPlayer.method_6047()) > 0) {
            int exuberanceLevel = class_1890.method_8203((class_1887)SpectrumEnchantments.EXUBERANCE, (class_1309)breakingPlayer);
            return 1.0f + (float)exuberanceLevel * SpectrumCommon.CONFIG.ExuberanceBonusExperiencePercentPerLevel;
        }
        return 1.0f;
    }

    @Inject(method={"afterBreak"}, at={@At(value="HEAD")})
    private void savePlayerReference(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity, class_1799 stack, CallbackInfo ci) {
        this.breakingPlayer = player;
    }

    @ModifyArg(method={"dropExperience"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V"), index=2)
    private int applyExuberance(int originalXP) {
        return (int)((float)originalXP * this.getExuberanceMod(this.breakingPlayer));
    }
}

