/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.InventoryHelper;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterEnchantable;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.sound.SpectrumSoundEvents;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5328;

public class RadianceStaffItem
extends class_1792
implements EnchanterEnchantable {
    public static int USE_DURATION = 12;
    public static int REACH_STEP_DISTANCE = 4;
    public static int MAX_REACH_STEPS = 8;
    public static int MIN_LIGHT_LEVEL = 10;
    public static class_1799 COST = new class_1799((class_1935)SpectrumItems.SPARKLESTONE_GEM, 1);

    public RadianceStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        if (class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)itemStack) == 0) {
            tooltip.add((class_2561)new class_2588("item.spectrum.light_staff.tooltip"));
        }
        tooltip.add((class_2561)new class_2588("item.spectrum.light_staff.tooltip2"));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8949;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.field_9236) {
            world.method_8465(null, user.method_23317(), user.method_23318(), user.method_23321(), SpectrumSoundEvents.LIGHT_STAFF_CHARGING, class_3419.field_15248, 1.0f, 1.0f);
        }
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (world instanceof class_3218 && user.method_6048() > USE_DURATION && user.method_6048() % USE_DURATION == 0) {
            this.usage(world, stack, user);
        }
    }

    public void usage(class_1937 world, class_1799 stack, class_1309 user) {
        if (user instanceof class_1657) {
            class_1657 playerEntity = (class_1657)user;
            int useTimes = user.method_6048() / USE_DURATION;
            int maxCheckDistance = Math.min(MAX_REACH_STEPS, useTimes);
            class_2338 sourcePos = user.method_24515();
            class_243 cameraVec = user.method_5828(0.0f);
            for (int iteration = 1; iteration < maxCheckDistance; ++iteration) {
                class_2338 targetPos = sourcePos.method_10080(cameraVec.field_1352 * (double)iteration * (double)REACH_STEP_DISTANCE, cameraVec.field_1351 * (double)iteration * (double)REACH_STEP_DISTANCE, cameraVec.field_1350 * (double)iteration * 4.0);
                if (world.method_8314(class_1944.field_9282, targetPos = targetPos.method_10069(iteration - world.method_8409().nextInt(2 * iteration), iteration - world.method_8409().nextInt(2 * iteration), iteration - world.method_8409().nextInt(2 * iteration))) >= MIN_LIGHT_LEVEL) continue;
                if (RadianceStaffItem.placeLight(world, targetPos, playerEntity, stack)) {
                    RadianceStaffItem.playSoundAndParticles(world, targetPos, playerEntity, useTimes, iteration);
                    break;
                }
                RadianceStaffItem.playDenySound(world, playerEntity);
                break;
            }
        }
    }

    public static boolean placeLight(class_1937 world, class_2338 targetPos, class_1657 playerEntity, class_1799 stack) {
        class_2680 targetBlockState = world.method_8320(targetPos);
        if (targetBlockState.method_26215()) {
            if (class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)stack) > 0 || InventoryHelper.removeFromInventory(playerEntity, COST)) {
                world.method_8652(targetPos, SpectrumBlocks.WAND_LIGHT_BLOCK.method_9564(), 3);
                return true;
            }
        } else if (targetBlockState.method_27852(class_2246.field_10382) && (class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)stack) > 0 || InventoryHelper.removeFromInventory(playerEntity, COST))) {
            world.method_8652(targetPos, (class_2680)SpectrumBlocks.WAND_LIGHT_BLOCK.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    public static void playSoundAndParticles(class_1937 world, class_2338 targetPos, class_1657 playerEntity, int useTimes, int iteration) {
        float pitch = useTimes % 2 == 0 ? Math.min(1.35f, 0.7f + 0.1f * (float)useTimes) : Math.min(1.5f, 0.7f + 0.1f * (float)useTimes);
        SpectrumS2CPackets.sendLightCreatedParticle(world, targetPos);
        world.method_8465(null, playerEntity.method_23317() + 0.5, playerEntity.method_23318() + 0.5, playerEntity.method_23321() + 0.5, SpectrumSoundEvents.LIGHT_STAFF_PLACE, class_3419.field_15248, (float)Math.max(0.25, (double)(1.0f - (float)iteration * 0.1f)), pitch);
    }

    public static void playDenySound(class_1937 world, class_1657 playerEntity) {
        world.method_8465(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 1.0f, 0.8f + playerEntity.method_6051().nextFloat() * 0.4f);
    }

    @Override
    public boolean canAcceptEnchantment(class_1887 enchantment) {
        return enchantment == class_1893.field_9125;
    }

    public int method_7837() {
        return 8;
    }
}

