/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.BuildingHelper;
import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterEnchantable;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.items.magic_items.BuildingStaffItem;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.sound.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Triplet;

public class ExchangeStaffItem
extends BuildingStaffItem
implements EnchanterEnchantable {
    public static final int CREATIVE_RANGE = 5;

    public ExchangeStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static int getRange(class_1657 playerEntity) {
        if (playerEntity == null || playerEntity.method_7337()) {
            return 5;
        }
        Optional<PedestalRecipeTier> highestUnlockedRecipeTier = PedestalRecipeTier.getHighestUnlockedRecipeTier(playerEntity);
        if (highestUnlockedRecipeTier.isPresent()) {
            switch (highestUnlockedRecipeTier.get()) {
                case COMPLEX: {
                    return 5;
                }
                case ADVANCED: {
                    return 4;
                }
            }
            return 3;
        }
        return 2;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)new class_2588("item.spectrum.exchange_staff.tooltip.range", new Object[]{ExchangeStaffItem.getRange((class_1657)class_310.method_1551().field_1724)}).method_27692(class_124.field_1080));
        tooltip.add((class_2561)new class_2588("item.spectrum.exchange_staff.tooltip.crouch").method_27692(class_124.field_1080));
        Optional<class_2248> optionalBlock = ExchangeStaffItem.getBlockTarget(stack);
        if (optionalBlock.isPresent()) {
            tooltip.add((class_2561)new class_2588("item.spectrum.exchange_staff.tooltip.target", new Object[]{optionalBlock.get().method_9518()}).method_27692(class_124.field_1080));
        }
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 targetBlockState = world.method_8320(pos);
        class_2248 targetBlock = targetBlockState.method_26204();
        class_1269 result = class_1269.field_5814;
        if (!ExchangeStaffItem.isBlacklisted(targetBlock)) {
            class_1792 targetBlockItem = targetBlockState.method_26204().method_8389();
            if (player != null && targetBlockItem != class_1802.field_8162 && context.method_20287() == class_1268.field_5808) {
                if (player.method_5715()) {
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        this.storeBlockAsTarget(context.method_8041(), targetBlock);
                        world.method_8396(null, player.method_24515(), SpectrumSoundEvents.EXCHANGE_STAFF_SELECT, class_3419.field_15248, 1.0f, 1.0f);
                        class_2350 side = context.method_8038();
                        class_243 sourcePos = new class_243(context.method_17698().method_10216() + (double)side.method_10148() * 0.1, context.method_17698().method_10214() + (double)side.method_10164() * 0.1, context.method_17698().method_10215() + (double)side.method_10165() * 0.1);
                        SpectrumS2CPackets.playParticleWithRandomOffsetAndVelocity(serverWorld, sourcePos, (class_2394)SpectrumParticleTypes.SPARKLESTONE_SPARKLE_SMALL, 15, new class_243(0.0, 0.0, 0.0), new class_243(0.25, 0.25, 0.25));
                        result = class_1269.field_21466;
                    } else {
                        result = class_1269.field_5812;
                    }
                } else {
                    Optional<class_2248> exchangeBlock = ExchangeStaffItem.getBlockTarget(context.method_8041());
                    if (exchangeBlock.isPresent() && exchangeBlock.get().method_8389() != class_1802.field_8162 && exchangeBlock.get() != targetBlock) {
                        result = ExchangeStaffItem.exchange(world, pos, player, exchangeBlock.get(), context.method_8041());
                    }
                }
            }
        }
        if (result == class_1269.field_5814 && player != null) {
            world.method_8396(null, player.method_24515(), class_3417.field_14701, class_3419.field_15248, 1.0f, 1.0f);
        }
        return result;
    }

    public void storeBlockAsTarget(class_1799 exchangeStaffItemStack, class_2248 block) {
        class_2487 compound = exchangeStaffItemStack.method_7948();
        class_2960 blockIdentifier = class_2378.field_11146.method_10221((Object)block);
        compound.method_10582("TargetBlock", blockIdentifier.toString());
        exchangeStaffItemStack.method_7980(compound);
    }

    public static Optional<class_2248> getBlockTarget(class_1799 exchangeStaffItemStack) {
        String targetBlockString;
        class_2248 targetBlock;
        class_2487 compound = exchangeStaffItemStack.method_7948();
        if (compound.method_10545("TargetBlock") && (targetBlock = (class_2248)class_2378.field_11146.method_10223(new class_2960(targetBlockString = compound.method_10558("TargetBlock")))) != class_2246.field_10124) {
            return Optional.of(targetBlock);
        }
        return Optional.empty();
    }

    public static class_1269 exchange(class_1937 world, class_2338 pos, @NotNull class_1657 player, @NotNull class_2248 targetBlock, class_1799 exchangeStaffItemStack) {
        return ExchangeStaffItem.exchange(world, pos, player, targetBlock, exchangeStaffItemStack, false);
    }

    public static class_1269 exchange(class_1937 world, class_2338 pos, @NotNull class_1657 player, @NotNull class_2248 targetBlock, class_1799 exchangeStaffItemStack, boolean single) {
        int exchangedForBlockItemCount;
        class_2680 targetBlockState;
        class_1792 exchangedForBlockItem = targetBlock.method_8389();
        class_2680 placedBlockState = targetBlockState = targetBlock.method_9564();
        if (player.method_7337()) {
            exchangedForBlockItemCount = Integer.MAX_VALUE;
        } else {
            Triplet<class_2248, class_1792, Integer> exchangeData = BuildingHelper.getBuildingItemCountInInventoryIncludingSimilars(player, targetBlock);
            if (targetBlock != exchangeData.getA()) {
                placedBlockState = ((class_2248)exchangeData.getA()).method_9564();
            }
            exchangedForBlockItem = (class_1792)exchangeData.getB();
            exchangedForBlockItemCount = (Integer)exchangeData.getC();
        }
        if (single) {
            exchangedForBlockItemCount = Math.min(1, exchangedForBlockItemCount);
        }
        if (exchangedForBlockItemCount > 0) {
            int range = ExchangeStaffItem.getRange(player);
            List<class_2338> targetPositions = BuildingHelper.getConnectedBlocks(world, pos, exchangedForBlockItemCount, range);
            if (targetPositions.isEmpty()) {
                return class_1269.field_5814;
            }
            int blocksReplaced = 0;
            if (!world.field_9236) {
                ArrayList stacks = new ArrayList();
                for (class_2338 targetPosition : targetPositions) {
                    if (!player.method_7337()) {
                        class_2680 droppedStacks = world.method_8320(targetPosition);
                        stacks.addAll(class_2248.method_9609((class_2680)droppedStacks, (class_3218)((class_3218)world), (class_2338)targetPosition, (class_2586)world.method_8321(targetPosition), (class_1297)player, (class_1799)exchangeStaffItemStack));
                    }
                    world.method_8501(targetPosition, class_2246.field_10124.method_9564());
                    if (targetBlockState.method_26184((class_4538)world, targetPosition)) {
                        world.method_8501(targetPosition, placedBlockState);
                    } else {
                        class_1542 itemEntity = new class_1542(world, (double)targetPosition.method_10263(), (double)targetPosition.method_10264(), (double)targetPosition.method_10260(), new class_1799((class_1935)exchangedForBlockItem));
                        itemEntity.method_6984(player.method_5667());
                        itemEntity.method_6975();
                        world.method_8649((class_1297)itemEntity);
                    }
                    ++blocksReplaced;
                }
                if (!player.method_7337()) {
                    class_1792 finalExchangedForBlockItem = exchangedForBlockItem;
                    player.method_31548().method_29280(stack -> stack.method_7909().equals(finalExchangedForBlockItem), targetPositions.size(), (class_1263)player.method_31548());
                    for (class_1799 stack2 : stacks) {
                        Support.givePlayer(player, stack2);
                    }
                }
                if (blocksReplaced > 0) {
                    world.method_8396(null, player.method_24515(), targetBlockState.method_26231().method_10598(), class_3419.field_15248, targetBlockState.method_26231().method_10597(), targetBlockState.method_26231().method_10599());
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    @Override
    public boolean canAcceptEnchantment(class_1887 enchantment) {
        return enchantment == class_1893.field_9130 || enchantment == class_1893.field_9099;
    }

    public int method_7837() {
        return 3;
    }
}

