/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.SpectrumClient;
import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterEnchantable;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.sound.EnderSpliceChargingSoundInstance;
import de.dafuqs.spectrum.sound.SpectrumSoundEvents;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2660;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3545;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5454;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderSpliceItem
extends class_1792
implements EnchanterEnchantable {
    public EnderSpliceItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1799 method_7861(class_1799 itemStack, class_1937 world, class_1309 user) {
        if (world.field_9236) {
            if (this.getTeleportTargetPos(itemStack).isEmpty() && this.getTeleportTargetPlayerUUID(itemStack).isEmpty()) {
                this.interactWithEntityClient(user);
            }
        } else {
            class_1657 playerEntity;
            class_1657 class_16572 = playerEntity = user instanceof class_1657 ? (class_1657)user : null;
            if (playerEntity instanceof class_3222) {
                class_174.field_1198.method_8821((class_3222)playerEntity, itemStack);
            }
            boolean resonance = class_1890.method_8225((class_1887)SpectrumEnchantments.RESONANCE, (class_1799)itemStack) > 0;
            Optional<class_3545<String, class_243>> teleportTargetPos = this.getTeleportTargetPos(itemStack);
            if (teleportTargetPos.isPresent()) {
                class_5321 targetWorldKey = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960((String)teleportTargetPos.get().method_15442()));
                class_3218 targetWorld = world.method_8503().method_3847(targetWorldKey);
                this.teleportPlayerToPos(world, user, playerEntity, (class_1937)targetWorld, (class_243)teleportTargetPos.get().method_15441(), resonance);
            } else {
                Optional<UUID> teleportTargetPlayerUUID = this.getTeleportTargetPlayerUUID(itemStack);
                if (teleportTargetPlayerUUID.isPresent()) {
                    this.teleportPlayerToPlayerWithUUID(world, user, playerEntity, teleportTargetPlayerUUID.get(), resonance);
                } else {
                    this.setTeleportTargetPos(itemStack, playerEntity.method_5770(), playerEntity.method_19538());
                    ((class_3222)playerEntity).field_13987.method_14364((class_2596)new class_2660(SpectrumSoundEvents.ENDER_SPLICE_BOUND.method_14833(), class_3419.field_15248, playerEntity.method_19538(), 1.0f, 1.0f));
                }
            }
            playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
            if (!playerEntity.method_31549().field_7477) {
                int unbreakingLevel = class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)itemStack);
                if (unbreakingLevel == 0) {
                    itemStack.method_7934(1);
                } else {
                    itemStack.method_7934(Support.getIntFromDecimalWithChance(1.0 / (double)(1 + unbreakingLevel), world.field_9229));
                }
            }
        }
        return itemStack;
    }

    @Environment(value=EnvType.CLIENT)
    public void interactWithEntityClient(class_1309 user) {
        class_239 hitResult = class_310.method_1551().field_1765;
        if (hitResult.method_17783() == class_239.class_240.field_1331) {
            class_3966 entityHitResult = (class_3966)hitResult;
            class_310.method_1551().field_1761.method_2905((class_1657)class_310.method_1551().field_1724, entityHitResult.method_17782(), user.method_6058());
        }
    }

    private void teleportPlayerToPlayerWithUUID(class_1937 world, class_1309 user, class_1657 playerEntity, UUID targetPlayerUUID, boolean hasResonance) {
        class_1657 targetPlayer = PlayerOwned.getPlayerEntityIfOnline(world, targetPlayerUUID);
        if (targetPlayer != null) {
            this.teleportPlayerToPos(targetPlayer.method_5770(), user, playerEntity, targetPlayer.method_5770(), targetPlayer.method_19538(), hasResonance);
        }
    }

    private void teleportPlayerToPos(class_1937 world, class_1309 user, class_1657 playerEntity, class_1937 targetWorld, class_243 targetPos, boolean hasResonance) {
        boolean isSameWorld = EnderSpliceItem.isSameWorld(user.method_5770(), targetWorld);
        if (hasResonance || isSameWorld) {
            class_243 currentPos = playerEntity.method_19538();
            world.method_8465(playerEntity, currentPos.method_10216(), currentPos.method_10214(), currentPos.method_10215(), SpectrumSoundEvents.PLAYER_TELEPORTS, class_3419.field_15248, 1.0f, 1.0f);
            if (!isSameWorld) {
                FabricDimensions.teleport((class_1297)user, (class_3218)((class_3218)targetWorld), (class_5454)new class_5454(targetPos.method_1031(0.0, 0.25, 0.0), new class_243(0.0, 0.0, 0.0), user.method_36454(), user.method_36455()));
            } else {
                user.method_5859(targetPos.method_10216(), targetPos.field_1351 + 0.25, targetPos.field_1350);
            }
            world.method_8465(playerEntity, targetPos.method_10216(), targetPos.field_1351, targetPos.field_1350, SpectrumSoundEvents.PLAYER_TELEPORTS, class_3419.field_15248, 1.0f, 1.0f);
            if (playerEntity instanceof class_3222) {
                ((class_3222)playerEntity).field_13987.method_14364((class_2596)new class_2660(SpectrumSoundEvents.PLAYER_TELEPORTS.method_14833(), class_3419.field_15248, playerEntity.method_19538(), 1.0f, 1.0f));
                ((class_3222)playerEntity).field_13987.method_14364((class_2596)new class_2660(class_3417.field_15081.method_14833(), class_3419.field_15248, playerEntity.method_19538(), 1.0f, 1.0f));
            }
        }
    }

    public static boolean isSameWorld(class_1937 world1, class_1937 world2) {
        return world1.method_27983().method_29177().toString().equals(world2.method_27983().method_29177().toString());
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (user.method_6048() >= this.method_7881(stack) && entity instanceof class_1657 && this.getTeleportTargetPlayerUUID(stack).isEmpty()) {
            if (entity instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)entity;
                this.setTeleportTargetPlayer(stack, serverPlayerEntity);
                ((class_3222)user).field_13987.method_14364((class_2596)new class_2660(SpectrumSoundEvents.ENDER_SPLICE_BOUND.method_14833(), class_3419.field_15248, user.method_19538(), 1.0f, 1.0f));
                serverPlayerEntity.field_13987.method_14364((class_2596)new class_2660(SpectrumSoundEvents.ENDER_SPLICE_BOUND.method_14833(), class_3419.field_15248, user.method_19538(), 1.0f, 1.0f));
            }
            user.method_6075();
        }
        return class_1269.field_5812;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236) {
            this.startSoundInstance(user);
        }
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    @Environment(value=EnvType.CLIENT)
    public void startSoundInstance(class_1657 user) {
        SpectrumClient.minecraftClient.method_1483().method_4873((class_1113)new EnderSpliceChargingSoundInstance(user));
    }

    public int method_7881(class_1799 stack) {
        return 48;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8949;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        Optional<class_3545<String, class_243>> teleportTargetPos = this.getTeleportTargetPos(itemStack);
        if (teleportTargetPos.isPresent()) {
            String dimensionDisplayString = Support.getReadableDimensionString((String)teleportTargetPos.get().method_15442());
            class_243 pos = (class_243)teleportTargetPos.get().method_15441();
            tooltip.add((class_2561)new class_2588("item.spectrum.ender_splice.tooltip.bound_pos", new Object[]{(int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350, dimensionDisplayString}));
            return;
        }
        Optional<UUID> teleportTargetPlayerUUID = this.getTeleportTargetPlayerUUID(itemStack);
        if (teleportTargetPlayerUUID.isPresent()) {
            Optional<String> teleportTargetPlayerName = this.getTeleportTargetPlayerName(itemStack);
            if (teleportTargetPlayerName.isPresent()) {
                tooltip.add((class_2561)new class_2588("item.spectrum.ender_splice.tooltip.bound_player", new Object[]{teleportTargetPlayerName.get()}));
            } else {
                tooltip.add((class_2561)new class_2588("item.spectrum.ender_splice.tooltip.bound_player", new Object[]{"???"}));
            }
            return;
        }
        tooltip.add((class_2561)new class_2588("item.spectrum.ender_splice.tooltip.unbound"));
    }

    public void setTeleportTargetPos(@NotNull class_1799 itemStack, class_1937 world, class_243 pos) {
        class_2487 nbtCompound = itemStack.method_7948();
        if (nbtCompound.method_10545("TargetPlayerName")) {
            nbtCompound.method_10551("TargetPlayerName");
        }
        if (nbtCompound.method_10545("TargetPlayerUUID")) {
            nbtCompound.method_10551("TargetPlayerUUID");
        }
        nbtCompound.method_10549("PosX", pos.method_10216());
        nbtCompound.method_10549("PosY", pos.method_10214());
        nbtCompound.method_10549("PosZ", pos.method_10215());
        nbtCompound.method_10582("Dimension", world.method_27983().method_29177().toString());
        itemStack.method_7980(nbtCompound);
    }

    public void setTeleportTargetPlayer(@NotNull class_1799 itemStack, class_3222 player) {
        class_2487 nbtCompound = itemStack.method_7948();
        if (nbtCompound.method_10545("PosX")) {
            nbtCompound.method_10551("PosX");
        }
        if (nbtCompound.method_10545("PosY")) {
            nbtCompound.method_10551("PosY");
        }
        if (nbtCompound.method_10545("PosZ")) {
            nbtCompound.method_10551("PosZ");
        }
        if (nbtCompound.method_10545("Dimension")) {
            nbtCompound.method_10551("Dimension");
        }
        nbtCompound.method_10582("TargetPlayerName", player.method_5477().method_10851());
        nbtCompound.method_25927("TargetPlayerUUID", player.method_5667());
        itemStack.method_7980(nbtCompound);
    }

    public Optional<class_3545<String, class_243>> getTeleportTargetPos(@NotNull class_1799 itemStack) {
        class_2487 nbtCompound = itemStack.method_7969();
        if (nbtCompound != null && nbtCompound.method_10545("PosX") && nbtCompound.method_10545("PosY") && nbtCompound.method_10545("PosZ") && nbtCompound.method_10545("Dimension")) {
            String dimensionKeyString = nbtCompound.method_10558("Dimension");
            double x = nbtCompound.method_10574("PosX");
            double y = nbtCompound.method_10574("PosY");
            double z = nbtCompound.method_10574("PosZ");
            class_243 pos = new class_243(x, y, z);
            return Optional.of(new class_3545((Object)dimensionKeyString, (Object)pos));
        }
        return Optional.empty();
    }

    public Optional<UUID> getTeleportTargetPlayerUUID(@NotNull class_1799 itemStack) {
        class_2487 nbtCompound = itemStack.method_7969();
        if (nbtCompound != null && nbtCompound.method_10545("TargetPlayerUUID")) {
            return Optional.of(nbtCompound.method_25926("TargetPlayerUUID"));
        }
        return Optional.empty();
    }

    public Optional<String> getTeleportTargetPlayerName(@NotNull class_1799 itemStack) {
        class_2487 nbtCompound = itemStack.method_7969();
        if (nbtCompound != null && nbtCompound.method_10545("TargetPlayerName")) {
            return Optional.of(nbtCompound.method_10558("TargetPlayerName"));
        }
        return Optional.empty();
    }

    @Override
    public boolean canAcceptEnchantment(class_1887 enchantment) {
        return enchantment == SpectrumEnchantments.RESONANCE || enchantment == class_1893.field_9119;
    }

    public int method_7837() {
        return 50;
    }
}

