/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterEnchantable;
import de.dafuqs.spectrum.interfaces.InventoryInsertionAcceptor;
import de.dafuqs.spectrum.items.tooltip.VoidBundleTooltipData;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2968;
import net.minecraft.class_2969;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5536;
import net.minecraft.class_5537;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_5712;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class BottomlessBundleItem
extends class_5537
implements InventoryInsertionAcceptor,
EnchanterEnchantable {
    private static final int MAX_STORED_AMOUNT_BASE = 20000;

    public BottomlessBundleItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static class_1799 getWithBlockAndCount(class_1799 itemStack, int amount) {
        class_1799 bottomlessBundleStack = new class_1799((class_1935)SpectrumItems.BOTTOMLESS_BUNDLE);
        BottomlessBundleItem.bundleStack(bottomlessBundleStack, itemStack, amount);
        return bottomlessBundleStack;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (BottomlessBundleItem.dropOneBundledStack(itemStack, user)) {
            this.playDropContentsSound((class_1297)user);
            user.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036().method_5715()) {
            return this.place(new class_1750(context));
        }
        return super.method_7884(context);
    }

    public class_1269 place(class_1750 itemPlacementContext) {
        if (!itemPlacementContext.method_7716()) {
            return class_1269.field_5814;
        }
        class_2680 blockState = this.getPlacementState(itemPlacementContext);
        if (blockState == null) {
            return class_1269.field_5814;
        }
        if (!this.place(itemPlacementContext, blockState)) {
            return class_1269.field_5814;
        }
        class_2338 blockPos = itemPlacementContext.method_8037();
        class_1937 world = itemPlacementContext.method_8045();
        class_1657 playerEntity = itemPlacementContext.method_8036();
        class_1799 itemStack = itemPlacementContext.method_8041();
        class_2680 blockState2 = world.method_8320(blockPos);
        if (blockState2.method_27852(blockState.method_26204())) {
            blockState2.method_26204().method_9567(world, blockPos, blockState2, (class_1309)playerEntity, itemStack);
            if (playerEntity instanceof class_3222) {
                class_174.field_1191.method_9087((class_3222)playerEntity, blockPos, itemStack);
            }
        }
        class_2498 blockSoundGroup = blockState2.method_26231();
        world.method_8396(playerEntity, blockPos, this.getPlaceSound(blockState2), class_3419.field_15245, (blockSoundGroup.method_10597() + 1.0f) / 2.0f, blockSoundGroup.method_10599() * 0.8f);
        world.method_32888((class_1297)playerEntity, class_5712.field_28164, blockPos);
        if (playerEntity == null || !playerEntity.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        return class_1269.method_29236((boolean)world.field_9236);
    }

    protected boolean place(class_1750 context, class_2680 state) {
        return context.method_8045().method_8652(context.method_8037(), state, 11);
    }

    protected class_3414 getPlaceSound(class_2680 state) {
        return state.method_26231().method_10598();
    }

    @Nullable
    protected class_2680 getPlacementState(class_1750 context) {
        class_2680 blockState = SpectrumBlocks.BOTTOMLESS_BUNDLE.method_9605(context);
        return blockState != null && this.canPlace(context, blockState) ? blockState : null;
    }

    protected boolean canPlace(class_1750 context, class_2680 state) {
        class_1657 playerEntity = context.method_8036();
        class_3726 shapeContext = playerEntity == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)playerEntity);
        return state.method_26184((class_4538)context.method_8045(), context.method_8037()) && context.method_8045().method_8628(state, context.method_8037(), shapeContext);
    }

    public static int getMaxStoredAmount(class_1799 itemStack) {
        int powerLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)itemStack);
        return 20000 * (int)Math.pow(10.0, Math.min(5, powerLevel));
    }

    public boolean method_31567(class_1799 stack) {
        return BottomlessBundleItem.getStoredAmount(stack) > 0;
    }

    public int method_31569(class_1799 stack) {
        return Math.min(1 + (int)Math.round(12.0 * ((double)BottomlessBundleItem.getStoredAmount(stack) / (double)BottomlessBundleItem.getMaxStoredAmount(stack))), 13);
    }

    public int method_31571(class_1799 stack) {
        return super.method_31571(stack);
    }

    public boolean method_31568() {
        return false;
    }

    public Optional<class_5632> method_32346(class_1799 voidBundleStack) {
        class_1799 itemStack = BottomlessBundleItem.getFirstBundledStack(voidBundleStack);
        int storedAmount = BottomlessBundleItem.getStoredAmount(voidBundleStack);
        return Optional.of(new VoidBundleTooltipData(itemStack, storedAmount));
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        int storedAmount = BottomlessBundleItem.getStoredAmount(stack);
        if (storedAmount == 0) {
            tooltip.add((class_2561)new class_2588("item.spectrum.void_bundle.tooltip.empty").method_27692(class_124.field_1080));
        } else {
            class_1799 firstStack = BottomlessBundleItem.getFirstBundledStack(stack);
            String totalStacks = Support.getShortenedNumberString((float)storedAmount / (float)firstStack.method_7914());
            tooltip.add((class_2561)new class_2588("item.spectrum.void_bundle.tooltip.count", new Object[]{storedAmount, BottomlessBundleItem.getMaxStoredAmount(stack), totalStacks}).method_27692(class_124.field_1080));
            tooltip.add((class_2561)new class_2588("item.spectrum.void_bundle.tooltip.enter_inventory", new Object[]{firstStack.method_7964().getString()}).method_27692(class_124.field_1080));
        }
        if (class_1890.method_8225((class_1887)SpectrumEnchantments.VOIDING, (class_1799)stack) > 0) {
            tooltip.add((class_2561)new class_2588("item.spectrum.void_bundle.tooltip.voiding"));
        }
    }

    public void method_33261(class_1542 entity) {
        class_1799 voidBundleItemStack;
        int currentAmount;
        class_1937 world = entity.field_6002;
        if (!world.field_9236 && (currentAmount = BottomlessBundleItem.getStoredAmount(voidBundleItemStack = entity.method_6983())) > 0) {
            class_1799 storedStack = BottomlessBundleItem.getFirstBundledStack(voidBundleItemStack);
            while (currentAmount > 0) {
                int stackCount = Math.min(currentAmount, storedStack.method_7914());
                class_1799 entityStack = storedStack.method_7972();
                entityStack.method_7939(stackCount);
                world.method_8649((class_1297)new class_1542(world, entity.method_23317(), entity.method_23318(), entity.method_23321(), entityStack));
                currentAmount -= stackCount;
            }
        }
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        class_1799 firstStack;
        if (clickType != class_5536.field_27014) {
            return false;
        }
        class_1799 itemStack = slot.method_7677();
        if (itemStack.method_7960()) {
            this.playRemoveOneSound((class_1297)player);
            BottomlessBundleItem.removeFirstBundledStack(stack).ifPresent(removedStack -> BottomlessBundleItem.addToBundle(stack, slot.method_32756(removedStack)));
        } else if (itemStack.method_7909().method_31568() && ((firstStack = BottomlessBundleItem.getFirstBundledStack(stack)).method_7960() || class_1799.method_31577((class_1799)firstStack, (class_1799)itemStack))) {
            int amountAbleToStore;
            boolean hasVoiding = class_1890.method_8225((class_1887)SpectrumEnchantments.VOIDING, (class_1799)stack) > 0;
            int n = amountAbleToStore = hasVoiding ? itemStack.method_7947() : Math.min(itemStack.method_7947(), BottomlessBundleItem.getMaxStoredAmount(stack) - BottomlessBundleItem.getStoredAmount(stack));
            if (amountAbleToStore > 0) {
                BottomlessBundleItem.addToBundle(stack, slot.method_32753(itemStack.method_7947(), amountAbleToStore, player));
                this.playInsertSound((class_1297)player);
            }
        }
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && slot.method_32754(player)) {
            if (otherStack.method_7960()) {
                BottomlessBundleItem.removeFirstBundledStack(stack).ifPresent(itemStack -> {
                    this.playRemoveOneSound((class_1297)player);
                    cursorStackReference.method_32332(itemStack);
                });
            } else {
                int storedAmount = BottomlessBundleItem.addToBundle(stack, otherStack);
                if (storedAmount > 0) {
                    this.playInsertSound((class_1297)player);
                    otherStack.method_7934(storedAmount);
                }
            }
            return true;
        }
        return false;
    }

    public static int addToBundle(class_1799 voidBundleStack, class_1799 stackToBundle) {
        if (!stackToBundle.method_7960() && stackToBundle.method_7909().method_31568()) {
            int storedAmount = BottomlessBundleItem.getStoredAmount(voidBundleStack);
            int amountAbleToStore = Math.min(stackToBundle.method_7947(), BottomlessBundleItem.getMaxStoredAmount(voidBundleStack) - BottomlessBundleItem.getStoredAmount(voidBundleStack));
            if (amountAbleToStore > 0) {
                class_1799 stackInBundle = BottomlessBundleItem.getFirstBundledStack(voidBundleStack);
                if (stackInBundle.method_7960()) {
                    stackInBundle = stackToBundle.method_7972();
                    stackInBundle.method_7939(amountAbleToStore);
                    BottomlessBundleItem.bundleStack(voidBundleStack, stackInBundle);
                    return amountAbleToStore;
                }
                if (class_1799.method_31577((class_1799)stackInBundle, (class_1799)stackToBundle)) {
                    stackInBundle.method_7933(amountAbleToStore);
                    BottomlessBundleItem.bundleStack(voidBundleStack, stackInBundle, storedAmount + amountAbleToStore);
                    return amountAbleToStore;
                }
            }
        }
        return 0;
    }

    public static Optional<class_1799> removeFirstBundledStack(class_1799 voidBundleStack) {
        class_1799 removedStack = BottomlessBundleItem.getFirstBundledStack(voidBundleStack);
        if (removedStack.method_7960()) {
            return Optional.empty();
        }
        BottomlessBundleItem.removeBundledStackAmount(voidBundleStack, removedStack.method_7947());
        return Optional.of(removedStack);
    }

    private static boolean dropOneBundledStack(class_1799 voidBundleStack, class_1657 player) {
        class_1799 bundledStack = BottomlessBundleItem.getFirstBundledStack(voidBundleStack);
        int storedAmount = BottomlessBundleItem.getStoredAmount(voidBundleStack);
        int droppedAmount = Math.min(bundledStack.method_7914(), storedAmount);
        if (droppedAmount > 0) {
            player.method_7328(new class_1799((class_1935)bundledStack.method_7909(), droppedAmount), true);
            BottomlessBundleItem.removeBundledStackAmount(voidBundleStack, droppedAmount);
            return true;
        }
        return false;
    }

    public static class_1799 getFirstBundledStack(class_1799 voidBundleStack) {
        class_2487 nbtCompound = voidBundleStack.method_7969();
        if (nbtCompound == null) {
            return class_1799.field_8037;
        }
        return BottomlessBundleItem.getFirstBundledStack(nbtCompound);
    }

    private static class_1799 getFirstBundledStack(class_2487 nbtCompound) {
        class_2487 storedItemCompound = nbtCompound.method_10562("StoredStack");
        int storedAmount = storedItemCompound.method_10550("Count");
        class_1799 itemStack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(storedItemCompound.method_10558("ID"))));
        int stackAmount = Math.min(storedAmount, itemStack.method_7914());
        itemStack.method_7939(stackAmount);
        if (storedItemCompound.method_10573("Tag", 10)) {
            itemStack.method_7980(storedItemCompound.method_10562("Tag"));
        }
        if (itemStack.method_7909().method_7846()) {
            itemStack.method_7974(itemStack.method_7919());
        }
        return itemStack;
    }

    private static int bundleStack(class_1799 voidBundleStack, class_1799 storedItemStack) {
        return BottomlessBundleItem.bundleStack(voidBundleStack, storedItemStack, storedItemStack.method_7947());
    }

    private static int bundleStack(class_1799 voidBundleStack, class_1799 storedItemStack, int amount) {
        class_2487 voidBundleCompound = voidBundleStack.method_7948();
        class_2487 storedItemCompound = new class_2487();
        boolean hasVoiding = class_1890.method_8225((class_1887)SpectrumEnchantments.VOIDING, (class_1799)voidBundleStack) > 0;
        int maxStoredAmount = BottomlessBundleItem.getMaxStoredAmount(voidBundleStack);
        int newAmount = Math.min(maxStoredAmount, storedItemCompound.method_10550("Count") + amount);
        int overflowAmount = hasVoiding ? 0 : Math.max(0, amount - maxStoredAmount);
        class_2960 identifier = class_2378.field_11142.method_10221((Object)storedItemStack.method_7909());
        storedItemCompound.method_10582("ID", identifier.toString());
        storedItemCompound.method_10569("Count", newAmount);
        if (storedItemStack.method_7969() != null) {
            storedItemCompound.method_10566("Tag", (class_2520)storedItemStack.method_7969().method_10553());
        }
        voidBundleCompound.method_10566("StoredStack", (class_2520)storedItemCompound);
        voidBundleStack.method_7980(voidBundleCompound);
        return overflowAmount;
    }

    public static int getStoredAmount(class_1799 voidBundleStack) {
        class_2487 storedStackCompound;
        class_2487 voidBundleCompound = voidBundleStack.method_7948();
        if (voidBundleCompound.method_10545("StoredStack") && (storedStackCompound = voidBundleCompound.method_10562("StoredStack")).method_10545("Count")) {
            return storedStackCompound.method_10550("Count");
        }
        return 0;
    }

    private static void removeBundledStackAmount(class_1799 voidBundleStack, int amount) {
        int storedAmount = BottomlessBundleItem.getStoredAmount(voidBundleStack);
        class_2487 voidBundleCompound = voidBundleStack.method_7948();
        if (voidBundleCompound.method_10545("StoredStack")) {
            int remainingCount = storedAmount - amount;
            if (remainingCount > 0) {
                class_2487 storedStackCompound = voidBundleCompound.method_10562("StoredStack");
                storedStackCompound.method_10569("Count", remainingCount);
                voidBundleCompound.method_10566("StoredStack", (class_2520)storedStackCompound);
            } else {
                voidBundleCompound.method_10551("StoredStack");
            }
            voidBundleStack.method_7980(voidBundleCompound);
        }
    }

    @Override
    public boolean acceptsItemStack(class_1799 inventoryInsertionAcceptorStack, class_1799 itemStackToAccept) {
        class_1799 storedStack = BottomlessBundleItem.getFirstBundledStack(inventoryInsertionAcceptorStack);
        if (storedStack.method_7960()) {
            return false;
        }
        return class_1799.method_31577((class_1799)storedStack, (class_1799)itemStackToAccept);
    }

    @Override
    public int acceptItemStack(class_1799 inventoryInsertionAcceptorStack, class_1799 itemStackToAccept, class_1657 playerEntity) {
        int storedAmount = BottomlessBundleItem.getStoredAmount(inventoryInsertionAcceptorStack);
        return BottomlessBundleItem.bundleStack(inventoryInsertionAcceptorStack, itemStackToAccept, itemStackToAccept.method_7947() + storedAmount);
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().nextFloat() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34375, 0.8f, 0.8f + entity.method_37908().method_8409().nextFloat() * 0.4f);
    }

    @Override
    public boolean canAcceptEnchantment(class_1887 enchantment) {
        return enchantment == class_1893.field_9103 || enchantment == SpectrumEnchantments.VOIDING;
    }

    public int method_7837() {
        return 5;
    }

    public static class BottomlessBundlePlacementDispenserBehavior
    extends class_2969 {
        protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
            this.method_27955(false);
            class_1792 item = stack.method_7909();
            if (item instanceof BottomlessBundleItem) {
                BottomlessBundleItem bottomlessBundleItem = (BottomlessBundleItem)item;
                class_2350 direction = (class_2350)pointer.method_10120().method_11654((class_2769)class_2315.field_10918);
                class_2338 blockPos = pointer.method_10122().method_10093(direction);
                class_2350 direction2 = pointer.method_10207().method_22347(blockPos.method_10074()) ? direction : class_2350.field_11036;
                try {
                    this.method_27955(bottomlessBundleItem.place((class_1750)new class_2968((class_1937)pointer.method_10207(), blockPos, direction, stack, direction2)).method_23665());
                }
                catch (Exception e) {
                    SpectrumCommon.log(Level.ERROR, "Error trying to place bottomless bundle at " + blockPos + " : " + e);
                }
            }
            return stack;
        }
    }
}

