/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories;

import de.dafuqs.spectrum.blocks.pedestal.PedestalBlock;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import de.dafuqs.spectrum.inventories.slots.DisabledSlot;
import de.dafuqs.spectrum.inventories.slots.ReadOnlySlot;
import de.dafuqs.spectrum.inventories.slots.StackFilterSlot;
import de.dafuqs.spectrum.registries.SpectrumItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1729;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1737;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_5421;
import org.jetbrains.annotations.NotNull;

public class PedestalScreenHandler
extends class_1729<class_1263> {
    private final class_1657 player;
    private final class_1263 inventory;
    private final class_3913 propertyDelegate;
    protected final class_1937 world;
    private final class_5421 category;
    private final class_2338 pedestalPos;
    private final PedestalBlock.PedestalVariant variant;
    private final PedestalRecipeTier maxPedestalRecipeTier;

    public PedestalScreenHandler(int syncId, class_1661 playerInventory, @NotNull class_2540 buf) {
        this(SpectrumScreenHandlerTypes.PEDESTAL, class_3914.field_17304, class_5421.field_25763, syncId, playerInventory, buf.readInt(), buf.readInt(), buf.method_10811());
    }

    protected PedestalScreenHandler(class_3917<?> type, class_3914 context, class_5421 recipeBookCategory, int i, class_1661 playerInventory, int variant, int maxRecipeTier, class_2338 pedestalPos) {
        this(type, context, recipeBookCategory, i, playerInventory, (class_1263)new class_1277(16), (class_3913)new class_3919(2), variant, maxRecipeTier, pedestalPos);
    }

    public PedestalScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory, class_3913 propertyDelegate, int variant, int maxRecipeTier, class_2338 pedestalPos) {
        this(SpectrumScreenHandlerTypes.PEDESTAL, class_3914.field_17304, class_5421.field_25763, syncId, playerInventory, inventory, propertyDelegate, variant, maxRecipeTier, pedestalPos);
    }

    protected PedestalScreenHandler(class_3917<?> type, class_3914 context, class_5421 recipeBookCategory, int i, @NotNull class_1661 playerInventory, class_1263 inventory, class_3913 propertyDelegate, int variant, int maxRecipeTier, class_2338 pedestalPos) {
        super(type, i);
        int l;
        this.player = playerInventory.field_7546;
        this.inventory = inventory;
        this.category = recipeBookCategory;
        this.propertyDelegate = propertyDelegate;
        this.world = playerInventory.field_7546.field_6002;
        class_1731 craftingResultInventory = new class_1731();
        this.pedestalPos = pedestalPos;
        this.variant = PedestalBlock.PedestalVariant.values()[variant];
        this.maxPedestalRecipeTier = PedestalRecipeTier.values()[maxRecipeTier];
        PedestalScreenHandler.method_17359((class_1263)inventory, (int)16);
        PedestalScreenHandler.method_17361((class_3913)propertyDelegate, (int)2);
        inventory.method_5435(playerInventory.field_7546);
        for (int m = 0; m < 3; ++m) {
            for (int n = 0; n < 3; ++n) {
                this.method_7621(new class_1735(inventory, n + m * 3, 30 + n * 18, 19 + m * 18));
            }
        }
        switch (this.variant) {
            case BASIC_TOPAZ: 
            case BASIC_AMETHYST: 
            case BASIC_CITRINE: 
            case CMY: {
                this.method_7621(new StackFilterSlot(inventory, 9, 62, 77, SpectrumItems.TOPAZ_POWDER));
                this.method_7621(new StackFilterSlot(inventory, 10, 80, 77, SpectrumItems.AMETHYST_POWDER));
                this.method_7621(new StackFilterSlot(inventory, 11, 98, 77, SpectrumItems.CITRINE_POWDER));
                this.method_7621(new DisabledSlot(inventory, 12, -2000, 77, SpectrumItems.ONYX_POWDER));
                this.method_7621(new DisabledSlot(inventory, 13, -2000, 77, SpectrumItems.MOONSTONE_POWDER));
                break;
            }
            case ONYX: {
                this.method_7621(new StackFilterSlot(inventory, 9, 53, 77, SpectrumItems.TOPAZ_POWDER));
                this.method_7621(new StackFilterSlot(inventory, 10, 71, 77, SpectrumItems.AMETHYST_POWDER));
                this.method_7621(new StackFilterSlot(inventory, 11, 89, 77, SpectrumItems.CITRINE_POWDER));
                this.method_7621(new StackFilterSlot(inventory, 12, 107, 77, SpectrumItems.ONYX_POWDER));
                this.method_7621(new DisabledSlot(inventory, 13, -2000, 77, SpectrumItems.MOONSTONE_POWDER));
                break;
            }
            case MOONSTONE: {
                this.method_7621(new StackFilterSlot(inventory, 9, 44, 77, SpectrumItems.TOPAZ_POWDER));
                this.method_7621(new StackFilterSlot(inventory, 10, 62, 77, SpectrumItems.AMETHYST_POWDER));
                this.method_7621(new StackFilterSlot(inventory, 11, 80, 77, SpectrumItems.CITRINE_POWDER));
                this.method_7621(new StackFilterSlot(inventory, 12, 98, 77, SpectrumItems.ONYX_POWDER));
                this.method_7621(new StackFilterSlot(inventory, 13, 116, 77, SpectrumItems.MOONSTONE_POWDER));
            }
        }
        this.method_7621(new StackFilterSlot(inventory, 14, 93, 19, SpectrumItems.CRAFTING_TABLET));
        this.method_7621(new ReadOnlySlot((class_1263)craftingResultInventory, 15, 127, 37));
        for (l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.method_7621(new class_1735((class_1263)playerInventory, k + l * 9 + 9, 8 + k * 18, 112 + l * 18));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.method_7621(new class_1735((class_1263)playerInventory, l, 8 + l * 18, 170));
        }
        this.method_17360(propertyDelegate);
    }

    public void method_7654(class_1662 recipeMatcher) {
        if (this.inventory != null) {
            ((class_1737)this.inventory).method_7683(recipeMatcher);
        }
    }

    public void method_7657() {
        for (int i = 0; i < 9; ++i) {
            this.method_7611(i).method_7673(class_1799.field_8037);
        }
    }

    public void calculateDisplayedSlotStackClient() {
        class_2586 blockEntity = this.world.method_8321(this.pedestalPos);
        if (blockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity;
            ((class_1735)this.field_7761.get(15)).method_7673(pedestalBlockEntity.getCurrentCraftingRecipeOutput());
        }
    }

    public boolean method_7652(class_1860<? super class_1263> recipe) {
        return recipe.method_8115(this.inventory, this.world);
    }

    public int method_7655() {
        return 16;
    }

    public int method_7653() {
        return 3;
    }

    public int method_7656() {
        return 3;
    }

    public int method_7658() {
        return 9;
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    @Environment(value=EnvType.CLIENT)
    public int getCraftingProgress() {
        int craftingTime = this.propertyDelegate.method_17390(0);
        int craftingTimeTotal = this.propertyDelegate.method_17390(1);
        return craftingTimeTotal != 0 && craftingTime != 0 ? craftingTime * 24 / craftingTimeTotal : 0;
    }

    public boolean isCrafting() {
        this.calculateDisplayedSlotStackClient();
        return this.propertyDelegate.method_17390(0) > 0;
    }

    @Environment(value=EnvType.CLIENT)
    public class_5421 method_30264() {
        return this.category;
    }

    public boolean method_32339(int index) {
        return index != 1;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 clickedStackCopy = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        class_2586 blockEntity = this.world.method_8321(this.pedestalPos);
        if (blockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity;
            pedestalBlockEntity.setInventoryChanged();
        }
        if (slot.method_7681()) {
            class_1799 clickedStack = slot.method_7677();
            clickedStackCopy = clickedStack.method_7972();
            if (index < 15 ? !this.method_7616(clickedStack, 16, 51, false) : (clickedStackCopy.method_31574(SpectrumItems.TOPAZ_POWDER) ? !this.method_7616(clickedStack, 9, 10, false) : (clickedStackCopy.method_31574(SpectrumItems.AMETHYST_POWDER) ? !this.method_7616(clickedStack, 10, 11, false) : (clickedStackCopy.method_31574(SpectrumItems.CITRINE_POWDER) ? !this.method_7616(clickedStack, 11, 12, false) : (clickedStackCopy.method_31574(SpectrumItems.ONYX_POWDER) ? !this.method_7616(clickedStack, 12, 13, false) : (clickedStackCopy.method_31574(SpectrumItems.MOONSTONE_POWDER) ? !this.method_7616(clickedStack, 13, 14, false) : clickedStackCopy.method_31574(SpectrumItems.CRAFTING_TABLET) && !this.method_7616(clickedStack, 14, 15, false))))))) {
                return class_1799.field_8037;
            }
            if (!this.method_7616(clickedStack, 0, 8, false)) {
                return class_1799.field_8037;
            }
            if (clickedStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (clickedStack.method_7947() == clickedStackCopy.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, clickedStack);
        }
        return clickedStackCopy;
    }

    public class_2338 getPedestalPos() {
        return this.pedestalPos;
    }

    public PedestalBlock.PedestalVariant getVariant() {
        return this.variant;
    }

    public PedestalRecipeTier getMaxPedestalRecipeTier() {
        return this.maxPedestalRecipeTier;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.inventory.method_5432(player);
    }
}

