/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.spectrum.blocks.particle_spawner.ParticleSpawnerBlockEntity;
import de.dafuqs.spectrum.inventories.ParticleSpawnerScreenHandler;
import de.dafuqs.spectrum.networking.SpectrumC2SPackets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_757;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ParticleSpawnerScreen
extends class_465<ParticleSpawnerScreenHandler> {
    int textColor = 0x222222;
    private static final class_2960 GUI_TEXTURE = new class_2960("spectrum", "textures/gui/container/particle_spawner.png");
    private static final class_2960 TEXTURE_PARTICLES = new class_2960("spectrum", "textures/gui/container/particle_spawner_particles.png");
    private static final int PARTICLES_PER_PAGE = 6;
    private static final List<class_2960> AVAILABLE_PARTICLES = new ArrayList<class_2960>(){
        {
            this.add(new class_2960("spectrum", "particle/sparklestone_sparkle"));
            this.add(new class_2960("spectrum", "particle/shooting_star"));
            this.add(new class_2960("spectrum", "particle/liquid_crystal_sparkle"));
            this.add(new class_2960("spectrum", "particle/void_fog"));
            this.add(new class_2960("particle/effect_5"));
            this.add(new class_2960("particle/glint"));
            this.add(new class_2960("particle/heart"));
            this.add(new class_2960("particle/damage"));
            this.add(new class_2960("particle/lava"));
            this.add(new class_2960("particle/flame"));
            this.add(new class_2960("particle/spark_2"));
            this.add(new class_2960("particle/critical_hit"));
            this.add(new class_2960("particle/nautilus"));
            this.add(new class_2960("particle/bubble"));
            this.add(new class_2960("particle/big_smoke_3"));
        }
    };
    private List<class_339> selectableWidgets;
    private class_342 amountField;
    private class_342 positionXField;
    private class_342 positionYField;
    private class_342 positionZField;
    private class_342 positionXVarianceField;
    private class_342 positionYVarianceField;
    private class_342 positionZVarianceField;
    private class_342 velocityXField;
    private class_342 velocityYField;
    private class_342 velocityZField;
    private class_342 velocityXVarianceField;
    private class_342 velocityYVarianceField;
    private class_342 velocityZVarianceField;
    private class_342 scale;
    private class_342 scaleVariance;
    private class_342 duration;
    private class_342 durationVariance;
    private class_342 gravity;
    private class_4185 collisionsButton;
    private class_4185 backButton;
    private class_4185 forwardButton;
    private List<class_4185> particleButtons;
    boolean collisionsEnabled = false;
    int activeParticlePage = 0;
    int particleSelectionIndex = 0;

    public ParticleSpawnerScreen(ParticleSpawnerScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_25267 = 48;
        this.field_25268 = 7;
        this.field_2779 = 222;
        this.selectableWidgets = new ArrayList<class_339>();
    }

    protected void method_25426() {
        super.method_25426();
        this.field_22787.field_1774.method_1462(true);
        this.setupInputFields(((ParticleSpawnerScreenHandler)this.field_2797).getBlockEntity());
        this.method_20085((class_364)this.amountField);
    }

    public void method_25432() {
        super.method_25432();
        this.field_22787.field_1774.method_1462(false);
    }

    public void method_37432() {
        super.method_37432();
        for (class_339 widget : this.selectableWidgets) {
            if (!(widget instanceof class_342)) continue;
            ((class_342)widget).method_1865();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_364 focusedElement;
        if (keyCode == 256) {
            this.field_22787.field_1724.method_7346();
        }
        if ((focusedElement = this.method_25399()) instanceof class_342) {
            if (keyCode == 258) {
                int currentIndex = this.selectableWidgets.indexOf(focusedElement);
                ((class_342)focusedElement).method_1876(false);
                if (modifiers == 1) {
                    this.method_25395((class_364)this.selectableWidgets.get((this.selectableWidgets.size() + currentIndex - 1) % this.selectableWidgets.size()));
                } else {
                    this.method_25395((class_364)this.selectableWidgets.get((currentIndex + 1) % this.selectableWidgets.size()));
                }
            }
            return focusedElement.method_25404(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        this.renderForeground(matrices, mouseX, mouseY, delta);
        this.method_2380(matrices, mouseX, mouseY);
    }

    public void renderForeground(class_4587 matrices, int mouseX, int mouseY, float delta) {
        for (class_339 widget : this.selectableWidgets) {
            if (!(widget instanceof class_342)) continue;
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        this.field_22793.method_30883(matrices, this.field_22785, (float)this.field_25267, (float)this.field_25268, 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Particles / Second"), 10.0f, 50.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("x"), 66.0f, 64.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("y"), 99.0f, 64.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("z"), 134.0f, 64.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Offset"), 10.0f, 78.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Variance"), 21.0f, 97.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Velocity"), 10.0f, 117.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Variance"), 21.0f, 137.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Scale"), 10.0f, 161.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Variance"), 91.0f, 161.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Duration"), 10.0f, 181.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Variance"), 91.0f, 181.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Gravity"), 10.0f, 201.0f, this.textColor);
        this.field_22793.method_30883(matrices, (class_2561)new class_2585("Collisions"), 90.0f, 201.0f, this.textColor);
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.method_25302(matrices, x, y, 0, 0, this.field_2792, this.field_2779);
        if (this.collisionsEnabled) {
            this.method_25302(matrices, x + 146, y + 197, 0, 222, 16, 16);
        }
        if (this.particleSelectionIndex / 6 == this.activeParticlePage) {
            this.method_25302(matrices, x + 27 + 20 * (this.particleSelectionIndex % 6), y + 19, 16, 222, 22, 22);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE_PARTICLES);
        this.method_25302(matrices, x + 28, y + 21, 0, this.activeParticlePage * 20, 120, 20);
    }

    protected void setupInputFields(ParticleSpawnerBlockEntity blockEntity) {
        this.field_22787.field_1774.method_1462(true);
        int i = (this.field_22789 - this.field_2792) / 2 + 3;
        int j = (this.field_22790 - this.field_2779) / 2 + 3;
        this.amountField = this.addTextFieldWidget(i + 110, j + 47, (class_2561)new class_2585("Amount"), String.valueOf(blockEntity.particlesPerSecond), this::isPositiveDecimalNumberUnderThousand);
        this.positionXField = this.addTextFieldWidget(i + 61, j + 74, (class_2561)new class_2585("X Position"), String.valueOf(blockEntity.particleSourcePosition.method_4943()), this::isAbsoluteDecimalNumberThousand);
        this.positionYField = this.addTextFieldWidget(i + 96, j + 74, (class_2561)new class_2585("Y Position"), String.valueOf(blockEntity.particleSourcePosition.method_4945()), this::isAbsoluteDecimalNumberThousand);
        this.positionZField = this.addTextFieldWidget(i + 131, j + 74, (class_2561)new class_2585("Z Position"), String.valueOf(blockEntity.particleSourcePosition.method_4947()), this::isAbsoluteDecimalNumberThousand);
        this.positionXVarianceField = this.addTextFieldWidget(i + 69, j + 94, (class_2561)new class_2585("X Position Variance"), String.valueOf(blockEntity.particleSourcePositionVariance.method_4943()), this::isAbsoluteDecimalNumberThousand);
        this.positionYVarianceField = this.addTextFieldWidget(i + 104, j + 94, (class_2561)new class_2585("Y Position Variance"), String.valueOf(blockEntity.particleSourcePositionVariance.method_4945()), this::isAbsoluteDecimalNumberThousand);
        this.positionZVarianceField = this.addTextFieldWidget(i + 140, j + 94, (class_2561)new class_2585("Z Position Variance"), String.valueOf(blockEntity.particleSourcePositionVariance.method_4947()), this::isAbsoluteDecimalNumberThousand);
        this.velocityXField = this.addTextFieldWidget(i + 61, j + 114, (class_2561)new class_2585("X Velocity"), String.valueOf(blockEntity.velocity.method_4943()), this::isAbsoluteDecimalNumberThousand);
        this.velocityYField = this.addTextFieldWidget(i + 96, j + 114, (class_2561)new class_2585("Y Velocity"), String.valueOf(blockEntity.velocity.method_4945()), this::isAbsoluteDecimalNumberThousand);
        this.velocityZField = this.addTextFieldWidget(i + 131, j + 114, (class_2561)new class_2585("Z Velocity"), String.valueOf(blockEntity.velocity.method_4947()), this::isAbsoluteDecimalNumberThousand);
        this.velocityXVarianceField = this.addTextFieldWidget(i + 69, j + 134, (class_2561)new class_2585("X Velocity Variance"), String.valueOf(blockEntity.velocityVariance.method_4943()), this::isAbsoluteDecimalNumberThousand);
        this.velocityYVarianceField = this.addTextFieldWidget(i + 104, j + 134, (class_2561)new class_2585("Y Velocity Variance"), String.valueOf(blockEntity.velocityVariance.method_4945()), this::isAbsoluteDecimalNumberThousand);
        this.velocityZVarianceField = this.addTextFieldWidget(i + 140, j + 134, (class_2561)new class_2585("Z Velocity Variance"), String.valueOf(blockEntity.velocityVariance.method_4947()), this::isAbsoluteDecimalNumberThousand);
        this.scale = this.addTextFieldWidget(i + 55, j + 158, (class_2561)new class_2585("Scale"), String.valueOf(blockEntity.scale), this::isPositiveDecimalNumberUnderTen);
        this.scaleVariance = this.addTextFieldWidget(i + 139, j + 158, (class_2561)new class_2585("Scale Variance"), String.valueOf(blockEntity.scaleVariance), this::isPositiveDecimalNumberUnderTen);
        this.duration = this.addTextFieldWidget(i + 55, j + 178, (class_2561)new class_2585("Duration"), String.valueOf(blockEntity.lifetimeTicks), this::isPositiveWholeNumberUnderThousand);
        this.durationVariance = this.addTextFieldWidget(i + 139, j + 178, (class_2561)new class_2585("Duration Variance"), String.valueOf(blockEntity.lifetimeVariance), this::isPositiveWholeNumberUnderThousand);
        this.gravity = this.addTextFieldWidget(i + 55, j + 198, (class_2561)new class_2585("Gravity"), String.valueOf(blockEntity.gravity), this::isBetweenZeroAndOne);
        this.collisionsButton = new class_4185(i + 142, j + 194, 16, 16, (class_2561)new class_2585("Collisions"), this::collisionButtonPressed);
        this.collisionsEnabled = blockEntity.collisions;
        this.method_25429((class_364)this.collisionsButton);
        this.selectableWidgets = new ArrayList<class_339>(){
            {
                this.add(ParticleSpawnerScreen.this.amountField);
                this.add(ParticleSpawnerScreen.this.positionXField);
                this.add(ParticleSpawnerScreen.this.positionYField);
                this.add(ParticleSpawnerScreen.this.positionZField);
                this.add(ParticleSpawnerScreen.this.positionXVarianceField);
                this.add(ParticleSpawnerScreen.this.positionYVarianceField);
                this.add(ParticleSpawnerScreen.this.positionZVarianceField);
                this.add(ParticleSpawnerScreen.this.velocityXField);
                this.add(ParticleSpawnerScreen.this.velocityYField);
                this.add(ParticleSpawnerScreen.this.velocityZField);
                this.add(ParticleSpawnerScreen.this.velocityXVarianceField);
                this.add(ParticleSpawnerScreen.this.velocityYVarianceField);
                this.add(ParticleSpawnerScreen.this.velocityZVarianceField);
                this.add(ParticleSpawnerScreen.this.scale);
                this.add(ParticleSpawnerScreen.this.scaleVariance);
                this.add(ParticleSpawnerScreen.this.duration);
                this.add(ParticleSpawnerScreen.this.durationVariance);
                this.add(ParticleSpawnerScreen.this.gravity);
                this.add(ParticleSpawnerScreen.this.collisionsButton);
            }
        };
        this.backButton = new class_4185(i + 11, j + 19, 12, 14, (class_2561)new class_2585("back"), this::navigationButtonPressed);
        this.method_25429((class_364)this.backButton);
        this.forwardButton = new class_4185(i + 147, j + 19, 12, 14, (class_2561)new class_2585("forward"), this::navigationButtonPressed);
        this.method_25429((class_364)this.forwardButton);
        this.particleButtons = new ArrayList<class_4185>();
        this.particleButtons.add(this.addParticleButton(i + 23, j + 16));
        this.particleButtons.add(this.addParticleButton(i + 23 + 20, j + 16));
        this.particleButtons.add(this.addParticleButton(i + 23 + 40, j + 16));
        this.particleButtons.add(this.addParticleButton(i + 23 + 60, j + 16));
        this.particleButtons.add(this.addParticleButton(i + 23 + 80, j + 16));
        this.particleButtons.add(this.addParticleButton(i + 23 + 100, j + 16));
        int selectionIndex = AVAILABLE_PARTICLES.indexOf(blockEntity.particleSpriteIdentifier);
        if (selectionIndex != -1) {
            this.particleSelectionIndex = selectionIndex;
        }
    }

    private void navigationButtonPressed(class_4185 buttonWidget) {
        this.activeParticlePage = buttonWidget == this.forwardButton ? (this.activeParticlePage + 1) % (AVAILABLE_PARTICLES.size() / 6 + 1) : (this.activeParticlePage - 1) % (AVAILABLE_PARTICLES.size() / 6 + 1);
    }

    @NotNull
    private class_342 addTextFieldWidget(int x, int y, class_2561 text, String defaultText, Predicate<String> textPredicate) {
        class_342 textFieldWidget = new class_342(this.field_22793, x, y, 31, 16, text);
        textFieldWidget.method_1890(textPredicate);
        textFieldWidget.method_1856(true);
        textFieldWidget.method_1888(true);
        textFieldWidget.method_1868(-1);
        textFieldWidget.method_1860(-1);
        textFieldWidget.method_1858(false);
        textFieldWidget.method_1880(10);
        textFieldWidget.method_1852(defaultText);
        textFieldWidget.method_1863(this::onTextBoxValueChanged);
        this.method_25429((class_364)textFieldWidget);
        return textFieldWidget;
    }

    @NotNull
    private class_4185 addParticleButton(int x, int y) {
        class_4185 button = new class_4185(x, y, 20, 20, (class_2561)new class_2585("asdfsd.asdfsd"), this::particleButtonPressed);
        this.method_25429((class_364)button);
        return button;
    }

    private void particleButtonPressed(class_4185 buttonWidget) {
        int buttonIndex = this.particleButtons.indexOf(buttonWidget);
        int newIndex = 6 * this.activeParticlePage + buttonIndex;
        if (newIndex < AVAILABLE_PARTICLES.size() - 1) {
            this.particleSelectionIndex = newIndex;
            this.onValuesChanged();
        }
    }

    private void collisionButtonPressed(class_4185 buttonWidget) {
        this.collisionsEnabled = !this.collisionsEnabled;
        this.onValuesChanged();
    }

    private void onTextBoxValueChanged(@NotNull String newValue) {
        this.onValuesChanged();
    }

    protected boolean isDecimalNumber(@NotNull String text) {
        return text.matches("^(-)?\\d*+(?:\\.\\d*)?$");
    }

    private boolean isPositiveDecimalNumberUnderThousand(String text) {
        try {
            return Double.parseDouble(text) < 1000.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isAbsoluteDecimalNumberThousand(String text) {
        try {
            return Math.abs(Double.parseDouble(text)) < 1000.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isPositiveDecimalNumberUnderTen(String text) {
        try {
            return Double.parseDouble(text) < 10.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isPositiveDecimalNumber(@NotNull String text) {
        return text.matches("^\\d*+(?:\\.\\d*)?$");
    }

    protected boolean isPositiveWholeNumber(@NotNull String text) {
        return text.matches("^\\d*$");
    }

    protected boolean isPositiveWholeNumberUnderThousand(@NotNull String text) {
        try {
            return Integer.parseInt(text) < 1000;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isBetweenZeroAndOne(@NotNull String text) {
        try {
            float f = Float.parseFloat(text);
            return f >= 0.0f && f <= 1.0f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void onValuesChanged() {
        try {
            class_2540 packetByteBuf = PacketByteBufs.create();
            this.writeSettings(packetByteBuf);
            ClientPlayNetworking.send((class_2960)SpectrumC2SPackets.CHANGE_PARTICLE_SPAWNER_SETTINGS_PACKET_ID, (class_2540)packetByteBuf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Contract(value="_ -> param1")
    @NotNull
    private class_2540 writeSettings(@NotNull class_2540 packetByteBuf) {
        packetByteBuf.method_10814(AVAILABLE_PARTICLES.get(this.particleSelectionIndex).toString());
        packetByteBuf.writeFloat(Float.parseFloat(this.amountField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.positionXField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.positionYField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.positionZField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.positionXVarianceField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.positionYVarianceField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.positionZVarianceField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.velocityXField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.velocityYField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.velocityZField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.velocityXVarianceField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.velocityYVarianceField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.velocityZVarianceField.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.scale.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.scaleVariance.method_1882()));
        packetByteBuf.writeInt(Integer.parseInt(this.duration.method_1882()));
        packetByteBuf.writeInt(Integer.parseInt(this.durationVariance.method_1882()));
        packetByteBuf.writeFloat(Float.parseFloat(this.gravity.method_1882()));
        packetByteBuf.writeBoolean(this.collisionsEnabled);
        return packetByteBuf;
    }
}

