/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.events;

import blue.endless.jankson.annotation.Nullable;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.particle.effect.ItemTransfer;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;

public class ItemEntityTransferListener
implements class_5714 {
    protected final class_5716 positionSource;
    protected final int range;
    protected final Callback callback;
    protected Optional<class_5712> event = Optional.empty();
    protected int distance;
    protected int delay = 0;
    protected class_1542 itemEntity;

    public ItemEntityTransferListener(class_5716 positionSource, int range, Callback listener) {
        this.positionSource = positionSource;
        this.range = range;
        this.callback = listener;
    }

    public void tick(class_1937 world) {
        if (this.event.isPresent()) {
            --this.delay;
            if (this.delay <= 0) {
                this.delay = 0;
                this.callback.accept(world, this, this.event.get(), this.distance);
                this.event = Optional.empty();
            }
        }
    }

    public class_5716 method_32946() {
        return this.positionSource;
    }

    public int method_32948() {
        return this.range;
    }

    public boolean method_32947(class_1937 world, class_5712 event, @Nullable class_1297 entity, class_2338 pos) {
        if (!this.shouldActivate(event, entity)) {
            return false;
        }
        Optional optional = this.positionSource.method_32956(world);
        if (!optional.isPresent()) {
            return false;
        }
        this.itemEntity = (class_1542)entity;
        class_2338 blockPos = (class_2338)optional.get();
        if (!this.callback.accepts(world, this, pos, event, entity)) {
            return false;
        }
        this.listen(world, event, pos, blockPos);
        return true;
    }

    boolean shouldActivate(class_5712 event, @Nullable class_1297 entity) {
        if (this.event.isEmpty() && entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            return itemEntity.method_5805() && !itemEntity.method_6983().method_7960();
        }
        return false;
    }

    private void listen(class_1937 world, class_5712 event, class_2338 pos, class_2338 sourcePos) {
        this.event = Optional.of(event);
        if (world instanceof class_3218) {
            this.delay = this.distance = class_3532.method_15357((double)Math.sqrt(pos.method_33106((class_2382)sourcePos, false)));
            SpectrumS2CPackets.sendItemTransferPacket((class_3218)world, new ItemTransfer(pos, this.positionSource, this.delay));
        }
    }

    public class_1542 getItemEntity() {
        return this.itemEntity;
    }

    public static interface Callback {
        public boolean accepts(class_1937 var1, class_5714 var2, class_2338 var3, class_5712 var4, @Nullable class_1297 var5);

        public void accept(class_1937 var1, class_5714 var2, class_5712 var3, int var4);
    }
}

