/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.enums;

import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.enums.GemstoneColor;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public enum PedestalRecipeTier {
    BASIC,
    SIMPLE,
    ADVANCED,
    COMPLEX;


    @Contract(pure=true)
    public static GemstoneColor[] getAvailableGemstoneDustColors(@NotNull PedestalRecipeTier pedestalRecipeTier) {
        switch (pedestalRecipeTier) {
            case COMPLEX: {
                return GemstoneColor.values();
            }
            case ADVANCED: {
                return new GemstoneColor[]{GemstoneColor.CYAN, GemstoneColor.MAGENTA, GemstoneColor.YELLOW, GemstoneColor.BLACK};
            }
        }
        return new GemstoneColor[]{GemstoneColor.CYAN, GemstoneColor.MAGENTA, GemstoneColor.YELLOW};
    }

    @Contract(pure=true)
    public static Optional<PedestalRecipeTier> getHighestUnlockedRecipeTier(class_1657 playerEntity) {
        if (Support.hasAdvancement(playerEntity, new class_2960("spectrum", "lategame/build_complex_pedestal_structure"))) {
            return Optional.of(COMPLEX);
        }
        if (Support.hasAdvancement(playerEntity, new class_2960("spectrum", "midgame/build_advanced_pedestal_structure"))) {
            return Optional.of(ADVANCED);
        }
        if (Support.hasAdvancement(playerEntity, new class_2960("spectrum", "build_basic_pedestal_structure"))) {
            return Optional.of(SIMPLE);
        }
        if (Support.hasAdvancement(playerEntity, new class_2960("spectrum", "place_pedestal"))) {
            return Optional.of(BASIC);
        }
        return Optional.empty();
    }

    public static boolean hasUnlockedRequiredTier(class_1657 playerEntity, @NotNull PedestalRecipeTier pedestalRecipeTier) {
        switch (pedestalRecipeTier) {
            case BASIC: {
                return Support.hasAdvancement(playerEntity, new class_2960("spectrum", "place_pedestal"));
            }
            case SIMPLE: {
                return Support.hasAdvancement(playerEntity, new class_2960("spectrum", "build_basic_pedestal_structure"));
            }
            case ADVANCED: {
                return Support.hasAdvancement(playerEntity, new class_2960("spectrum", "midgame/build_advanced_pedestal_structure"));
            }
            case COMPLEX: {
                return Support.hasAdvancement(playerEntity, new class_2960("spectrum", "lategame/build_complex_pedestal_structure"));
            }
        }
        return false;
    }

    public static Optional<PedestalRecipeTier> hasJustUnlockedANewRecipeTier(@NotNull class_2960 advancementIdentifier) {
        if (advancementIdentifier.equals((Object)new class_2960("spectrum", "place_pedestal"))) {
            return Optional.of(BASIC);
        }
        if (advancementIdentifier.equals((Object)new class_2960("spectrum", "build_basic_pedestal_structure"))) {
            return Optional.of(SIMPLE);
        }
        if (advancementIdentifier.equals((Object)new class_2960("spectrum", "midgame/build_advanced_pedestal_structure"))) {
            return Optional.of(ADVANCED);
        }
        if (advancementIdentifier.equals((Object)new class_2960("spectrum", "lategame/build_complex_pedestal_structure"))) {
            return Optional.of(COMPLEX);
        }
        return Optional.empty();
    }
}

