/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import com.google.common.collect.Lists;
import de.dafuqs.spectrum.blocks.gravity.GravitableBlock;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2968;
import net.minecraft.class_3532;
import net.minecraft.class_4538;

public class GravityBlockEntity
extends class_1297 {
    public int floatTime;
    private class_2680 blockState = class_2246.field_10102.method_9564();
    private float gravityModifier = 1.0f;
    private int maxDamage = 5;
    private float damagePerFallenBlock = 0.5f;
    protected static final class_2940<class_2338> ORIGIN = class_2945.method_12791(GravityBlockEntity.class, (class_2941)class_2943.field_13324);

    public GravityBlockEntity(class_1299<? extends GravityBlockEntity> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
    }

    public GravityBlockEntity(class_1937 world, double x, double y, double z, class_2680 gravityBlockState) {
        this(SpectrumEntityTypes.GRAVITY_BLOCK, world);
        this.blockState = gravityBlockState;
        this.gravityModifier = gravityBlockState.method_26204() instanceof GravitableBlock ? ((GravitableBlock)gravityBlockState.method_26204()).getGravityMod() : 1.0f;
        this.field_23807 = true;
        this.method_30634(x, y, z);
        this.method_18799(class_243.field_1353);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.setOrigin(new class_2338(this.method_19538()));
    }

    public class_238 method_33332() {
        if (this.field_6011 == null) {
            return super.method_33332();
        }
        class_265 collisionShape = class_259.method_1077();
        return collisionShape.method_1107().method_997(this.method_19538().method_1020(new class_243(0.5, 0.0, 0.5)));
    }

    public boolean method_5732() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public class_2338 getOrigin() {
        return (class_2338)this.field_6011.method_12789(ORIGIN);
    }

    public void setOrigin(class_2338 origin) {
        this.field_6011.method_12778(ORIGIN, (Object)origin);
        this.method_30634(this.method_23317(), this.method_23318(), this.method_23321());
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_30948() {
        return this.method_5863();
    }

    public boolean method_30949(class_1297 other) {
        return !(other instanceof GravityBlockEntity) && super.method_30949(other);
    }

    public void method_5773() {
    }

    public void onPostTick() {
        if (this.blockState.method_26215()) {
            this.method_31472();
        } else {
            class_2338 blockPos;
            class_2248 block = this.blockState.method_26204();
            if (this.floatTime++ == 0) {
                blockPos = this.method_24515();
                if (this.field_6002.method_8320(blockPos).method_27852(block)) {
                    this.field_6002.method_8650(blockPos, false);
                } else if (!this.field_6002.field_9236) {
                    this.method_31472();
                    return;
                }
            }
            if (!this.method_5740()) {
                if (this.floatTime > 100) {
                    this.method_18799(this.method_18798().method_1031(0.0, (double)(this.gravityModifier / 10.0f), 0.0));
                } else {
                    this.method_18799(this.method_18798().method_1031(0.0, Math.min(Math.sin(Math.PI * (double)this.field_6012 / 100.0), 1.0) * (double)(this.gravityModifier / 10.0f), 0.0));
                }
            }
            class_238 oldBox = this.method_5829();
            this.method_5784(class_1313.field_6308, this.method_18798());
            class_238 newBox = this.method_5829();
            List otherEntities = this.field_6002.method_8335((class_1297)this, oldBox.method_991(newBox));
            for (class_1297 entity : otherEntities) {
                if (entity instanceof GravityBlockEntity || entity.field_5960 || !this.method_5863()) continue;
                entity.field_6017 = 0.0f;
                entity.method_5814(entity.method_19538().field_1352, this.method_5829().field_1325, entity.method_19538().field_1350);
                entity.method_24830(true);
            }
            if (!this.field_6002.field_9236) {
                blockPos = this.method_24515();
                if (!this.field_5992) {
                    if (!this.field_6002.field_9236) {
                        if (this.floatTime > 100 && blockPos.method_10264() < 1) {
                            if (this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                                this.method_5706((class_1935)block);
                            }
                            this.method_31472();
                        } else if (this.floatTime > 500) {
                            this.method_31472();
                        }
                    }
                } else {
                    class_2680 blockState = this.field_6002.method_8320(blockPos);
                    this.method_18799(this.method_18798().method_18805(0.7, 0.5, 0.7));
                    this.method_31472();
                    boolean canReplace = blockState.method_26166((class_1750)new class_2968(this.field_6002, blockPos, class_2350.field_11033, class_1799.field_8037, class_2350.field_11036));
                    if (canReplace) {
                        canReplace = blockState.method_26166((class_1750)new class_2968(this.field_6002, blockPos, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033));
                    }
                    boolean canPlace = this.blockState.method_26184((class_4538)this.field_6002, blockPos);
                    if (canReplace && canPlace) {
                        if (!this.field_6002.method_8652(blockPos, this.blockState, 3) && this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                            this.method_5706((class_1935)block);
                        }
                    } else if (this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                        this.method_5706((class_1935)block);
                    }
                }
            }
            this.method_18799(this.method_18798().method_1021(0.99));
        }
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 damageSource) {
        int damage;
        int traveledDistance;
        if (!this.field_6002.field_9236 && (traveledDistance = class_3532.method_15386((float)(distance - 1.0f))) > 0 && (damage = Math.min(class_3532.method_15375((float)((float)traveledDistance * this.damagePerFallenBlock)), this.maxDamage)) > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_6002.method_8335((class_1297)this, this.method_5829().method_1009(0.0, 3.0 * Math.signum(this.method_18798().field_1351), 0.0).method_1009(0.0, -0.5 * Math.signum(this.method_18798().field_1351), 0.0)));
            for (class_1297 entity : list) {
                entity.method_5643(SpectrumDamageSources.FLOATBLOCK, (float)damage);
            }
        }
        return false;
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.blockState));
        compound.method_10569("Time", this.floatTime);
        compound.method_10548("FallHurtAmount", this.damagePerFallenBlock);
        compound.method_10569("FallHurtMax", this.maxDamage);
    }

    protected void method_5749(class_2487 compound) {
        this.blockState = class_2512.method_10681((class_2487)compound.method_10562("BlockState"));
        this.floatTime = compound.method_10550("Time");
        if (compound.method_10573("HurtEntities", 99)) {
            this.damagePerFallenBlock = compound.method_10583("FallHurtAmount");
            this.maxDamage = compound.method_10550("FallHurtMax");
        }
        if (this.blockState.method_26215()) {
            this.blockState = SpectrumBlocks.PALETUR_FRAGMENT_BLOCK.method_9564();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_1937 getWorldClient() {
        return this.field_6002;
    }

    public boolean method_5862() {
        return false;
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    public boolean method_5833() {
        return true;
    }

    protected void method_5693() {
        this.field_6011.method_12784(ORIGIN, (Object)class_2338.field_10980);
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this, class_2248.method_9507((class_2680)this.getBlockState()));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.blockState = class_2248.method_9531((int)packet.method_11166());
        this.gravityModifier = this.blockState.method_26204() instanceof GravitableBlock ? ((GravitableBlock)this.blockState.method_26204()).getGravityMod() : 1.0f;
        this.field_23807 = true;
        double d = packet.method_11175();
        double e = packet.method_11174();
        double f = packet.method_11176();
        this.method_5814(d, e + (double)((1.0f - this.method_17682()) / 2.0f), f);
        this.setOrigin(this.method_24515());
    }

    public static interface PostTicker {
        public void postTick();
    }
}

