/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.config;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="Spectrum")
public class SpectrumConfig
implements ConfigData {
    @Comment(value="The heights where citrine and topaz geodes will spawn\nBy default citrine will generate slightly below sea level (y=32-60)\nwhile topaz will generate at the top of mountains (everywhere from y=82+)\nif the worldgen has lots of high mountains consider raising the TopazGeodeMinFixedGenerationHeight")
    public int CitrineGeodeMinAboveBottomGenerationHeight = 96;
    public int CitrineGeodeFixedMaxGenerationHeight = 55;
    public int TopazGeodeMinFixedGenerationHeight = 82;
    public int TopazGeodeMaxBelowTopGenerationHeight = 0;
    @Comment(value="Every x chunks there is a chance for a geode to generate, Moonstone geodes do not spawn in the Overworld")
    public int TopazGeodeChunkChance = 7;
    public int CitrineGeodeChunkChance = 50;
    public int MoonstoneGeodeChunkChance = 35;
    @Comment(value="The amount of colored tree patches to generate every X chunks")
    public int ColoredTreePatchChanceChunk = 75;
    @Comment(value="The chance that an Enderman is holding a special treasure block on spawn\nSeparate value for Endermen spawning in the end, since there are LOTS of them there\nThose blocks do not gate progression, so it is not that drastic not finding any right away.\nBetter to let players stumble about them organically instead of forcing it.")
    public float EndermanHoldingEnderTreasureChance = 0.08f;
    public float EndermanHoldingEnderTreasureInEndChance = 0.005f;
    @Comment(value="Worlds where shooting stars spawn for players. Shooting Stars will only spawn for players with sufficient progress in the mod")
    public List<String> ShootingStarWorlds = new ArrayList<String>();
    @Comment(value="Worlds where lightning strikes can spawn Storm Stones")
    public List<String> LightningStonesWorlds = new ArrayList<String>();
    @Comment(value="chance for a lightning strike to spawn a Storm Stone")
    public float LightningStonesChance = 0.5f;
    @Comment(value="Shooting star spawns are checked every night between time 13000 and 22000, every 100 ticks (so 90 chances per night).\nBy default, there is a 0.02 ^= 2 % chance at each of those check times. Making it ~3 shooting star spawns\nper night per player that unlocked the required progression.")
    public float ShootingStarChance = 0.02f;
    @Comment(value="The biomes where the biome specific plants are growing")
    public List<String> MermaidsBrushGenerationBiomes = new ArrayList<String>();
    public List<String> QuitoxicReedsGenerationBiomes = new ArrayList<String>();
    @Comment(value="The time in ticks it takes a Pigment Pedestal to autocraft a vanilla crafting table recipe without upgrades")
    public int VanillaRecipeCraftingTimeTicks = 40;
    @Comment(value="How fast decay will be spreading on random tick\ncan be used to slow down propagation speed of decay in the worlds\ndecay does use very few resources, but if your fear of someone letting decay\nspread free or using higher random tick rates than vanilla you can limit the spreading rate here\n\nFading and Failing do no real harm to the world. If you turn up these values too high players\nmay lack the feedback they need that what they are doing is correct\n\n1.0: every random tick (default)\n0.5: Every second random tick\n0.0: never (forbidden - players would be unable to progress)")
    public float FadingDecayTickRate = 1.0f;
    public float FailingDecayTickRate = 1.0f;
    public float RuinDecayTickRate = 1.0f;
    public float TerrorDecayTickRate = 1.0f;
    @Comment(value="Enable or disable specific enchantments. Resonance and Voiding can not be disabled.\nThis does only disable the registration of said Enchantments, not all recipes based on them (except for Enchantment Upgrade Recipes)\n")
    public boolean AutoSmeltEnchantmentEnabled = true;
    public boolean ExuberanceEnchantmentEnabled = true;
    public boolean InventoryInsertionEnchantmentEnabled = true;
    public boolean PestControlEnchantmentEnabled = true;
    public boolean TreasureHunterEnchantmentEnabled = true;
    public boolean DisarmingEnchantmentEnabled = true;
    public boolean FirstStrikeEnchantmentEnabled = true;
    public boolean ImprovedCriticalEnchantmentEnabled = true;
    public boolean InertiaEnchantmentEnabled = true;
    public boolean CloversFavorEnchantmentEnabled = true;
    public boolean SniperEnchantmentEnabled = true;
    public boolean TightGripEnchantmentEnabled = true;
    public boolean DamageProofEnchantmentEnabled = true;
    @Comment(value="The max levels for all Enchantments")
    public int TreasureHunterMaxLevel = 3;
    public int DisarmingMaxLevel = 2;
    public int FirstStrikeMaxLevel = 2;
    public int ImprovedCriticalMaxLevel = 2;
    public int InertiaMaxLevel = 3;
    public int CloversFavorMaxLevel = 3;
    public int TightGripMaxLevel = 2;
    @Comment(value="Exuberance increases experience gained when killing mobs. With 25% bonus XP and 5 levels this would mean 2,25x XP on max level")
    public int ExuberanceMaxLevel = 5;
    public float ExuberanceBonusExperiencePercentPerLevel = 0.25f;
    @Comment(value="In vanilla, crits are a flat 50 % damage bonus. Improved Critical increases this damage by additional 50 % per level by default")
    public float ImprovedCriticalExtraDamageMultiplierPerLevel = 0.5f;
    @Comment(value="Flat additional damage dealt with each level of the First Strike enchantment")
    public float FirstStrikeDamagePerLevel = 2.0f;
    @Comment(value="The percentile a mobs armor/hand stacks are being dropped when hit with a Disarming enchanted weapon per the enchantments level")
    public float DisarmingChancePerLevelMobs = 0.01f;
    @Comment(value="If > 0 the Disarming Enchantment is able to remove armor and hand tools from a hit player. Should be a far smaller chance than for mobs")
    public float DisarmingChancePerLevelPlayers = 0.001f;
    @Comment(value="The duration a glow ink sac gives night vision when wearing a glow vision helmet in seconds")
    public int GlowVisionGogglesDuration = 240;

    public void validatePostLoad() {
        if (this.VanillaRecipeCraftingTimeTicks <= 0) {
            this.VanillaRecipeCraftingTimeTicks = 40;
        }
        if (this.FadingDecayTickRate <= 0.0f) {
            this.FadingDecayTickRate = 1.0f;
        }
        if (this.FailingDecayTickRate <= 0.0f) {
            this.FadingDecayTickRate = 1.0f;
        }
        if (this.RuinDecayTickRate <= 0.0f) {
            this.RuinDecayTickRate = 1.0f;
        }
        if (this.ShootingStarChance <= 0.0f) {
            this.ShootingStarChance = 0.01f;
        }
        if (this.LightningStonesChance <= 0.0f) {
            this.ShootingStarChance = 0.3f;
        }
        if (this.EndermanHoldingEnderTreasureChance <= 0.0f) {
            this.EndermanHoldingEnderTreasureChance = 0.05f;
        }
        if (this.TreasureHunterMaxLevel <= 0) {
            this.TreasureHunterMaxLevel = 3;
        }
        if (this.ExuberanceMaxLevel <= 0) {
            this.ExuberanceMaxLevel = 5;
        }
        if (this.ExuberanceBonusExperiencePercentPerLevel <= 0.0f) {
            this.ExuberanceBonusExperiencePercentPerLevel = 0.2f;
        }
        if (this.ImprovedCriticalExtraDamageMultiplierPerLevel <= 0.0f) {
            this.ImprovedCriticalExtraDamageMultiplierPerLevel = 0.5f;
        }
        if (this.FirstStrikeDamagePerLevel <= 0.0f) {
            this.FirstStrikeDamagePerLevel = 3.0f;
        }
        if (this.ShootingStarWorlds.isEmpty()) {
            this.ShootingStarWorlds.add("minecraft:overworld");
            this.ShootingStarWorlds.add("starry_sky:starry_sky");
        }
        if (this.LightningStonesWorlds.isEmpty()) {
            this.LightningStonesWorlds.add("minecraft:overworld");
            this.LightningStonesWorlds.add("starry_sky:starry_sky");
        }
        if (this.MermaidsBrushGenerationBiomes.isEmpty()) {
            this.MermaidsBrushGenerationBiomes.add("minecraft:ocean");
            this.MermaidsBrushGenerationBiomes.add("minecraft:cold_ocean");
            this.MermaidsBrushGenerationBiomes.add("minecraft:frozen_ocean");
            this.MermaidsBrushGenerationBiomes.add("minecraft:lukewarm_ocean");
            this.MermaidsBrushGenerationBiomes.add("minecraft:warm_ocean");
            this.MermaidsBrushGenerationBiomes.add("minecraft:deep_ocean");
            this.MermaidsBrushGenerationBiomes.add("minecraft:deep_cold_ocean");
            this.MermaidsBrushGenerationBiomes.add("minecraft:deep_frozen_ocean");
            this.MermaidsBrushGenerationBiomes.add("minecraft:deep_warm_ocean");
            this.MermaidsBrushGenerationBiomes.add("minecraft:deep_lukewarm_ocean");
        }
        if (this.QuitoxicReedsGenerationBiomes.isEmpty()) {
            this.QuitoxicReedsGenerationBiomes.add("minecraft:swamp");
        }
    }
}

