/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.patchouli;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.spectrum.enums.GemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipeRegistry;

public class PagePedestalCrafting
extends PageDoubleRecipeRegistry<PedestalCraftingRecipe> {
    private static final class_2960 BACKGROUND_TEXTURE1 = new class_2960("spectrum", "textures/gui/patchouli/pedestal_crafting1.png");
    private static final class_2960 BACKGROUND_TEXTURE2 = new class_2960("spectrum", "textures/gui/patchouli/pedestal_crafting2.png");
    private static final class_2960 BACKGROUND_TEXTURE3 = new class_2960("spectrum", "textures/gui/patchouli/pedestal_crafting3.png");
    private static final class_2960 BACKGROUND_TEXTURE4 = new class_2960("spectrum", "textures/gui/patchouli/pedestal_crafting4.png");

    public PagePedestalCrafting() {
        super(SpectrumRecipeTypes.PEDESTAL);
    }

    protected class_1799 getRecipeOutput(PedestalCraftingRecipe recipe) {
        if (recipe == null) {
            return class_1799.field_8037;
        }
        return recipe.method_8110();
    }

    protected void drawRecipe(class_4587 ms, @NotNull PedestalCraftingRecipe recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getBackgroundTextureForTier(recipe.getTier()));
        RenderSystem.enableBlend();
        class_332.method_25290((class_4587)ms, (int)(recipeX - 2), (int)(recipeY - 2), (float)0.0f, (float)0.0f, (int)106, (int)97, (int)128, (int)256);
        this.parent.drawCenteredStringNoShadow(ms, this.getTitle(second).method_30937(), 58, recipeY - 10, this.book.headerColor);
        this.parent.renderItemStack(ms, recipeX + 78, recipeY + 22, mouseX, mouseY, recipe.method_8110());
        switch (recipe.getTier()) {
            case COMPLEX: {
                this.drawGemstonePowderSlots(recipe, PedestalRecipeTier.getAvailableGemstoneDustColors(recipe.getTier()), ms, 3, recipeX, recipeY, mouseX, mouseY);
                break;
            }
            case ADVANCED: {
                this.drawGemstonePowderSlots(recipe, PedestalRecipeTier.getAvailableGemstoneDustColors(recipe.getTier()), ms, 12, recipeX, recipeY, mouseX, mouseY);
                break;
            }
            default: {
                this.drawGemstonePowderSlots(recipe, PedestalRecipeTier.getAvailableGemstoneDustColors(recipe.getTier()), ms, 22, recipeX, recipeY, mouseX, mouseY);
            }
        }
        class_2371<class_1856> ingredients = recipe.method_8117();
        int wrap = recipe.getWidth();
        for (int i = 0; i < ingredients.size(); ++i) {
            this.parent.renderIngredient(ms, recipeX + i % wrap * 19 + 3, recipeY + i / wrap * 19 + 3, mouseX, mouseY, (class_1856)ingredients.get(i));
        }
    }

    @Contract(pure=true)
    private class_2960 getBackgroundTextureForTier(@NotNull PedestalRecipeTier pedestalRecipeTier) {
        switch (pedestalRecipeTier) {
            case BASIC: {
                return BACKGROUND_TEXTURE1;
            }
            case SIMPLE: {
                return BACKGROUND_TEXTURE2;
            }
            case ADVANCED: {
                return BACKGROUND_TEXTURE3;
            }
        }
        return BACKGROUND_TEXTURE4;
    }

    protected int getRecipeHeight() {
        return 108;
    }

    private void drawGemstonePowderSlots(PedestalCraftingRecipe recipe, GemstoneColor @NotNull [] colors, class_4587 ms, int startX, int recipeX, int recipeY, int mouseX, int mouseY) {
        int h = 0;
        for (GemstoneColor color : colors) {
            int amount = recipe.getGemstonePowderInputs().getOrDefault((Object)color, 0);
            if (amount > 0) {
                this.parent.renderItemStack(ms, recipeX + startX + h * 19, recipeY + 72, mouseX, mouseY, new class_1799((class_1935)SpectrumItems.getGemstoneShard(color), amount));
            }
            ++h;
        }
    }
}

