/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.REI;

import de.dafuqs.spectrum.SpectrumClient;
import de.dafuqs.spectrum.compat.REI.GatedRecipeDisplay;
import de.dafuqs.spectrum.compat.REI.SpectrumPlugins;
import de.dafuqs.spectrum.enums.GemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class PedestalCraftingRecipeDisplay<R extends PedestalCraftingRecipe>
extends BasicDisplay
implements SimpleGridMenuDisplay,
GatedRecipeDisplay {
    private final PedestalCraftingRecipe pedestalCraftingRecipe;
    protected final List<EntryIngredient> craftingInputs;
    protected final EntryIngredient output;
    protected final float experience;
    protected final int craftingTime;
    protected final PedestalRecipeTier pedestalRecipeTier;

    public PedestalCraftingRecipeDisplay(PedestalCraftingRecipe recipe) {
        super((List)recipe.method_8117().stream().map(EntryIngredients::ofIngredient).collect(Collectors.toCollection(ArrayList::new)), Collections.singletonList(EntryIngredients.of((class_1799)recipe.method_8110())));
        this.pedestalCraftingRecipe = recipe;
        this.craftingInputs = recipe.method_8117().stream().map(EntryIngredients::ofIngredient).collect(Collectors.toCollection(ArrayList::new));
        this.output = EntryIngredients.of((class_1799)recipe.method_8110());
        this.experience = recipe.getExperience();
        this.craftingTime = recipe.getCraftingTime();
        this.pedestalRecipeTier = recipe.getTier();
        HashMap<GemstoneColor, Integer> gemstonePowderInputs = recipe.getGemstonePowderInputs();
        this.addGemstonePowderCraftingInput(gemstonePowderInputs, GemstoneColor.CYAN, SpectrumItems.TOPAZ_POWDER);
        this.addGemstonePowderCraftingInput(gemstonePowderInputs, GemstoneColor.MAGENTA, SpectrumItems.AMETHYST_POWDER);
        this.addGemstonePowderCraftingInput(gemstonePowderInputs, GemstoneColor.YELLOW, SpectrumItems.CITRINE_POWDER);
        this.addGemstonePowderCraftingInput(gemstonePowderInputs, GemstoneColor.BLACK, SpectrumItems.ONYX_POWDER);
        this.addGemstonePowderCraftingInput(gemstonePowderInputs, GemstoneColor.WHITE, SpectrumItems.MOONSTONE_POWDER);
    }

    public PedestalCraftingRecipeDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, class_1860 recipe) {
        super(inputs, outputs);
        this.craftingInputs = inputs;
        this.output = outputs.get(0);
        if (recipe instanceof PedestalCraftingRecipe) {
            PedestalCraftingRecipe pedestalCraftingRecipe;
            this.pedestalCraftingRecipe = pedestalCraftingRecipe = (PedestalCraftingRecipe)recipe;
            this.experience = pedestalCraftingRecipe.getExperience();
            this.craftingTime = pedestalCraftingRecipe.getCraftingTime();
            this.pedestalRecipeTier = pedestalCraftingRecipe.getTier();
        } else {
            this.pedestalCraftingRecipe = null;
            this.experience = 0.0f;
            this.craftingTime = 0;
            this.pedestalRecipeTier = PedestalRecipeTier.BASIC;
        }
    }

    public static BasicDisplay.Serializer<PedestalCraftingRecipeDisplay<?>> serializer() {
        return BasicDisplay.Serializer.ofSimple(PedestalCraftingRecipeDisplay::simple).inputProvider(PedestalCraftingRecipeDisplay::getOrganisedInputEntries);
    }

    @NotNull
    private static PedestalCraftingRecipeDisplay<?> simple(List<EntryIngredient> inputs, List<EntryIngredient> outputs, @NotNull Optional<class_2960> identifier) {
        class_1860 optionalRecipe = identifier.flatMap(resourceLocation -> RecipeManagerContext.getInstance().getRecipeManager().method_8130(resourceLocation)).orElse(null);
        return new PedestalCraftingRecipeDisplay(inputs, outputs, optionalRecipe);
    }

    public <T extends class_1703> List<EntryIngredient> getOrganisedInputEntries() {
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>();
        List<EntryIngredient> inputs = this.getInputEntries();
        int gemstonePowderStartIndex = inputs.size() - 5;
        for (int i = 0; i < 9; ++i) {
            list.add(EntryIngredient.empty());
        }
        for (int j = 0; j < gemstonePowderStartIndex; ++j) {
            list.set(PedestalCraftingRecipeDisplay.getSlotWithSize(this, j), inputs.get(j));
        }
        for (int k = gemstonePowderStartIndex; k < inputs.size(); ++k) {
            list.add(inputs.get(k));
        }
        return list;
    }

    public static int getSlotWithSize(@NotNull PedestalCraftingRecipeDisplay<?> display, int index) {
        return PedestalCraftingRecipeDisplay.getSlotWithSize(display.getWidth(), index);
    }

    public static int getSlotWithSize(int recipeWidth, int index) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return 3 * y + x;
    }

    private void addGemstonePowderCraftingInput(@NotNull HashMap<GemstoneColor, Integer> gemstonePowderInputs, GemstoneColor gemstoneColor, class_1792 item) {
        if (gemstonePowderInputs.containsKey((Object)gemstoneColor)) {
            int amount = gemstonePowderInputs.get((Object)gemstoneColor);
            if (amount > 0) {
                this.craftingInputs.add(EntryIngredients.of((class_1799)new class_1799((class_1935)item, amount)));
            } else {
                this.craftingInputs.add(EntryIngredient.empty());
            }
        } else {
            this.craftingInputs.add(EntryIngredient.empty());
        }
    }

    public List<EntryIngredient> getInputEntries() {
        if (this.isUnlocked()) {
            return this.craftingInputs;
        }
        return new ArrayList<EntryIngredient>();
    }

    public List<EntryIngredient> getOutputEntries() {
        if (this.isUnlocked()) {
            return this.outputs;
        }
        return new ArrayList<EntryIngredient>();
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return SpectrumPlugins.PEDESTAL_CRAFTING;
    }

    @Override
    public boolean isUnlocked() {
        if (this.pedestalCraftingRecipe == null) {
            return true;
        }
        return SpectrumClient.minecraftClient == null || this.isUnlockedClient();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isUnlockedClient() {
        return this.pedestalCraftingRecipe.canPlayerCraft((class_1657)class_310.method_1551().field_1724);
    }

    public int getWidth() {
        return this.pedestalCraftingRecipe.getWidth();
    }

    public int getHeight() {
        return this.pedestalCraftingRecipe.getHeight();
    }

    public PedestalRecipeTier getTier() {
        return this.pedestalRecipeTier;
    }
}

