/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.REI;

import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterBlockEntity;
import de.dafuqs.spectrum.compat.REI.GatedRecipeDisplay;
import de.dafuqs.spectrum.compat.REI.SpectrumPlugins;
import de.dafuqs.spectrum.items.magic_items.KnowledgeGemItem;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantmentUpgradeRecipeDisplay<R extends EnchantmentUpgradeRecipe>
implements SimpleGridMenuDisplay,
GatedRecipeDisplay {
    protected final class_1887 enchantment;
    protected final int enchantmentDestinationLevel;
    protected final int requiredExperience;
    protected final int requiredItemCount;
    @Nullable
    protected final class_2960 requiredAdvancementIdentifier;
    protected final List<EntryIngredient> inputs;
    protected final EntryIngredient output;

    public EnchantmentUpgradeRecipeDisplay(@NotNull EnchantmentUpgradeRecipe recipe) {
        this.enchantment = recipe.getEnchantment();
        this.enchantmentDestinationLevel = recipe.getEnchantmentDestinationLevel();
        this.inputs = new ArrayList<EntryIngredient>();
        this.inputs.add(EntryIngredients.ofIngredient((class_1856)((class_1856)recipe.method_8117().get(0))));
        int requiredItemCountSplit = recipe.getRequiredItemCount() / 8;
        int requiredItemCountModulo = recipe.getRequiredItemCount() % 8;
        for (int i = 0; i < 8; ++i) {
            int addAmount = i < requiredItemCountModulo ? 1 : 0;
            this.inputs.add(EntryIngredients.of((class_1799)new class_1799((class_1935)recipe.getRequiredItem(), requiredItemCountSplit + addAmount)));
        }
        this.inputs.add(EntryIngredients.of((class_1799)KnowledgeGemItem.getKnowledgeDropStackWithXP(recipe.getRequiredExperience())));
        this.output = EntryIngredients.of((class_1799)recipe.method_8110());
        this.requiredItemCount = recipe.getRequiredItemCount();
        this.requiredExperience = recipe.getRequiredExperience();
        this.requiredAdvancementIdentifier = recipe.getRequiredAdvancementIdentifier();
    }

    public List<EntryIngredient> getInputEntries() {
        if (this.isUnlocked()) {
            return this.inputs;
        }
        return new ArrayList<EntryIngredient>();
    }

    public List<EntryIngredient> getOutputEntries() {
        if (this.isUnlocked()) {
            return Collections.singletonList(this.output);
        }
        return new ArrayList<EntryIngredient>();
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return SpectrumPlugins.ENCHANTMENT_UPGRADE;
    }

    @Override
    public boolean isUnlocked() {
        if (this.enchantmentDestinationLevel > this.enchantment.method_8183()) {
            return Support.hasAdvancement((class_1657)class_310.method_1551().field_1724, this.requiredAdvancementIdentifier) && Support.hasAdvancement((class_1657)class_310.method_1551().field_1724, EnchanterBlockEntity.OVERENCHANTING_ADVANCEMENT_IDENTIFIER);
        }
        return Support.hasAdvancement((class_1657)class_310.method_1551().field_1724, this.requiredAdvancementIdentifier);
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }
}

