/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterEnchantable;
import de.dafuqs.spectrum.enchantments.SpectrumEnchantment;
import de.dafuqs.spectrum.enums.GemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.mixin.LootTableAccessor;
import de.dafuqs.spectrum.progression.BlockCloakManager;
import de.dafuqs.spectrum.progression.advancement.HasAdvancementCriterion;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.anvil_crushing.AnvilCrushingRecipe;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipe;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.color.ColorRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_161;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class ProgressionSanityCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spectrum_test_progression_sanity").requires(source -> source.method_9259(2))).executes(context -> ProgressionSanityCommand.execute((class_2168)context.getSource())));
    }

    private static int execute(class_2168 source) {
        int n;
        GemstoneColor[] lootPools2;
        class_2248 block;
        class_5321 registryKey;
        SpectrumCommon.log(Level.INFO, "##### SANITY CHECK START ######");
        for (Object entry : class_2378.field_11146.method_29722()) {
            registryKey = (class_5321)entry.getKey();
            if (!registryKey.method_29177().method_12836().equals("spectrum") || class_3481.field_33715.method_15141((Object)(block = (class_2248)entry.getValue())) || class_3481.field_33713.method_15141((Object)block) || class_3481.field_33716.method_15141((Object)block) || class_3481.field_33714.method_15141((Object)block) || SpectrumBlockTags.EXEMPT_FROM_MINEABLE_DEBUG_CHECK.method_15141((Object)block)) continue;
            SpectrumCommon.log(Level.WARN, "[SANITY: Mineable Tags] Block " + registryKey.method_29177() + " is not contained in a any vanilla mineable tag.");
        }
        for (Object entry : class_2378.field_11146.method_29722()) {
            class_52 class_522;
            registryKey = (class_5321)entry.getKey();
            if (!registryKey.method_29177().method_12836().equals("spectrum")) continue;
            block = (class_2248)entry.getValue();
            class_2960 class_29602 = block.method_26162();
            if (class_29602.equals((Object)class_39.field_844) || class_29602.method_12832().equals("blocks/air")) {
                SpectrumCommon.log(Level.WARN, "[SANITY: Loot Tables] Block " + registryKey.method_29177() + " does have a non-existent loot table");
                continue;
            }
            if (SpectrumBlockTags.EXEMPT_FROM_LOOT_TABLE_DEBUG_CHECK.method_15141((Object)block) || (lootPools2 = ((LootTableAccessor)(class_522 = source.method_9225().method_8503().method_3857().method_367(class_29602))).getPools()).length != 0) continue;
            SpectrumCommon.log(Level.WARN, "[SANITY: Loot Tables] Block " + registryKey.method_29177() + " has an empty loot table");
        }
        HashMap usedColorsForEachTier = new HashMap();
        for (PedestalRecipeTier pedestalRecipeTier : PedestalRecipeTier.values()) {
            HashMap<GemstoneColor, Integer> hashMap = new HashMap<GemstoneColor, Integer>();
            lootPools2 = GemstoneColor.values();
            n = lootPools2.length;
            for (int i = 0; i < n; ++i) {
                GemstoneColor gemstoneColor = lootPools2[i];
                hashMap.put(gemstoneColor, 0);
            }
            usedColorsForEachTier.put(pedestalRecipeTier, hashMap);
        }
        for (PedestalCraftingRecipe pedestalRecipe : SpectrumCommon.minecraftServer.method_3772().method_30027(SpectrumRecipeTypes.PEDESTAL)) {
            if (pedestalRecipe.getTier() == PedestalRecipeTier.BASIC || pedestalRecipe.getTier() == PedestalRecipeTier.SIMPLE) {
                if (pedestalRecipe.getGemstonePowderInputs().get((Object)GemstoneColor.BLACK) > 0) {
                    SpectrumCommon.log(Level.WARN, "[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + pedestalRecipe.method_8114() + "' of tier '" + pedestalRecipe.getTier() + "' is using onyx powder as input! Players will not have access to Onyx at that tier");
                }
                if (pedestalRecipe.getGemstonePowderInputs().get((Object)GemstoneColor.WHITE) > 0) {
                    SpectrumCommon.log(Level.WARN, "[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + pedestalRecipe.method_8114() + "' of tier '" + pedestalRecipe.getTier() + "' is using moonstone powder as input! Players will not have access to Moonstone at that tier");
                }
            } else if (pedestalRecipe.getTier() == PedestalRecipeTier.ADVANCED && pedestalRecipe.getGemstonePowderInputs().get((Object)GemstoneColor.WHITE) > 0) {
                SpectrumCommon.log(Level.WARN, "[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + pedestalRecipe.method_8114() + "' of tier '" + pedestalRecipe.getTier() + "' is using moonstone powder as input! Players will not have access to Moonstone at that tier");
            }
            for (Map.Entry<GemstoneColor, Integer> entry : pedestalRecipe.getGemstonePowderInputs().entrySet()) {
                ((HashMap)usedColorsForEachTier.get((Object)pedestalRecipe.getTier())).put(entry.getKey(), (Integer)((HashMap)usedColorsForEachTier.get((Object)pedestalRecipe.getTier())).get((Object)entry.getKey()) + entry.getValue());
            }
        }
        for (PedestalCraftingRecipe pedestalCraftingRecipe : SpectrumCommon.minecraftServer.method_3772().method_30027(SpectrumRecipeTypes.PEDESTAL)) {
            List<class_2960> advancementIdentifiers = pedestalCraftingRecipe.getRequiredAdvancementIdentifiers();
            if (advancementIdentifiers == null || advancementIdentifiers.isEmpty()) {
                SpectrumCommon.log(Level.WARN, "[SANITY: Pedestal Recipe Unlocks] Pedestal recipe '" + pedestalCraftingRecipe.method_8114() + "' has no required advancements set!");
                continue;
            }
            for (class_2960 class_29603 : advancementIdentifiers) {
                if (ProgressionSanityCommand.doesAdvancementExist(class_29603)) continue;
                SpectrumCommon.log(Level.WARN, "[SANITY: Pedestal Recipe Unlocks] Advancement '" + class_29603 + "' in '" + pedestalCraftingRecipe.method_8114() + "' does not exist");
            }
        }
        for (FusionShrineRecipe fusionShrineRecipe : SpectrumCommon.minecraftServer.method_3772().method_30027(SpectrumRecipeTypes.FUSION_SHRINE)) {
            if (!ProgressionSanityCommand.doesAdvancementExist(fusionShrineRecipe.getRequiredAdvancementIdentifier())) {
                SpectrumCommon.log(Level.WARN, "[SANITY: Fusion Shrine Recipe Unlocks] Advancement '" + fusionShrineRecipe.getRequiredAdvancementIdentifier() + "' in recipe '" + fusionShrineRecipe.method_8114() + "' does not exist");
            }
            for (class_1856 class_18562 : fusionShrineRecipe.method_8117()) {
                class_1799[] class_1799Array = class_18562.method_8105();
                int lootPools2 = class_1799Array.length;
                for (n = 0; n < lootPools2; ++n) {
                    class_1799 matchingItemStack = class_1799Array[n];
                    if (!ColorRegistry.ITEM_COLORS.getMapping(matchingItemStack.method_7909()).isEmpty()) continue;
                    SpectrumCommon.log(Level.WARN, "[SANITY: Fusion Shrine Recipe] Input '" + class_2378.field_11142.method_10221((Object)matchingItemStack.method_7909()) + "' in recipe '" + fusionShrineRecipe.method_8114() + "', does not exist in the item color registry. Add it for nice effects!");
                }
            }
            class_1792 outputItem = fusionShrineRecipe.method_8110().method_7909();
            if (outputItem == class_1802.field_8162 || !ColorRegistry.ITEM_COLORS.getMapping(outputItem).isEmpty()) continue;
            SpectrumCommon.log(Level.WARN, "[SANITY: Fusion Shrine Recipe] Output '" + class_2378.field_11142.method_10221((Object)outputItem) + "' in recipe '" + fusionShrineRecipe.method_8114() + "', does not exist in the item color registry. Add it for nice effects!");
        }
        for (EnchanterRecipe enchanterRecipe : SpectrumCommon.minecraftServer.method_3772().method_30027(SpectrumRecipeTypes.ENCHANTER)) {
            if (!ProgressionSanityCommand.doesAdvancementExist(enchanterRecipe.getRequiredAdvancementIdentifier())) {
                SpectrumCommon.log(Level.WARN, "[SANITY: Enchanting Recipe Unlocks] Advancement '" + enchanterRecipe.getRequiredAdvancementIdentifier() + "' in recipe '" + enchanterRecipe.method_8114() + "' does not exist");
            }
            for (class_1856 class_18563 : enchanterRecipe.method_8117()) {
                class_1799[] class_1799Array = class_18563.method_8105();
                int lootPools2 = class_1799Array.length;
                for (n = 0; n < lootPools2; ++n) {
                    class_1799 matchingItemStack = class_1799Array[n];
                    if (!ColorRegistry.ITEM_COLORS.getMapping(matchingItemStack.method_7909()).isEmpty()) continue;
                    SpectrumCommon.log(Level.WARN, "[SANITY: Enchanting Recipe] Input '" + class_2378.field_11142.method_10221((Object)matchingItemStack.method_7909()) + "' in recipe '" + enchanterRecipe.method_8114() + "', does not exist in the item color registry. Add it for nice effects!");
                }
            }
            Iterator outputItem = enchanterRecipe.method_8110().method_7909();
            if (!ColorRegistry.ITEM_COLORS.getMapping((class_1792)outputItem).isEmpty()) continue;
            SpectrumCommon.log(Level.WARN, "[SANITY: Enchanting Recipe] Output '" + class_2378.field_11142.method_10221((Object)outputItem) + "' in recipe '" + enchanterRecipe.method_8114() + "', does not exist in the item color registry. Add it for nice effects!");
        }
        for (EnchantmentUpgradeRecipe enchantmentUpgradeRecipe : SpectrumCommon.minecraftServer.method_3772().method_30027(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE)) {
            if (!ProgressionSanityCommand.doesAdvancementExist(enchantmentUpgradeRecipe.getRequiredAdvancementIdentifier())) {
                SpectrumCommon.log(Level.WARN, "[SANITY: Enchantment Upgrade Recipe Unlocks] Advancement '" + enchantmentUpgradeRecipe.getRequiredAdvancementIdentifier() + "' in recipe '" + enchantmentUpgradeRecipe.method_8114() + "' does not exist");
            }
            for (class_1856 class_18564 : enchantmentUpgradeRecipe.method_8117()) {
                for (class_1799 matchingItemStack : class_18564.method_8105()) {
                    if (!ColorRegistry.ITEM_COLORS.getMapping(matchingItemStack.method_7909()).isEmpty()) continue;
                    SpectrumCommon.log(Level.WARN, "[SANITY: Enchantment Upgrade Recipe] Input '" + class_2378.field_11142.method_10221((Object)matchingItemStack.method_7909()) + "' in recipe '" + enchantmentUpgradeRecipe.method_8114() + "', does not exist in the item color registry. Add it for nice effects!");
                }
            }
            Iterator outputItem = enchantmentUpgradeRecipe.method_8110().method_7909();
            if (!ColorRegistry.ITEM_COLORS.getMapping((class_1792)outputItem).isEmpty()) continue;
            SpectrumCommon.log(Level.WARN, "[SANITY: Enchantment Upgrade Recipe] Output '" + class_2378.field_11142.method_10221((Object)outputItem) + "' in recipe '" + enchantmentUpgradeRecipe.method_8114() + "', does not exist in the item color registry. Add it for nice effects!");
        }
        for (Map.Entry cloaks : BlockCloakManager.getAdvancementIdentifiersAndRegisteredCloaks().entrySet()) {
            if (ProgressionSanityCommand.doesAdvancementExist((class_2960)cloaks.getKey())) continue;
            SpectrumCommon.log(Level.WARN, "[SANITY: Block Cloaks] Advancement '" + ((class_2960)cloaks.getKey()).toString() + "' for block / item cloaking does not exist. Registered cloaks: " + ((List)cloaks.getValue()).size());
        }
        for (class_161 advancement : SpectrumCommon.minecraftServer.method_3851().method_12893()) {
            for (class_175 class_1752 : advancement.method_682().values()) {
                class_184 class_1842 = class_1752.method_774();
                class_2960 id = class_1842.method_806();
                if (!id.equals((Object)HasAdvancementCriterion.ID) || !(class_1842 instanceof HasAdvancementCriterion.Conditions)) continue;
                HasAdvancementCriterion.Conditions hasAdvancementConditions = (HasAdvancementCriterion.Conditions)class_1842;
                class_2960 advancementIdentifier = hasAdvancementConditions.getAdvancementIdentifier();
                class_161 advancementCriterionAdvancement = SpectrumCommon.minecraftServer.method_3851().method_12896(advancementIdentifier);
                if (advancementCriterionAdvancement != null) continue;
                SpectrumCommon.log(Level.WARN, "[SANITY: Has_Advancement Criteria] Advancement '" + advancement.method_688() + "' references advancement '" + advancementIdentifier + "' that does not exist");
            }
        }
        for (AnvilCrushingRecipe anvilCrushingRecipe : SpectrumCommon.minecraftServer.method_3772().method_30027(SpectrumRecipeTypes.ANVIL_CRUSHING)) {
            class_3414 soundEvent = anvilCrushingRecipe.getSoundEvent();
            if (soundEvent != null) continue;
            SpectrumCommon.log(Level.WARN, "[SANITY: Anvil Crushing] Recipe '" + anvilCrushingRecipe.method_8114() + "' has a nonexistent sound set");
        }
        for (Map.Entry enchantment : class_2378.field_11160.method_29722()) {
            Object v = enchantment.getValue();
            if (!(v instanceof SpectrumEnchantment)) continue;
            SpectrumEnchantment spectrumEnchantment = (SpectrumEnchantment)((Object)v);
            class_2960 class_29604 = spectrumEnchantment.getUnlockAdvancementIdentifier();
            class_161 class_1612 = SpectrumCommon.minecraftServer.method_3851().method_12896(class_29604);
            if (class_1612 != null) continue;
            SpectrumCommon.log(Level.WARN, "[SANITY: Enchantments] Enchantment '" + ((class_5321)enchantment.getKey()).method_29177() + "' references advancement '" + class_29604 + "' that does not exist");
        }
        for (Map.Entry item : class_2378.field_11142.method_29722()) {
            class_1792 i = (class_1792)item.getValue();
            if (!(i instanceof EnchanterEnchantable) || i.method_7837() >= 1) continue;
            SpectrumCommon.log(Level.WARN, "[SANITY: Enchantability] Item '" + ((class_5321)item.getKey()).method_29177() + "' is EnchanterEnchantable, but has enchantability of < 1");
        }
        SpectrumCommon.log(Level.INFO, "##### SANITY CHECK FINISHED ######");
        SpectrumCommon.log(Level.INFO, "##### SANITY CHECK PEDESTAL RECIPE STATISTICS ######");
        for (PedestalRecipeTier pedestalRecipeTier : PedestalRecipeTier.values()) {
            HashMap hashMap = (HashMap)usedColorsForEachTier.get((Object)pedestalRecipeTier);
            SpectrumCommon.log(Level.INFO, "[SANITY: Pedestal Recipe Gemstone Usages] Gemstone Powder for tier " + StringUtils.leftPad((String)pedestalRecipeTier.toString(), (int)8) + ": C:" + StringUtils.leftPad((String)((Integer)hashMap.get((Object)GemstoneColor.CYAN)).toString(), (int)3) + " M:" + StringUtils.leftPad((String)((Integer)hashMap.get((Object)GemstoneColor.MAGENTA)).toString(), (int)3) + " Y:" + StringUtils.leftPad((String)((Integer)hashMap.get((Object)GemstoneColor.YELLOW)).toString(), (int)3) + " K:" + StringUtils.leftPad((String)((Integer)hashMap.get((Object)GemstoneColor.BLACK)).toString(), (int)3) + " W:" + StringUtils.leftPad((String)((Integer)hashMap.get((Object)GemstoneColor.WHITE)).toString(), (int)3));
        }
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)class_12972;
            serverPlayerEntity.method_7353((class_2561)new class_2588("commands.spectrum.progression_sanity.success"), false);
        }
        return 0;
    }

    private static boolean doesAdvancementExist(class_2960 identifier) {
        return SpectrumCommon.minecraftServer.method_3851().method_12896(identifier) != null;
    }
}

