/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.upgrade;

import com.google.common.collect.Maps;
import de.dafuqs.spectrum.blocks.upgrade.UpgradeBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;

public interface Upgradeable {
    public void resetUpgrades();

    public void calculateUpgrades();

    public static class_2499 toNbt(@NotNull Map<UpgradeType, Double> upgrades) {
        class_2499 nbtList = new class_2499();
        if (!upgrades.isEmpty()) {
            for (Map.Entry<UpgradeType, Double> upgrade : upgrades.entrySet()) {
                class_2487 upgradeCompound = new class_2487();
                upgradeCompound.method_10582("Type", upgrade.getKey().toString());
                upgradeCompound.method_10549("Power", upgrade.getValue().doubleValue());
                nbtList.add((Object)upgradeCompound);
            }
        }
        return nbtList;
    }

    public static Map<UpgradeType, Double> fromNbt(@NotNull class_2499 nbtList) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            UpgradeType upgradeType = UpgradeType.valueOf(nbtCompound.method_10558("Type"));
            double upgradeMod = nbtCompound.method_10574("Power");
            map.put(upgradeType, upgradeMod);
        }
        return map;
    }

    public static class_3545<Integer, Map<UpgradeType, Double>> checkUpgradeMods(class_1937 world, class_2338 blockPos, int horizontalOffset, int verticalOffset) {
        ArrayList<class_2338> offsetPosList = new ArrayList<class_2338>();
        offsetPosList.add(blockPos.method_10069(horizontalOffset, verticalOffset, horizontalOffset));
        offsetPosList.add(blockPos.method_10069(horizontalOffset, verticalOffset, -horizontalOffset));
        offsetPosList.add(blockPos.method_10069(-horizontalOffset, verticalOffset, horizontalOffset));
        offsetPosList.add(blockPos.method_10069(-horizontalOffset, verticalOffset, -horizontalOffset));
        HashMap upgradeMods = new HashMap();
        int upgradeCount = 0;
        for (class_2338 offsetPos : offsetPosList) {
            class_2248 block = world.method_8320(offsetPos).method_26204();
            if (!(block instanceof UpgradeBlock)) continue;
            UpgradeBlock upgradeBlock = (UpgradeBlock)block;
            UpgradeType upgradeType = upgradeBlock.getUpgradeType();
            double upgradeMod = upgradeBlock.getUpgradeMod();
            if (upgradeMods.containsKey((Object)upgradeType)) {
                ((List)upgradeMods.get((Object)upgradeType)).add(upgradeMod);
            } else {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(upgradeMod);
                upgradeMods.put(upgradeType, arrayList);
            }
            ++upgradeCount;
        }
        LinkedHashMap upgradeMap = Maps.newLinkedHashMap();
        for (UpgradeType upgradeType : UpgradeType.values()) {
            if (upgradeMods.containsKey((Object)upgradeType)) {
                List upgradeModList = (List)upgradeMods.get((Object)upgradeType);
                Collections.sort(upgradeModList);
                Collections.reverse(upgradeModList);
                double resultingMod = 0.0;
                for (int i = 0; i < upgradeModList.size(); ++i) {
                    resultingMod += (Double)upgradeModList.get(i) * ((4.0 - (double)i) / 4.0);
                }
                upgradeMap.put(upgradeType, 1.0 + resultingMod);
                continue;
            }
            upgradeMap.put(upgradeType, 1.0);
        }
        return new class_3545((Object)upgradeCount, (Object)upgradeMap);
    }

    public static enum UpgradeType {
        SPEED,
        EFFICIENCY,
        YIELD,
        EXPERIENCE;

    }
}

