/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.shooting_star;

import de.dafuqs.spectrum.ColorHelper;
import de.dafuqs.spectrum.blocks.shooting_star.ShootingStarBlockEntity;
import de.dafuqs.spectrum.blocks.shooting_star.ShootingStarItem;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.Random;
import net.minecraft.class_10;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class ShootingStarBlock
extends class_2237 {
    public final Type shootingStarType;

    public ShootingStarBlock(class_4970.class_2251 settings, Type shootingStarType) {
        super(settings);
        this.shootingStarType = shootingStarType;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ShootingStarBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 itemStack = super.method_9574(world, pos, state);
        world.method_35230(pos, SpectrumBlockEntityRegistry.SHOOTING_STAR).ifPresent(blockEntity -> blockEntity.method_38240(itemStack));
        return itemStack;
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236 && !player.method_7337()) {
            class_1799 itemStack = this.shootingStarType.getBlock().method_8389().method_7854();
            world.method_35230(pos, SpectrumBlockEntityRegistry.SHOOTING_STAR).ifPresent(blockEntity -> blockEntity.method_38240(itemStack));
            class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
        }
        super.method_9576(world, pos, state, player);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (!world.field_9236 && (blockEntity = world.method_8321(pos)) instanceof ShootingStarBlockEntity) {
            ShootingStarBlockEntity shootingStarBlockEntity = (ShootingStarBlockEntity)blockEntity;
            shootingStarBlockEntity.setRemainingHits(ShootingStarItem.getRemainingHits(itemStack));
        }
    }

    public static enum Type {
        GLISTERING("glistering"),
        FIERY("fiery"),
        COLORFUL("colorful"),
        PRISTINE("pristine"),
        GEMSTONE("gemstone");

        public static final class_2960 COMMON_LOOT_TABLE;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public class_2248 getBlock() {
            switch (this) {
                case PRISTINE: {
                    return SpectrumBlocks.PRISTINE_SHOOTING_STAR;
                }
                case GEMSTONE: {
                    return SpectrumBlocks.GEMSTONE_SHOOTING_STAR;
                }
                case FIERY: {
                    return SpectrumBlocks.FIERY_SHOOTING_STAR;
                }
                case COLORFUL: {
                    return SpectrumBlocks.COLORFUL_SHOOTING_STAR;
                }
            }
            return SpectrumBlocks.GLISTERING_SHOOTING_STAR;
        }

        public static Type getType(int type) {
            Type[] types = Type.values();
            if (type < 0 || type >= types.length) {
                type = 0;
            }
            return types[type];
        }

        public static Type getType(String name) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return types[0];
        }

        public static class_2960 getLootTableIdentifier(int index) {
            return Type.getLootTableIdentifier(Type.values()[index]);
        }

        public static class_2960 getLootTableIdentifier(Type type) {
            switch (type) {
                case FIERY: {
                    return new class_2960("spectrum", "entity/shooting_star/shooting_star_fiery");
                }
                case COLORFUL: {
                    return new class_2960("spectrum", "entity/shooting_star/shooting_star_colorful");
                }
                case GEMSTONE: {
                    return new class_2960("spectrum", "entity/shooting_star/shooting_star_gemstone");
                }
                case PRISTINE: {
                    return new class_2960("spectrum", "entity/shooting_star/shooting_star_pristine");
                }
            }
            return new class_2960("spectrum", "entity/shooting_star/shooting_star_glistering");
        }

        public class_1160 getRandomParticleColor(Random random) {
            switch (this) {
                case GLISTERING: {
                    int r = random.nextInt(5);
                    if (r == 0) {
                        return ColorHelper.getColor(class_1767.field_7947);
                    }
                    if (r == 1) {
                        return ColorHelper.getColor(class_1767.field_7952);
                    }
                    if (r == 2) {
                        return ColorHelper.getColor(class_1767.field_7946);
                    }
                    if (r == 3) {
                        return ColorHelper.getColor(class_1767.field_7961);
                    }
                    return ColorHelper.getColor(class_1767.field_7966);
                }
                case COLORFUL: {
                    return ColorHelper.getColor(class_1767.values()[random.nextInt(class_1767.values().length)]);
                }
                case FIERY: {
                    int r = random.nextInt(2);
                    if (r == 0) {
                        return ColorHelper.getColor(class_1767.field_7946);
                    }
                    return ColorHelper.getColor(class_1767.field_7964);
                }
                case PRISTINE: {
                    int r = random.nextInt(3);
                    if (r == 0) {
                        return ColorHelper.getColor(class_1767.field_7966);
                    }
                    if (r == 1) {
                        return ColorHelper.getColor(class_1767.field_7951);
                    }
                    return ColorHelper.getColor(class_1767.field_7955);
                }
            }
            int r = random.nextInt(4);
            if (r == 0) {
                return ColorHelper.getColor(class_1767.field_7955);
            }
            if (r == 1) {
                return ColorHelper.getColor(class_1767.field_7958);
            }
            if (r == 2) {
                return ColorHelper.getColor(class_1767.field_7952);
            }
            return ColorHelper.getColor(class_1767.field_7947);
        }

        static {
            COMMON_LOOT_TABLE = new class_2960("spectrum", "entity/shooting_star/shooting_star_common");
        }
    }
}

