/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pedestal;

import de.dafuqs.spectrum.InventoryHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlock;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.enums.GemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.inventories.AutoCraftingInventory;
import de.dafuqs.spectrum.inventories.PedestalScreenHandler;
import de.dafuqs.spectrum.items.CraftingTabletItem;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import de.dafuqs.spectrum.sound.SpectrumSoundEvents;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2614;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3913;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IMultiblock;

public class PedestalBlockEntity
extends class_2624
implements class_1737,
class_1278,
PlayerOwned,
ExtendedScreenHandlerFactory,
Upgradeable {
    protected UUID ownerUUID;
    protected PedestalBlock.PedestalVariant pedestalVariant;
    protected class_2371<class_1799> inventory;
    protected boolean wasPoweredBefore;
    protected float storedXP;
    protected int craftingTime;
    protected int craftingTimeTotal;
    protected final class_3913 propertyDelegate;
    protected class_1860 currentRecipe;
    protected static AutoCraftingInventory autoCraftingInventory;
    protected PedestalRecipeTier cachedMaxPedestalTier;
    protected long cachedMaxPedestalTierTick;
    protected Map<Upgradeable.UpgradeType, Double> upgrades;
    protected boolean inventoryChanged;
    public static final int INVENTORY_SIZE = 16;
    public static final int CRAFTING_TABLET_SLOT_ID = 14;
    public static final int OUTPUT_SLOT_ID = 15;

    public PedestalBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntityRegistry.PEDESTAL, blockPos, blockState);
        this.pedestalVariant = blockState.method_26204() instanceof PedestalBlock ? ((PedestalBlock)blockState.method_26204()).getVariant() : PedestalBlock.PedestalVariant.BASIC_AMETHYST;
        if (autoCraftingInventory == null) {
            autoCraftingInventory = new AutoCraftingInventory(3, 3);
        }
        this.inventory = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> PedestalBlockEntity.this.craftingTime;
                    default -> PedestalBlockEntity.this.craftingTimeTotal;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        PedestalBlockEntity.this.craftingTime = value;
                        break;
                    }
                    case 1: {
                        PedestalBlockEntity.this.craftingTimeTotal = value;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    public void setVariant(@NotNull PedestalBlock.PedestalVariant pedestalVariant) {
        this.pedestalVariant = pedestalVariant;
        this.propertyDelegate.method_17391(2, pedestalVariant.ordinal());
    }

    public class_2561 method_17823() {
        return new class_2588("block.spectrum.pedestal");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new PedestalScreenHandler(syncId, playerInventory, (class_1263)this, this.propertyDelegate, this.pedestalVariant.ordinal(), this.getHighestAvailableRecipeTierWithStructure().ordinal(), this.field_11867);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        class_1799 itemStack;
        Iterator var1 = this.inventory.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (class_1799)var1.next()).method_7960());
        return false;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 removedStack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        this.inventoryChanged = true;
        this.method_5431();
        return removedStack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 removedStack = class_1262.method_5428(this.inventory, (int)slot);
        this.inventoryChanged = true;
        this.method_5431();
        return removedStack;
    }

    public void method_5447(int slot, @NotNull class_1799 stack) {
        class_1799 itemStack = (class_1799)this.inventory.get(slot);
        boolean isSimilarItem = !stack.method_7960() && stack.method_7962(itemStack) && class_1799.method_7975((class_1799)stack, (class_1799)itemStack);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (slot < 14 && !isSimilarItem) {
            this.craftingTimeTotal = PedestalBlockEntity.getCraftingTime(this.field_11863, SpectrumRecipeTypes.PEDESTAL, (class_1263)this);
            this.method_5431();
        }
        this.inventoryChanged = true;
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_7683(class_1662 recipeMatcher) {
        for (class_1799 itemStack : this.inventory) {
            recipeMatcher.method_7400(itemStack);
        }
    }

    public static void updateInClientWorld(PedestalBlockEntity pedestalBlockEntity) {
        ((class_3218)pedestalBlockEntity.field_11863).method_14178().method_14128(pedestalBlockEntity.field_11867);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound);
        return nbtCompound;
    }

    public void method_11014(class_2487 nbt) {
        Optional optionalRecipe;
        String recipeString;
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        if (nbt.method_10545("StoredXP")) {
            this.storedXP = nbt.method_10583("StoredXP");
        }
        if (nbt.method_10545("CraftingTime")) {
            this.craftingTime = nbt.method_10568("CraftingTime");
        }
        if (nbt.method_10545("CraftingTimeTotal")) {
            this.craftingTimeTotal = nbt.method_10568("CraftingTimeTotal");
        }
        if (nbt.method_10573("Upgrades", 9)) {
            this.upgrades = Upgradeable.fromNbt(nbt.method_10554("Upgrades", 10));
        }
        if (nbt.method_10545("inventory_changed")) {
            this.inventoryChanged = nbt.method_10577("inventory_changed");
        }
        this.currentRecipe = nbt.method_10545("CurrentRecipe") ? (!(recipeString = nbt.method_10558("CurrentRecipe")).isEmpty() && this.field_11863 != null ? ((optionalRecipe = this.field_11863.method_8433().method_8130(new class_2960(recipeString))).isPresent() ? (class_1860)optionalRecipe.get() : null) : null) : null;
        this.ownerUUID = nbt.method_10545("OwnerUUID") ? nbt.method_25926("OwnerUUID") : null;
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("StoredXP", this.storedXP);
        nbt.method_10575("CraftingTime", (short)this.craftingTime);
        nbt.method_10575("CraftingTimeTotal", (short)this.craftingTimeTotal);
        nbt.method_10556("inventory_changed", this.inventoryChanged);
        if (this.upgrades != null) {
            nbt.method_10566("Upgrades", (class_2520)Upgradeable.toNbt(this.upgrades));
        }
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.method_8114().toString());
        }
        if (this.ownerUUID != null) {
            nbt.method_25927("OwnerUUID", this.ownerUUID);
        }
        class_1262.method_5426((class_2487)nbt, this.inventory);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public boolean isCrafting() {
        return this.craftingTime > 0;
    }

    public static void clientTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, PedestalBlockEntity pedestalBlockEntity) {
        class_1860 currentRecipe = pedestalBlockEntity.getCurrentRecipe();
        if (currentRecipe instanceof PedestalCraftingRecipe) {
            PedestalCraftingRecipe pedestalCraftingRecipe = (PedestalCraftingRecipe)currentRecipe;
            HashMap<GemstoneColor, Integer> gemstonePowderInputs = pedestalCraftingRecipe.getGemstonePowderInputs();
            for (Map.Entry<GemstoneColor, Integer> entry : gemstonePowderInputs.entrySet()) {
                int amount = entry.getValue();
                if (amount <= 0) continue;
                class_2400 particleEffect = SpectrumParticleTypes.getCraftingParticle(entry.getKey().getDyeColor());
                float particleAmount = Support.getIntFromDecimalWithChance((double)amount / 8.0, world.field_9229);
                int i = 0;
                while ((float)i < particleAmount) {
                    float randomX = 2.0f - world.method_8409().nextFloat() * 5.0f;
                    float randomZ = 2.0f - world.method_8409().nextFloat() * 5.0f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                    ++i;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void serverTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, PedestalBlockEntity pedestalBlockEntity) {
        if (pedestalBlockEntity.upgrades == null) {
            pedestalBlockEntity.calculateUpgrades();
        }
        shouldMarkDirty = false;
        calculatedRecipe = PedestalBlockEntity.calculateRecipe(world, pedestalBlockEntity);
        pedestalBlockEntity.inventoryChanged = false;
        if (pedestalBlockEntity.currentRecipe != calculatedRecipe) {
            pedestalBlockEntity.currentRecipe = calculatedRecipe;
            pedestalBlockEntity.craftingTime = 0;
            if (calculatedRecipe instanceof PedestalCraftingRecipe) {
                calculatedPedestalCraftingRecipe = (PedestalCraftingRecipe)calculatedRecipe;
                pedestalBlockEntity.craftingTimeTotal = (int)Math.ceil((double)calculatedPedestalCraftingRecipe.getCraftingTime() / pedestalBlockEntity.upgrades.get((Object)Upgradeable.UpgradeType.SPEED));
            } else {
                pedestalBlockEntity.craftingTimeTotal = (int)Math.ceil((double)SpectrumCommon.CONFIG.VanillaRecipeCraftingTimeTicks / pedestalBlockEntity.upgrades.get((Object)Upgradeable.UpgradeType.SPEED));
            }
            pedestalBlockEntity.method_5431();
            SpectrumS2CPackets.sendCancelBlockBoundSoundInstance((class_3218)pedestalBlockEntity.method_10997(), pedestalBlockEntity.method_11016());
            PedestalBlockEntity.updateInClientWorld(pedestalBlockEntity);
        }
        if (!(pedestalBlockEntity.craftingTime != 0 || blockState.method_26204() instanceof PedestalBlock && ((Boolean)blockState.method_11654((class_2769)PedestalBlock.POWERED)).booleanValue())) {
            return;
        }
        maxCountPerStack = pedestalBlockEntity.method_5444();
        craftingFinished = false;
        if (!(calculatedRecipe instanceof PedestalCraftingRecipe)) ** GOTO lbl-1000
        pedestalCraftingRecipe = (PedestalCraftingRecipe)calculatedRecipe;
        if (PedestalBlockEntity.canAcceptRecipeOutput(calculatedRecipe, pedestalBlockEntity.inventory, maxCountPerStack)) {
            ++pedestalBlockEntity.craftingTime;
            if (pedestalBlockEntity.craftingTime == pedestalBlockEntity.craftingTimeTotal) {
                pedestalBlockEntity.craftingTime = 0;
                craftingFinished = PedestalBlockEntity.craftPedestalRecipe(pedestalBlockEntity, pedestalCraftingRecipe, pedestalBlockEntity.inventory, maxCountPerStack);
                if (craftingFinished) {
                    pedestalBlockEntity.inventoryChanged = true;
                }
                shouldMarkDirty = true;
            }
        } else if (calculatedRecipe instanceof class_3955) {
            vanillaCraftingRecipe = (class_3955)calculatedRecipe;
            if (PedestalBlockEntity.canAcceptRecipeOutput(calculatedRecipe, pedestalBlockEntity.inventory, maxCountPerStack)) {
                ++pedestalBlockEntity.craftingTime;
                if (pedestalBlockEntity.craftingTime == pedestalBlockEntity.craftingTimeTotal) {
                    pedestalBlockEntity.craftingTime = 0;
                    craftingFinished = pedestalBlockEntity.craftVanillaRecipe(vanillaCraftingRecipe, pedestalBlockEntity.inventory, maxCountPerStack);
                    if (craftingFinished) {
                        pedestalBlockEntity.inventoryChanged = true;
                    }
                    shouldMarkDirty = true;
                }
            }
        }
        if (!pedestalBlockEntity.wasPoweredBefore && pedestalBlockEntity.craftingTime > 0 || pedestalBlockEntity.craftingTime == 1 && pedestalBlockEntity.craftingTimeTotal > 1) {
            SpectrumS2CPackets.sendPlayBlockBoundSoundInstance(SpectrumSoundEvents.PEDESTAL_CRAFTING, (class_3218)pedestalBlockEntity.field_11863, pedestalBlockEntity.method_11016(), pedestalBlockEntity.craftingTimeTotal - pedestalBlockEntity.craftingTime);
        }
        if ((outputItemStack = (class_1799)pedestalBlockEntity.inventory.get(15)) != class_1799.field_8037) {
            if (world.method_8320(blockPos.method_10084()).method_26215()) {
                PedestalBlockEntity.spawnOutputAsItemEntity(world, blockPos, pedestalBlockEntity, outputItemStack);
                PedestalBlockEntity.playCraftingFinishedSoundEvent(pedestalBlockEntity, calculatedRecipe);
            } else {
                aboveBlockEntity = world.method_8321(blockPos.method_10084());
                if (aboveBlockEntity instanceof class_1263) {
                    aboveInventory = (class_1263)aboveBlockEntity;
                    putIntoAboveInventorySuccess = PedestalBlockEntity.tryPutOutputIntoAboveInventory(pedestalBlockEntity, aboveInventory, outputItemStack);
                    if (putIntoAboveInventorySuccess) {
                        PedestalBlockEntity.playCraftingFinishedSoundEvent(pedestalBlockEntity, calculatedRecipe);
                    } else if (craftingFinished) {
                        pedestalBlockEntity.playSound(class_3417.field_19198);
                    }
                } else if (craftingFinished) {
                    pedestalBlockEntity.playSound(class_3417.field_19198);
                }
            }
        }
        if (shouldMarkDirty) {
            PedestalBlockEntity.method_31663((class_1937)world, (class_2338)blockPos, (class_2680)blockState);
        }
        pedestalBlockEntity.wasPoweredBefore = true;
    }

    @Contract(pure=true)
    public static PedestalBlock.PedestalVariant getVariant(@NotNull PedestalBlockEntity pedestalBlockEntity) {
        return pedestalBlockEntity.pedestalVariant;
    }

    public static void spawnOutputAsItemEntity(class_1937 world, class_2338 blockPos, @NotNull PedestalBlockEntity pedestalBlockEntity, class_1799 outputItemStack) {
        class_1542 itemEntity = new class_1542(world, (double)pedestalBlockEntity.field_11867.method_10263() + 0.5, (double)(pedestalBlockEntity.field_11867.method_10264() + 1), (double)pedestalBlockEntity.field_11867.method_10260() + 0.5, outputItemStack);
        itemEntity.method_5762(0.0, 0.1, 0.0);
        world.method_8649((class_1297)itemEntity);
        pedestalBlockEntity.inventory.set(15, (Object)class_1799.field_8037);
        if (pedestalBlockEntity.storedXP > 0.0f) {
            int spawnedXPAmount = Support.getIntFromDecimalWithChance(pedestalBlockEntity.storedXP, pedestalBlockEntity.method_10997().field_9229);
            if (spawnedXPAmount > 0) {
                class_1303 experienceOrbEntity = new class_1303(world, (double)pedestalBlockEntity.field_11867.method_10263() + 0.5, (double)(pedestalBlockEntity.field_11867.method_10264() + 1), (double)pedestalBlockEntity.field_11867.method_10260() + 0.5, spawnedXPAmount);
                world.method_8649((class_1297)experienceOrbEntity);
            }
            pedestalBlockEntity.storedXP = 0.0f;
        }
        SpectrumS2CPackets.sendPlayPedestalCraftingFinishedParticle(world, blockPos, outputItemStack);
    }

    public static boolean tryPutOutputIntoAboveInventory(PedestalBlockEntity pedestalBlockEntity, class_1263 targetInventory, class_1799 outputItemStack) {
        if (targetInventory instanceof class_2614) {
            return false;
        }
        class_1799 remainingStack = InventoryHelper.smartAddToInventory(outputItemStack, targetInventory, class_2350.field_11033);
        if (remainingStack.method_7960()) {
            pedestalBlockEntity.inventory.set(15, (Object)class_1799.field_8037);
            return true;
        }
        pedestalBlockEntity.inventory.set(15, (Object)remainingStack);
        return false;
    }

    public static void playCraftingFinishedSoundEvent(PedestalBlockEntity pedestalBlockEntity, class_1860 craftingRecipe) {
        if (craftingRecipe instanceof PedestalCraftingRecipe) {
            PedestalCraftingRecipe pedestalCraftingRecipe = (PedestalCraftingRecipe)craftingRecipe;
            pedestalBlockEntity.playSound(pedestalCraftingRecipe.getSoundEvent(pedestalBlockEntity.field_11863.field_9229));
        } else {
            pedestalBlockEntity.playSound(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_GENERIC);
        }
    }

    @Nullable
    public static class_1860 calculateRecipe(class_1937 world, @NotNull PedestalBlockEntity pedestalBlockEntity) {
        PedestalBlock.PedestalVariant newPedestalVariant;
        if (!pedestalBlockEntity.inventoryChanged) {
            return pedestalBlockEntity.currentRecipe;
        }
        if (pedestalBlockEntity.currentRecipe instanceof PedestalCraftingRecipe && ((PedestalCraftingRecipe)pedestalBlockEntity.currentRecipe).method_8115((class_1263)pedestalBlockEntity, world)) {
            return pedestalBlockEntity.currentRecipe;
        }
        autoCraftingInventory.setInputInventory(pedestalBlockEntity.inventory.subList(0, 9));
        if (pedestalBlockEntity.currentRecipe instanceof class_3955 && ((class_3955)pedestalBlockEntity.currentRecipe).method_8115((class_1263)autoCraftingInventory, world)) {
            return pedestalBlockEntity.currentRecipe;
        }
        PedestalCraftingRecipe pedestalCraftingRecipe = world.method_8433().method_8132(SpectrumRecipeTypes.PEDESTAL, (class_1263)pedestalBlockEntity, world).orElse(null);
        Object newRecipe = pedestalCraftingRecipe != null ? ((newPedestalVariant = PedestalCraftingRecipe.getUpgradedPedestalVariantForOutput(pedestalCraftingRecipe.method_8110())) != null && newPedestalVariant.ordinal() <= PedestalBlockEntity.getVariant(pedestalBlockEntity).ordinal() ? null : (pedestalCraftingRecipe.canCraft(pedestalBlockEntity) ? pedestalCraftingRecipe : null)) : (class_1860)world.method_8433().method_8132(class_3956.field_17545, (class_1263)autoCraftingInventory, world).orElse(null);
        return newRecipe;
    }

    private void playSound(class_3414 soundEvent) {
        Random random = this.field_11863.field_9229;
        this.field_11863.method_8465(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), soundEvent, class_3419.field_15245, 0.9f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f);
    }

    private static int getCraftingTime(class_1937 world, class_3956<? extends PedestalCraftingRecipe> recipeType, class_1263 inventory) {
        return world.method_8433().method_8132(recipeType, inventory, world).map(PedestalCraftingRecipe::getCraftingTime).orElse(20);
    }

    private static boolean canAcceptRecipeOutput(@Nullable class_1860<?> recipe, class_2371<class_1799> defaultedList, int maxCountPerStack) {
        if (recipe != null) {
            class_1799 output = recipe.method_8110();
            if (output.method_7960()) {
                return false;
            }
            class_1799 existingOutput = (class_1799)defaultedList.get(15);
            if (existingOutput.method_7960()) {
                return true;
            }
            if (!existingOutput.method_7962(output)) {
                return false;
            }
            if (existingOutput.method_7947() < maxCountPerStack && existingOutput.method_7947() < existingOutput.method_7914()) {
                return true;
            }
            return existingOutput.method_7947() < output.method_7914();
        }
        return false;
    }

    private static boolean craftPedestalRecipe(PedestalBlockEntity pedestalBlockEntity, @Nullable PedestalCraftingRecipe recipe, class_2371<class_1799> inventory, int maxCountPerStack) {
        if (PedestalBlockEntity.canAcceptRecipeOutput(recipe, inventory, maxCountPerStack)) {
            for (int i = 0; i < 9; ++i) {
                class_1799 itemStack = (class_1799)inventory.get(i);
                if (itemStack.method_7960()) continue;
                class_1792 recipeReminderItem = itemStack.method_7909().method_7858();
                if (recipeReminderItem == null) {
                    itemStack.method_7934(1);
                    continue;
                }
                if (((class_1799)inventory.get(i)).method_7947() == 1) {
                    inventory.set(i, (Object)new class_1799((class_1935)recipeReminderItem, 1));
                    continue;
                }
                ((class_1799)inventory.get(i)).method_7934(1);
                class_1799 remainderStack = recipeReminderItem.method_7854();
                class_1542 itemEntity = new class_1542(pedestalBlockEntity.field_11863, (double)pedestalBlockEntity.field_11867.method_10263() + 0.5, (double)(pedestalBlockEntity.field_11867.method_10264() + 1), (double)pedestalBlockEntity.field_11867.method_10260() + 0.5, remainderStack);
                itemEntity.method_5762(0.0, 0.05, 0.0);
                pedestalBlockEntity.field_11863.method_8649((class_1297)itemEntity);
            }
            for (GemstoneColor gemstoneColor : GemstoneColor.values()) {
                double efficiencyModifier = pedestalBlockEntity.upgrades.get((Object)Upgradeable.UpgradeType.EFFICIENCY);
                int gemstonePowderAmount = recipe.getGemstonePowderAmount(gemstoneColor);
                int gemstonePowderAmountAfterMod = Support.getIntFromDecimalWithChance((double)gemstonePowderAmount / efficiencyModifier, pedestalBlockEntity.field_11863.field_9229);
                ((class_1799)pedestalBlockEntity.inventory.get(PedestalBlockEntity.getSlotForGemstonePowder(gemstoneColor))).method_7934(gemstonePowderAmountAfterMod);
            }
            class_1799 recipeOutput = recipe.method_8110();
            PedestalBlock.PedestalVariant newPedestalVariant = PedestalCraftingRecipe.getUpgradedPedestalVariantForOutput(recipeOutput);
            if (newPedestalVariant != null && newPedestalVariant.ordinal() > PedestalBlockEntity.getVariant(pedestalBlockEntity).ordinal()) {
                pedestalBlockEntity.playSound(SpectrumSoundEvents.PEDESTAL_UPGRADE);
                PedestalBlock.upgradeToVariant(pedestalBlockEntity.field_11863, pedestalBlockEntity.method_11016(), newPedestalVariant);
                SpectrumS2CPackets.spawnPedestalUpgradeParticles(pedestalBlockEntity.field_11863, pedestalBlockEntity.field_11867, newPedestalVariant);
                pedestalBlockEntity.pedestalVariant = newPedestalVariant;
                PedestalBlockEntity.updateInClientWorld(pedestalBlockEntity);
                pedestalBlockEntity.method_5431();
            } else {
                int resultAmountBeforeMod = recipeOutput.method_7947();
                double yieldModifier = recipe.areYieldUpgradesDisabled() ? 1.0 : pedestalBlockEntity.upgrades.get((Object)Upgradeable.UpgradeType.YIELD);
                int resultAmountAfterMod = Support.getIntFromDecimalWithChance((double)resultAmountBeforeMod * yieldModifier, pedestalBlockEntity.field_11863.field_9229);
                class_1799 existingOutput = (class_1799)inventory.get(15);
                if (existingOutput.method_7960()) {
                    class_1799 resultStack = recipeOutput.method_7972();
                    resultStack.method_7939(Math.min(existingOutput.method_7914(), resultAmountAfterMod));
                    inventory.set(15, (Object)resultStack);
                } else {
                    int finalAmount = Math.min(existingOutput.method_7914(), existingOutput.method_7947() + resultAmountAfterMod);
                    existingOutput.method_7939(finalAmount);
                    inventory.set(15, (Object)existingOutput);
                }
            }
            double experienceModifier = pedestalBlockEntity.upgrades.get((Object)Upgradeable.UpgradeType.EXPERIENCE);
            float recipeExperienceBeforeMod = recipe.getExperience();
            float experienceAfterMod = (float)((double)recipeExperienceBeforeMod * experienceModifier);
            pedestalBlockEntity.storedXP += experienceAfterMod;
            pedestalBlockEntity.grantPlayerCraftingAdvancement(recipe, (int)experienceAfterMod);
            return true;
        }
        return false;
    }

    private boolean craftVanillaRecipe(@Nullable class_3955 recipe, class_2371<class_1799> defaultedList, int maxCountPerStack) {
        if (PedestalBlockEntity.canAcceptRecipeOutput(recipe, defaultedList, maxCountPerStack)) {
            for (int i = 0; i < 9; ++i) {
                class_1799 itemStack = (class_1799)defaultedList.get(i);
                if (itemStack.method_7960()) continue;
                class_1792 recipeReminderItem = itemStack.method_7909().method_7858();
                if (recipeReminderItem == null) {
                    itemStack.method_7934(1);
                    continue;
                }
                if (((class_1799)this.inventory.get(i)).method_7947() == 1) {
                    this.inventory.set(i, (Object)new class_1799((class_1935)recipeReminderItem, 1));
                    continue;
                }
                ((class_1799)this.inventory.get(i)).method_7934(1);
                class_1799 remainderStack = recipeReminderItem.method_7854();
                class_1542 itemEntity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5, remainderStack);
                itemEntity.method_5762(0.0, 0.05, 0.0);
                this.field_11863.method_8649((class_1297)itemEntity);
            }
            class_1799 recipeOutput = recipe.method_8110();
            class_1799 existingOutput = (class_1799)defaultedList.get(15);
            if (existingOutput.method_7960()) {
                defaultedList.set(15, (Object)recipeOutput.method_7972());
            } else {
                existingOutput.method_7933(recipeOutput.method_7947());
                defaultedList.set(15, (Object)existingOutput);
            }
            return true;
        }
        return false;
    }

    private void grantPlayerCraftingAdvancement(PedestalCraftingRecipe recipe, int experience) {
        class_3222 serverPlayerEntity = (class_3222)PlayerOwned.getPlayerEntityIfOnline(this.field_11863, this.ownerUUID);
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.PEDESTAL_CRAFTING.trigger(serverPlayerEntity, recipe.method_8110(), experience);
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot < 9) {
            return true;
        }
        if (slot == 14 && stack.method_31574(SpectrumItems.CRAFTING_TABLET)) {
            return true;
        }
        return stack.method_7909().equals(PedestalBlockEntity.getGemstonePowderItemForSlot(slot));
    }

    public static class_1792 getGemstonePowderItemForSlot(int slot) {
        return switch (slot) {
            case 9 -> SpectrumItems.TOPAZ_POWDER;
            case 10 -> SpectrumItems.AMETHYST_POWDER;
            case 11 -> SpectrumItems.CITRINE_POWDER;
            case 12 -> SpectrumItems.ONYX_POWDER;
            case 13 -> SpectrumItems.MOONSTONE_POWDER;
            default -> class_1802.field_8162;
        };
    }

    public static int getSlotForGemstonePowder(GemstoneColor gemstoneColor) {
        return switch (gemstoneColor) {
            case GemstoneColor.CYAN -> 9;
            case GemstoneColor.MAGENTA -> 10;
            case GemstoneColor.YELLOW -> 11;
            case GemstoneColor.BLACK -> 12;
            default -> 13;
        };
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[]{15};
        }
        if (side == class_2350.field_11036) {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        }
        switch (this.pedestalVariant) {
            case BASIC_AMETHYST: 
            case BASIC_CITRINE: 
            case BASIC_TOPAZ: 
            case CMY: {
                return new int[]{9, 10, 11};
            }
            case ONYX: {
                return new int[]{9, 10, 11, 12};
            }
        }
        return new int[]{9, 10, 11, 12, 13};
    }

    public boolean method_5492(int slot, @NotNull class_1799 stack, @Nullable class_2350 dir) {
        if (stack.method_31574(PedestalBlockEntity.getGemstonePowderItemForSlot(slot))) {
            return true;
        }
        if (slot < 9 && ((class_1799)this.inventory.get(14)).method_31574(SpectrumItems.CRAFTING_TABLET)) {
            class_1799 craftingTabletItem = (class_1799)this.inventory.get(14);
            if (((class_1799)this.inventory.get(slot)).method_7947() > 0) {
                return false;
            }
            class_1860 storedRecipe = CraftingTabletItem.getStoredRecipe(this.field_11863, craftingTabletItem);
            int width = 3;
            if (storedRecipe instanceof class_1869) {
                class_1869 shapedRecipe = (class_1869)storedRecipe;
                width = shapedRecipe.method_8150();
                if (slot % 3 >= width) {
                    return false;
                }
            } else if (storedRecipe instanceof PedestalCraftingRecipe) {
                PedestalCraftingRecipe pedestalCraftingRecipe = (PedestalCraftingRecipe)storedRecipe;
                width = pedestalCraftingRecipe.getWidth();
                if (slot % 3 >= width) {
                    return false;
                }
            } else if (!(storedRecipe instanceof class_1867)) {
                return false;
            }
            int resultRecipeSlot = this.getCraftingRecipeSlotDependingOnWidth(slot, width);
            if (resultRecipeSlot < storedRecipe.method_8117().size()) {
                class_1856 ingredient = (class_1856)storedRecipe.method_8117().get(resultRecipeSlot);
                return ingredient.method_8093(stack);
            }
            return false;
        }
        return slot < 14;
    }

    private int getCraftingRecipeSlotDependingOnWidth(int slot, int recipeWidth) {
        int line = slot / 3;
        int posInLine = slot % 3;
        return line * recipeWidth + posInLine;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 15;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public class_1860 getCurrentRecipe() {
        return this.currentRecipe;
    }

    public class_1799 getCurrentCraftingRecipeOutput() {
        if (this.currentRecipe == null) {
            return class_1799.field_8037;
        }
        return this.currentRecipe.method_8110();
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.writeInt(this.pedestalVariant.ordinal());
        buf.writeInt(this.getHighestAvailableRecipeTierWithStructure().ordinal());
        buf.method_10807(this.field_11867);
    }

    private PedestalRecipeTier getHighestAvailableRecipeTierForVariant() {
        return PedestalBlockEntity.getHighestAvailableRecipeTierForVariant(this.pedestalVariant);
    }

    @Contract(pure=true)
    public static PedestalRecipeTier getHighestAvailableRecipeTierForVariant(@NotNull PedestalBlock.PedestalVariant pedestalVariant) {
        switch (pedestalVariant) {
            case CMY: {
                return PedestalRecipeTier.SIMPLE;
            }
            case ONYX: {
                return PedestalRecipeTier.ADVANCED;
            }
            case MOONSTONE: {
                return PedestalRecipeTier.COMPLEX;
            }
        }
        return PedestalRecipeTier.BASIC;
    }

    public PedestalRecipeTier getHighestAvailableRecipeTierWithStructure() {
        IMultiblock multiblock;
        boolean valid;
        if (this.field_11863.method_8510() == this.cachedMaxPedestalTierTick) {
            return this.cachedMaxPedestalTier;
        }
        PedestalRecipeTier highestAvailableRecipeTierForVariant = this.getHighestAvailableRecipeTierForVariant();
        boolean found = false;
        PedestalRecipeTier highestAvailableRecipeTier = PedestalRecipeTier.BASIC;
        if (highestAvailableRecipeTierForVariant.ordinal() >= PedestalRecipeTier.COMPLEX.ordinal() && (valid = (multiblock = SpectrumMultiblocks.MULTIBLOCKS.get(SpectrumMultiblocks.PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_CHECK)).validate(this.field_11863, this.field_11867.method_10074(), class_2470.field_11467))) {
            highestAvailableRecipeTier = PedestalRecipeTier.COMPLEX;
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger((class_3222)this.getPlayerEntityIfOnline(this.field_11863), multiblock);
            found = true;
        }
        if (!found && highestAvailableRecipeTierForVariant.ordinal() >= PedestalRecipeTier.ADVANCED.ordinal() && (valid = (multiblock = SpectrumMultiblocks.MULTIBLOCKS.get(SpectrumMultiblocks.PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_CHECK)).validate(this.field_11863, this.field_11867.method_10074(), class_2470.field_11467))) {
            highestAvailableRecipeTier = PedestalRecipeTier.ADVANCED;
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger((class_3222)this.getPlayerEntityIfOnline(this.field_11863), multiblock);
            found = true;
        }
        if (!found && highestAvailableRecipeTierForVariant.ordinal() >= PedestalRecipeTier.SIMPLE.ordinal() && (valid = (multiblock = SpectrumMultiblocks.MULTIBLOCKS.get(SpectrumMultiblocks.PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_CHECK)).validate(this.field_11863, this.field_11867.method_10074(), class_2470.field_11467))) {
            highestAvailableRecipeTier = PedestalRecipeTier.SIMPLE;
            SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger((class_3222)this.getPlayerEntityIfOnline(this.field_11863), multiblock);
        }
        this.cachedMaxPedestalTier = highestAvailableRecipeTier;
        this.cachedMaxPedestalTierTick = this.field_11863.method_8510();
        return highestAvailableRecipeTier;
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void calculateUpgrades() {
        class_3222 owner;
        class_3545<Integer, Map<Upgradeable.UpgradeType, Double>> upgrades = Upgradeable.checkUpgradeMods(this.field_11863, this.field_11867, 3, 2);
        this.upgrades = (Map)upgrades.method_15441();
        this.method_5431();
        if ((Integer)upgrades.method_15442() == 4 && (owner = (class_3222)this.getPlayerEntityIfOnline(this.field_11863)) != null) {
            Support.grantAdvancementCriterion(owner, "midgame/use_all_pedestal_upgrades", "used_all");
        }
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
    }

    public void setInventoryChanged() {
        this.inventoryChanged = true;
    }
}

