/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pedestal;

import de.dafuqs.spectrum.blocks.RedstonePoweredBlock;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2968;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_638;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class PedestalBlock
extends class_2237
implements RedstonePoweredBlock {
    private final PedestalVariant variant;
    public static final class_2746 POWERED = class_2746.method_11825((String)"powered");

    public PedestalBlock(class_4970.class_2251 settings, PedestalVariant variant) {
        super(settings);
        this.variant = variant;
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (placer instanceof class_3222 && (blockEntity = world.method_8321(pos)) instanceof PedestalBlockEntity) {
            ((PedestalBlockEntity)blockEntity).setOwner((class_1657)((class_3222)placer));
            blockEntity.method_5431();
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{POWERED});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        this.openScreen(world, pos, player);
        return class_1269.field_21466;
    }

    protected void openScreen(class_1937 world, class_2338 pos, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)blockEntity;
            pedestalBlockEntity.setOwner(player);
            player.method_17355((class_3908)blockEntity);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (newState.method_26204() instanceof PedestalBlock) {
            class_2586 blockEntity;
            if (!state.method_26204().equals(newState.method_26204()) && (blockEntity = world.method_8321(pos)) instanceof PedestalBlockEntity && state.method_26204().equals(newState.method_26204())) {
                PedestalVariant newVariant = ((PedestalBlock)newState.method_26204()).getVariant();
                ((PedestalBlockEntity)blockEntity).setVariant(newVariant);
            }
        } else {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof PedestalBlockEntity) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((class_1263)blockEntity));
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public static void upgradeToVariant(@NotNull class_1937 world, class_2338 blockPos, PedestalVariant newPedestalVariant) {
        world.method_8501(blockPos, PedestalBlock.getPedestalBlockForVariant(newPedestalVariant).method_9605((class_1750)new class_2968(world, blockPos, class_2350.field_11033, null, class_2350.field_11036)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PedestalBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, @NotNull class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return PedestalBlock.method_31618(type, SpectrumBlockEntityRegistry.PEDESTAL, PedestalBlockEntity::clientTick);
        }
        return PedestalBlock.method_31618(type, SpectrumBlockEntityRegistry.PEDESTAL, PedestalBlockEntity::serverTick);
    }

    public void method_9612(class_2680 state, @NotNull class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (!world.field_9236) {
            if (this.checkGettingPowered(world, pos)) {
                this.power(world, pos);
            } else {
                this.unPower(world, pos);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(@NotNull class_2680 state, class_1937 world, class_2338 pos, Random random) {
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            class_1160 vec3f = new class_1160(0.5f, 0.5f, 0.5f);
            float xOffset = random.nextFloat();
            float zOffset = random.nextFloat();
            world.method_8406((class_2394)new class_2390(vec3f, 1.0f), (double)((float)pos.method_10263() + xOffset), (double)(pos.method_10264() + 1), (double)((float)pos.method_10260() + zOffset), 0.0, 0.0, 0.0);
        }
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            PedestalBlock.clearCurrentlyRenderedMultiBlock((class_1937)world);
        }
    }

    public static void clearCurrentlyRenderedMultiBlock(class_1937 world) {
        IMultiblock currentlyRenderedMultiBlock;
        if (world.field_9236 && (currentlyRenderedMultiBlock = PatchouliAPI.get().getCurrentMultiblock()) != null && (currentlyRenderedMultiBlock.getID().equals((Object)SpectrumMultiblocks.PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_CHECK) || currentlyRenderedMultiBlock.getID().equals((Object)SpectrumMultiblocks.PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_CHECK) || currentlyRenderedMultiBlock.getID().equals((Object)SpectrumMultiblocks.PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_CHECK))) {
            PatchouliAPI.get().clearMultiblock();
        }
    }

    public class_2680 method_9605(@NotNull class_1750 ctx) {
        class_2680 placementState = this.method_9564();
        if (ctx.method_8045().method_8482(ctx.method_8037()) > 0) {
            placementState = (class_2680)placementState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return placementState;
    }

    public PedestalVariant getVariant() {
        return this.variant;
    }

    @Contract(pure=true)
    public static class_2248 getPedestalBlockForVariant(@NotNull PedestalVariant variant) {
        switch (variant) {
            case BASIC_TOPAZ: {
                return SpectrumBlocks.PEDESTAL_BASIC_TOPAZ;
            }
            case BASIC_AMETHYST: {
                return SpectrumBlocks.PEDESTAL_BASIC_AMETHYST;
            }
            case BASIC_CITRINE: {
                return SpectrumBlocks.PEDESTAL_BASIC_CITRINE;
            }
            case CMY: {
                return SpectrumBlocks.PEDESTAL_ALL_BASIC;
            }
            case ONYX: {
                return SpectrumBlocks.PEDESTAL_ONYX;
            }
        }
        return SpectrumBlocks.PEDESTAL_MOONSTONE;
    }

    @Environment(value=EnvType.CLIENT)
    public static void spawnUpgradeParticleEffectsForTier(class_2338 blockPos, @NotNull PedestalVariant newPedestalVariant) {
        class_638 world = class_310.method_1551().field_1687;
        Random random = world.method_8409();
        switch (newPedestalVariant) {
            case MOONSTONE: {
                float randomX;
                float randomZ;
                int i;
                class_2400 particleEffect = SpectrumParticleTypes.getCraftingParticle(class_1767.field_7952);
                for (i = 0; i < 25; ++i) {
                    randomZ = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() + 1.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomZ = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() - 0.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() + 1.1, 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() - 0.1, 0.0, 0.03, 0.0);
                }
                break;
            }
            case ONYX: {
                float randomX;
                float randomZ;
                int i;
                class_2400 particleEffect = SpectrumParticleTypes.getCraftingParticle(class_1767.field_7963);
                for (i = 0; i < 25; ++i) {
                    randomZ = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() + 1.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomZ = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)blockPos.method_10263() - 0.1, (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() + 1.1, 0.0, 0.03, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)blockPos.method_10260() - 0.1, 0.0, 0.03, 0.0);
                }
                break;
            }
            case CMY: {
                float randomX;
                float randomZ;
                int i;
                class_2400 particleEffectC = SpectrumParticleTypes.getCraftingParticle(class_1767.field_7955);
                class_2400 particleEffectM = SpectrumParticleTypes.getCraftingParticle(class_1767.field_7958);
                class_2400 particleEffectY = SpectrumParticleTypes.getCraftingParticle(class_1767.field_7947);
                for (i = 0; i < 25; ++i) {
                    randomZ = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffectY, (double)blockPos.method_10263() + 1.1, (double)blockPos.method_10264() + 0.1, (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.05, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomZ = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffectC, (double)blockPos.method_10263() - 0.1, (double)blockPos.method_10264() + 0.1, (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.05, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffectM, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 0.1, (double)blockPos.method_10260() + 1.1, 0.0, 0.05, 0.0);
                }
                for (i = 0; i < 25; ++i) {
                    randomX = random.nextFloat() * 1.2f;
                    world.method_8406((class_2394)particleEffectM, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 0.1, (double)blockPos.method_10260() - 0.1, 0.0, 0.05, 0.0);
                }
                break;
            }
        }
    }

    public static enum PedestalVariant {
        BASIC_TOPAZ,
        BASIC_AMETHYST,
        BASIC_CITRINE,
        CMY,
        ONYX,
        MOONSTONE;

    }
}

