/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.particle_spawner;

import de.dafuqs.spectrum.blocks.particle_spawner.ParticleSpawnerBlock;
import de.dafuqs.spectrum.inventories.ParticleSpawnerScreenHandler;
import de.dafuqs.spectrum.particle.effect.ParticleSpawnerParticleEffect;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import java.util.ArrayList;
import java.util.Random;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1160;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleSpawnerBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory {
    public class_2960 particleSpriteIdentifier;
    public float particlesPerSecond;
    public class_1160 particleSourcePosition;
    public class_1160 particleSourcePositionVariance;
    public class_1160 velocity;
    public class_1160 velocityVariance;
    public class_1160 color;
    public float scale;
    public float scaleVariance;
    public int lifetimeTicks;
    public int lifetimeVariance;
    public float gravity;
    public boolean collisions;
    public boolean initialized = false;

    public ParticleSpawnerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntityRegistry.PARTICLE_SPAWNER, blockPos, blockState);
        ArrayList<class_2400> availableParticleEffects = new ArrayList<class_2400>();
        availableParticleEffects.add(class_2398.field_11240);
        availableParticleEffects.add(class_2398.field_11247);
        this.particleSpriteIdentifier = new class_2960("spectrum", "particle/shooting_star");
        this.particlesPerSecond = 10.0f;
        this.particleSourcePosition = new class_1160(0.0f, 1.0f, 0.0f);
        this.particleSourcePositionVariance = new class_1160(0.5f, 0.0f, 0.5f);
        this.velocity = new class_1160(0.0f, 0.1f, 0.0f);
        this.velocityVariance = new class_1160(0.0f, 0.1f, 0.0f);
        this.color = new class_1160(1.0f, 1.0f, 1.0f);
        this.scale = 1.0f;
        this.scaleVariance = 0.2f;
        this.lifetimeTicks = 20;
        this.lifetimeVariance = 10;
        this.gravity = 0.02f;
        this.collisions = true;
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, ParticleSpawnerBlockEntity blockEntity) {
        class_2680 blockState = world.method_8320(pos);
        if (blockState.method_26204() instanceof ParticleSpawnerBlock && ((Boolean)world.method_8320(pos).method_11654((class_2769)ParticleSpawnerBlock.POWERED)).equals(true)) {
            blockEntity.spawnParticles();
        }
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound);
        return nbtCompound;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void updateInClientWorld() {
        this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 4);
    }

    private void spawnParticles() {
        for (float particlesToSpawn = this.particlesPerSecond / 20.0f; particlesToSpawn > 1.0f || this.field_11863.field_9229.nextFloat() < particlesToSpawn; particlesToSpawn -= 1.0f) {
            this.spawnParticle(this.field_11867, this.field_11863.field_9229);
        }
    }

    private void spawnParticle(@NotNull class_2338 pos, Random random) {
        int randomLifetime;
        double randomOffsetX = this.particleSourcePositionVariance.method_4943() == 0.0f ? 0.0 : (double)this.particleSourcePositionVariance.method_4943() - random.nextDouble() * (double)this.particleSourcePositionVariance.method_4943() * 2.0;
        double randomOffsetY = this.particleSourcePositionVariance.method_4945() == 0.0f ? 0.0 : (double)this.particleSourcePositionVariance.method_4945() - random.nextDouble() * (double)this.particleSourcePositionVariance.method_4945() * 2.0;
        double randomOffsetZ = this.particleSourcePositionVariance.method_4947() == 0.0f ? 0.0 : (double)this.particleSourcePositionVariance.method_4947() - random.nextDouble() * (double)this.particleSourcePositionVariance.method_4947() * 2.0;
        double randomVelocityX = this.velocityVariance.method_4943() == 0.0f ? 0.0 : (double)this.velocityVariance.method_4943() - random.nextDouble() * (double)this.velocityVariance.method_4943() * 2.0;
        double randomVelocityY = this.velocityVariance.method_4945() == 0.0f ? 0.0 : (double)this.velocityVariance.method_4945() - random.nextDouble() * (double)this.velocityVariance.method_4945() * 2.0;
        double randomVelocityZ = this.velocityVariance.method_4947() == 0.0f ? 0.0 : (double)this.velocityVariance.method_4947() - random.nextDouble() * (double)this.velocityVariance.method_4947() * 2.0;
        float randomScale = this.scaleVariance == 0.0f ? this.scale : (float)((double)(this.scale + this.scaleVariance) - random.nextDouble() * (double)this.scaleVariance * 2.0);
        int n = randomLifetime = this.lifetimeVariance == 0 ? this.lifetimeTicks : (int)((double)(this.lifetimeTicks + this.lifetimeVariance) - random.nextDouble() * (double)this.lifetimeVariance * 2.0);
        if (randomScale > 0.0f && randomLifetime > 0) {
            class_310.method_1551().field_1724.method_5770().method_8406((class_2394)new ParticleSpawnerParticleEffect(this.particleSpriteIdentifier, this.gravity, this.color, randomScale, randomLifetime, this.collisions, false), (double)pos.method_10263() + 0.5 + (double)this.particleSourcePosition.method_4943() + randomOffsetX, (double)pos.method_10264() + 0.5 + (double)this.particleSourcePosition.method_4945() + randomOffsetY, (double)pos.method_10260() + 0.5 + (double)this.particleSourcePosition.method_4947() + randomOffsetZ, (double)this.velocity.method_4943() + randomVelocityX, (double)this.velocity.method_4945() + randomVelocityY, (double)this.velocity.method_4947() + randomVelocityZ);
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10582("particle_identifier", this.particleSpriteIdentifier.toString());
        tag.method_10548("particles_per_tick", this.particlesPerSecond);
        tag.method_10548("source_pos_x", this.particleSourcePosition.method_4943());
        tag.method_10548("source_pos_y", this.particleSourcePosition.method_4945());
        tag.method_10548("source_pos_z", this.particleSourcePosition.method_4947());
        tag.method_10548("source_pos_variance_x", this.particleSourcePositionVariance.method_4943());
        tag.method_10548("source_pos_variance_y", this.particleSourcePositionVariance.method_4945());
        tag.method_10548("source_pos_variance_z", this.particleSourcePositionVariance.method_4947());
        tag.method_10548("source_velocity_x", this.velocity.method_4943());
        tag.method_10548("source_velocity_y", this.velocity.method_4945());
        tag.method_10548("source_velocity_z", this.velocity.method_4947());
        tag.method_10548("source_velocity_variance_x", this.velocityVariance.method_4943());
        tag.method_10548("source_velocity_variance_y", this.velocityVariance.method_4945());
        tag.method_10548("source_velocity_variance_z", this.velocityVariance.method_4947());
        tag.method_10548("particle_color_r", this.color.method_4943());
        tag.method_10548("particle_color_g", this.color.method_4945());
        tag.method_10548("particle_color_b", this.color.method_4947());
        tag.method_10548("particle_scale", this.scale);
        tag.method_10548("particle_scale_variance", this.scaleVariance);
        tag.method_10569("particle_lifetime", this.lifetimeTicks);
        tag.method_10569("particle_lifetime_variance", this.lifetimeVariance);
        tag.method_10548("particle_gravity", this.gravity);
        tag.method_10556("particle_collisions", this.collisions);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10558("particle_identifier").isEmpty()) {
            this.initialized = false;
        } else {
            this.particleSpriteIdentifier = new class_2960(tag.method_10558("particle_identifier"));
            this.particlesPerSecond = tag.method_10583("particles_per_tick");
            this.particleSourcePosition = new class_1160(tag.method_10583("source_pos_x"), tag.method_10583("source_pos_y"), tag.method_10583("source_pos_z"));
            this.particleSourcePositionVariance = new class_1160(tag.method_10583("source_pos_variance_x"), tag.method_10583("source_pos_variance_y"), tag.method_10583("source_pos_variance_z"));
            this.velocity = new class_1160(tag.method_10583("source_velocity_x"), tag.method_10583("source_velocity_y"), tag.method_10583("source_velocity_z"));
            this.velocityVariance = new class_1160(tag.method_10583("source_velocity_variance_x"), tag.method_10583("source_velocity_variance_y"), tag.method_10583("source_velocity_variance_z"));
            this.color = new class_1160(tag.method_10583("particle_color_r"), tag.method_10583("particle_color_g"), tag.method_10583("particle_color_b"));
            this.scale = tag.method_10583("particle_scale");
            this.scaleVariance = tag.method_10583("particle_scale_variance");
            this.lifetimeTicks = tag.method_10550("particle_lifetime");
            this.lifetimeVariance = tag.method_10550("particle_lifetime_variance");
            this.gravity = tag.method_10583("particle_gravity");
            this.collisions = tag.method_10577("particle_collisions");
            this.initialized = true;
        }
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new ParticleSpawnerScreenHandler(syncId, inv, this);
    }

    public class_2561 method_5476() {
        return new class_2588("block.spectrum.particle_spawner");
    }

    public void writeSettings(@NotNull class_2540 packetByteBuf) {
        packetByteBuf.method_10814(this.particleSpriteIdentifier.toString());
        packetByteBuf.writeFloat(this.particlesPerSecond);
        packetByteBuf.writeFloat(this.particleSourcePosition.method_4943());
        packetByteBuf.writeFloat(this.particleSourcePosition.method_4945());
        packetByteBuf.writeFloat(this.particleSourcePosition.method_4947());
        packetByteBuf.writeFloat(this.particleSourcePositionVariance.method_4943());
        packetByteBuf.writeFloat(this.particleSourcePositionVariance.method_4945());
        packetByteBuf.writeFloat(this.particleSourcePositionVariance.method_4947());
        packetByteBuf.writeFloat(this.velocity.method_4943());
        packetByteBuf.writeFloat(this.velocity.method_4945());
        packetByteBuf.writeFloat(this.velocity.method_4947());
        packetByteBuf.writeFloat(this.velocityVariance.method_4943());
        packetByteBuf.writeFloat(this.velocityVariance.method_4945());
        packetByteBuf.writeFloat(this.velocityVariance.method_4947());
        packetByteBuf.writeFloat(this.scale);
        packetByteBuf.writeFloat(this.scaleVariance);
        packetByteBuf.writeInt(this.lifetimeTicks);
        packetByteBuf.writeInt(this.lifetimeVariance);
        packetByteBuf.writeFloat(this.gravity);
        packetByteBuf.writeBoolean(this.collisions);
    }

    public void applySettings(class_2540 buf) {
        class_2960 particleSpriteIdentifier = new class_2960(buf.method_19772());
        float particlesPerSecond = buf.readFloat();
        class_1160 particleSourcePosition = new class_1160(buf.readFloat(), buf.readFloat(), buf.readFloat());
        class_1160 particleSourcePositionVariance = new class_1160(buf.readFloat(), buf.readFloat(), buf.readFloat());
        class_1160 velocity = new class_1160(buf.readFloat(), buf.readFloat(), buf.readFloat());
        class_1160 velocityVariance = new class_1160(buf.readFloat(), buf.readFloat(), buf.readFloat());
        class_1160 color = new class_1160(1.0f, 1.0f, 1.0f);
        float scale = buf.readFloat();
        float scaleVariance = buf.readFloat();
        int lifetimeTicks = buf.readInt();
        int lifetimeVariance = buf.readInt();
        float gravity = buf.readFloat();
        boolean collisions = buf.readBoolean();
        this.applySettings(particleSpriteIdentifier, particlesPerSecond, particleSourcePosition, particleSourcePositionVariance, velocity, velocityVariance, color, scale, scaleVariance, lifetimeTicks, lifetimeVariance, gravity, collisions);
    }

    public void applySettings(class_2960 particleSpriteIdentifier, float particlesPerSecond, class_1160 ParticleSourcePosition, class_1160 particleSourcePositionVariance, class_1160 velocity, class_1160 velocityVariance, class_1160 color, float scale, float scaleVariance, int lifetimeTicks, int lifetimeVariance, float gravity, boolean collisions) {
        this.particleSpriteIdentifier = particleSpriteIdentifier;
        this.particlesPerSecond = particlesPerSecond;
        this.particleSourcePosition = ParticleSourcePosition;
        this.particleSourcePositionVariance = particleSourcePositionVariance;
        this.velocity = velocity;
        this.velocityVariance = velocityVariance;
        this.color = color;
        this.scale = scale;
        this.scaleVariance = scaleVariance;
        this.lifetimeTicks = lifetimeTicks;
        this.lifetimeVariance = lifetimeVariance;
        this.gravity = gravity;
        this.collisions = collisions;
        this.initialized = true;
        this.updateInClientWorld();
        this.method_5431();
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }
}

