/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.item_bowl;

import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.effect.Transphere;
import de.dafuqs.spectrum.particle.effect.TransphereParticleEffect;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import de.dafuqs.spectrum.registries.color.ColorRegistry;
import de.dafuqs.spectrum.sound.SpectrumSoundEvents;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5707;
import net.minecraft.class_5716;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBowlBlockEntity
extends class_2586 {
    protected int INVENTORY_SIZE = 1;
    protected class_1277 inventory = new class_1277(this.INVENTORY_SIZE);

    public ItemBowlBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntityRegistry.ITEM_BOWL, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = new class_1277(this.INVENTORY_SIZE);
        this.inventory.method_7659(nbt.method_10554("inventory", 10));
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("inventory", (class_2520)this.inventory.method_7660());
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound);
        return nbtCompound;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void updateInClientWorld() {
        this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.field_11863.method_8320(this.field_11867), 4);
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public static void clientTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, ItemBowlBlockEntity itemBowlBlockEntity) {
        Optional<class_1767> optionalItemColor;
        class_1799 storedStack = itemBowlBlockEntity.getInventory().method_5438(0);
        if (!storedStack.method_7960() && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(storedStack.method_7909())).isPresent()) {
            int particleCount = Support.getIntFromDecimalWithChance(Math.max(0.1, (double)((float)storedStack.method_7947() / (float)(storedStack.method_7914() * 2))), world.field_9229);
            ItemBowlBlockEntity.spawnRisingParticles(world, blockPos, storedStack, particleCount);
        }
    }

    public int decrementBowlStack(class_2338 particleTargetBlockPos, int amount) {
        class_1799 storedStack = this.inventory.method_5438(0);
        if (storedStack.method_7960()) {
            return 0;
        }
        int decrementAmount = Math.min(amount, storedStack.method_7947());
        class_1792 recipeRemainderItem = storedStack.method_7909().method_7858();
        if (recipeRemainderItem != null) {
            if (storedStack.method_7947() == 1) {
                this.inventory.method_5447(0, recipeRemainderItem.method_7854());
            } else {
                this.inventory.method_5438(0).method_7934(decrementAmount);
                class_1799 remainderStack = recipeRemainderItem.method_7854();
                remainderStack.method_7939(decrementAmount);
                class_1542 itemEntity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5, remainderStack);
                itemEntity.method_5762(0.0, 0.1, 0.0);
                this.field_11863.method_8649((class_1297)itemEntity);
            }
        } else {
            this.inventory.method_5438(0).method_7934(decrementAmount);
        }
        if (decrementAmount > 0) {
            this.doEnchantingEffects(particleTargetBlockPos, decrementAmount);
            this.updateInClientWorld();
            this.method_5431();
        }
        return decrementAmount;
    }

    public void doEnchantingEffects(class_2338 enchanterBlockPos, int amount) {
        Optional<class_1767> optionalItemColor;
        class_1799 storedStack = this.getInventory().method_5438(0);
        if (!storedStack.method_7960() && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(storedStack.method_7909())).isPresent()) {
            class_2394 sparkleRisingParticleEffect = SpectrumParticleTypes.getSparkleRisingParticle(optionalItemColor.get());
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                SpectrumS2CPackets.playParticleWithRandomOffsetAndVelocity((class_3218)this.field_11863, new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5), sparkleRisingParticleEffect, 50, new class_243(0.4, 0.2, 0.4), new class_243(0.06, 0.16, 0.06));
                SpectrumS2CPackets.playTransphereParticle(serverWorld, new Transphere(this.field_11867, (class_5716)new class_5707(enchanterBlockPos), 20, optionalItemColor.get()));
            } else {
                class_19372 = this.field_11863;
                if (class_19372 instanceof class_638) {
                    class_638 clientWorld = (class_638)class_19372;
                    for (int i = 0; i < 50; ++i) {
                        float randomOffsetX = (float)this.field_11867.method_10263() + 0.3f + this.field_11863.field_9229.nextFloat() * 0.6f;
                        float randomOffsetY = (float)this.field_11867.method_10264() + 0.3f + this.field_11863.field_9229.nextFloat() * 0.6f;
                        float randomOffsetZ = (float)this.field_11867.method_10260() + 0.3f + this.field_11863.field_9229.nextFloat() * 0.6f;
                        float randomVelocityX = 0.03f - this.field_11863.field_9229.nextFloat() * 0.06f;
                        float randomVelocityY = this.field_11863.field_9229.nextFloat() * 0.16f;
                        float randomVelocityZ = 0.03f - this.field_11863.field_9229.nextFloat() * 0.06f;
                        clientWorld.method_8406(sparkleRisingParticleEffect, (double)randomOffsetX, (double)randomOffsetY, (double)randomOffsetZ, (double)randomVelocityX, (double)randomVelocityY, (double)randomVelocityZ);
                    }
                    TransphereParticleEffect sphereParticleEffect = new TransphereParticleEffect(new Transphere(this.field_11867, (class_5716)new class_5707(enchanterBlockPos), 20, optionalItemColor.get()));
                    clientWorld.method_8406((class_2394)sphereParticleEffect, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, (double)(enchanterBlockPos.method_10263() - this.field_11867.method_10263()) * 0.045, 0.0, (double)(enchanterBlockPos.method_10260() - this.field_11867.method_10260()) * 0.045);
                }
            }
            this.field_11863.method_8396(null, this.field_11867, SpectrumSoundEvents.ENCHANTER_DING, class_3419.field_15245, 1.0f, 0.7f + this.field_11863.field_9229.nextFloat() * 0.6f);
        }
    }

    public static void spawnRisingParticles(class_1937 world, class_2338 blockPos, class_1799 itemStack, int amount) {
        Optional<class_1767> optionalItemColor;
        if (amount > 0 && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(itemStack.method_7909())).isPresent()) {
            class_2394 particleEffect = SpectrumParticleTypes.getSparkleRisingParticle(optionalItemColor.get());
            for (int i = 0; i < amount; ++i) {
                float randomX = 0.1f + world.method_8409().nextFloat() * 0.8f;
                float randomZ = 0.1f + world.method_8409().nextFloat() * 0.8f;
                world.method_8406(particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 0.75, (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.05, 0.0);
            }
        }
    }
}

