/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.item_bowl;

import de.dafuqs.spectrum.InventoryHelper;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterBlockEntity;
import de.dafuqs.spectrum.blocks.item_bowl.ItemBowlBlockEntity;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBowlBlock
extends class_2237 {
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    private final List<class_2382> possibleEnchanterOffsets = new ArrayList<class_2382>(){
        {
            this.add(new class_2382(5, 0, 3));
            this.add(new class_2382(-5, 0, -3));
            this.add(new class_2382(-3, 0, 5));
            this.add(new class_2382(-3, 0, -5));
            this.add(new class_2382(3, 0, 5));
            this.add(new class_2382(3, 0, -5));
            this.add(new class_2382(5, 0, 3));
            this.add(new class_2382(5, 0, -3));
        }
    };

    public ItemBowlBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (!world.field_9236 && entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            class_1799 remainingStack = this.inputItem(world, pos, itemEntity.method_6983());
            if (remainingStack.method_7960()) {
                itemEntity.method_5650(class_1297.class_5529.field_26999);
            } else {
                itemEntity.method_6979(remainingStack);
            }
        } else {
            super.method_9554(world, state, pos, entity, fallDistance);
        }
    }

    public class_1799 inputItem(class_1937 world, class_2338 pos, class_1799 itemStack) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ItemBowlBlockEntity) {
            ItemBowlBlockEntity itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            int previousCount = itemStack.method_7947();
            class_1799 remainingStack = InventoryHelper.smartAddToInventory(itemStack, itemBowlBlockEntity.getInventory(), null);
            if (remainingStack.method_7947() != previousCount) {
                itemBowlBlockEntity.method_5431();
                itemBowlBlockEntity.updateInClientWorld();
                this.updateConnectedEnchanter(world, pos);
                world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.8f, 0.8f + world.field_9229.nextFloat() * 0.6f);
            }
            return remainingStack;
        }
        return itemStack;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ItemBowlBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return ItemBowlBlock.method_31618(type, SpectrumBlockEntityRegistry.ITEM_BOWL, ItemBowlBlockEntity::clientTick);
        }
        return null;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        ItemBowlBlock.scatterContents(world, pos);
        this.updateConnectedEnchanter(world, pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    private void updateConnectedEnchanter(@NotNull class_1937 world, @NotNull class_2338 pos) {
        for (class_2382 possibleUpgradeBlockOffset : this.possibleEnchanterOffsets) {
            class_2338 currentPos = pos.method_10081(possibleUpgradeBlockOffset);
            class_2586 blockEntity = world.method_8321(currentPos);
            if (!(blockEntity instanceof EnchanterBlockEntity)) continue;
            EnchanterBlockEntity enchanterBlockEntity = (EnchanterBlockEntity)blockEntity;
            enchanterBlockEntity.inventoryChanged();
            break;
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_1799 handStack = player.method_5998(hand);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ItemBowlBlockEntity) {
            ItemBowlBlockEntity itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            boolean itemsChanged = false;
            if (player.method_5715()) {
                class_1263 inventory = itemBowlBlockEntity.getInventory();
                class_1799 retrievedStack = inventory.method_5441(0);
                if (!retrievedStack.method_7960()) {
                    player.method_7270(retrievedStack);
                    itemsChanged = true;
                }
            } else {
                class_1263 inventory = itemBowlBlockEntity.getInventory();
                class_1799 currentStack = inventory.method_5438(0);
                if (!handStack.method_7960() && !currentStack.method_7960()) {
                    inventory.method_5447(0, handStack);
                    player.method_6122(hand, currentStack);
                    itemsChanged = true;
                } else {
                    if (!handStack.method_7960()) {
                        class_1799 remainingStack = InventoryHelper.smartAddToInventory(handStack, itemBowlBlockEntity.getInventory(), null);
                        player.method_6122(hand, remainingStack);
                        itemsChanged = true;
                    }
                    if (!currentStack.method_7960()) {
                        player.method_7270(currentStack);
                        itemsChanged = true;
                    }
                }
            }
            if (itemsChanged) {
                itemBowlBlockEntity.method_5431();
                itemBowlBlockEntity.updateInClientWorld();
                this.updateConnectedEnchanter(world, pos);
                world.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.8f, 0.8f + world.field_9229.nextFloat() * 0.6f);
            }
        }
        return class_1269.field_21466;
    }

    public static void scatterContents(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ItemBowlBlockEntity) {
            ItemBowlBlockEntity itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)itemBowlBlockEntity.getInventory());
            world.method_8455(pos, block);
        }
    }
}

