/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.fusion_shrine;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterBlockEntity;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlock;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipe;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipeWorldEffect;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import de.dafuqs.spectrum.registries.color.ColorRegistry;
import de.dafuqs.spectrum.sound.SpectrumSoundEvents;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1737;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionShrineBlockEntity
extends class_2586
implements class_1737,
PlayerOwned,
Upgradeable {
    private UUID ownerUUID;
    private Map<Upgradeable.UpgradeType, Double> upgrades;
    protected int INVENTORY_SIZE = 8;
    protected class_1277 inventory = new class_1277(this.INVENTORY_SIZE);
    @NotNull
    protected class_3611 storedFluid = class_3612.field_15906;
    private FusionShrineRecipe currentRecipe;
    private int craftingTime;
    private int craftingTimeTotal;

    public FusionShrineBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntityRegistry.FUSION_SHRINE, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = new class_1277(this.INVENTORY_SIZE);
        this.inventory.method_7659(nbt.method_10554("inventory", 10));
        this.storedFluid = (class_3611)class_2378.field_11154.method_10223(class_2960.method_12829((String)nbt.method_10558("fluid")));
        this.craftingTime = nbt.method_10568("CraftingTime");
        this.craftingTimeTotal = nbt.method_10568("CraftingTimeTotal");
        this.ownerUUID = nbt.method_10545("OwnerUUID") ? nbt.method_25926("OwnerUUID") : null;
        if (nbt.method_10545("CurrentRecipe")) {
            String recipeString = nbt.method_10558("CurrentRecipe");
            if (!recipeString.isEmpty()) {
                FusionShrineRecipe optionalFusionRecipe;
                Object t;
                Optional optionalRecipe = Optional.empty();
                if (this.field_11863 != null) {
                    optionalRecipe = this.field_11863.method_8433().method_8130(new class_2960(recipeString));
                }
                this.currentRecipe = optionalRecipe.isPresent() && (t = optionalRecipe.get()) instanceof FusionShrineRecipe ? (optionalFusionRecipe = (FusionShrineRecipe)t) : null;
            } else {
                this.currentRecipe = null;
            }
        } else {
            this.currentRecipe = null;
        }
        if (nbt.method_10573("Upgrades", 9)) {
            this.upgrades = Upgradeable.fromNbt(nbt.method_10554("Upgrades", 10));
        }
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("inventory", (class_2520)this.inventory.method_7660());
        nbt.method_10582("fluid", class_2378.field_11154.method_10221((Object)this.storedFluid).toString());
        nbt.method_10575("CraftingTime", (short)this.craftingTime);
        nbt.method_10575("CraftingTimeTotal", (short)this.craftingTimeTotal);
        if (this.upgrades != null) {
            nbt.method_10566("Upgrades", (class_2520)Upgradeable.toNbt(this.upgrades));
        }
        if (this.ownerUUID != null) {
            nbt.method_25927("OwnerUUID", this.ownerUUID);
        }
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.method_8114().toString());
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public static void clientTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, FusionShrineBlockEntity fusionShrineBlockEntity) {
        FusionShrineRecipe recipe;
        class_2400 particleEffect;
        Optional<class_1767> optionalItemColor;
        int randomSlot;
        class_1799 randomStack;
        class_1263 inventory = fusionShrineBlockEntity.getInventory();
        if (!inventory.method_5442() && !(randomStack = inventory.method_5438(randomSlot = fusionShrineBlockEntity.field_11863.method_8409().nextInt(inventory.method_5439()))).method_7960() && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(randomStack.method_7909())).isPresent()) {
            particleEffect = SpectrumParticleTypes.getCraftingParticle(optionalItemColor.get());
            int particleAmount = (int)StrictMath.ceil((float)randomStack.method_7947() / 8.0f);
            for (int i = 0; i < particleAmount; ++i) {
                float randomX = 3.0f - world.method_8409().nextFloat() * 7.0f;
                float randomZ = 3.0f - world.method_8409().nextFloat() * 7.0f;
                world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.0, 0.0);
            }
        }
        if ((recipe = fusionShrineBlockEntity.currentRecipe) != null) {
            Optional<class_1767> optionalFluidColor;
            class_3611 fluid = fusionShrineBlockEntity.getFluid();
            if (recipe.getFluidInput().equals(fluid) && recipe.areConditionMetCurrently(world) && (optionalFluidColor = ColorRegistry.FLUID_COLORS.getMapping(fluid)).isPresent()) {
                particleEffect = SpectrumParticleTypes.getFluidRisingParticle(optionalFluidColor.get());
                float randomX = 0.25f + world.method_8409().nextFloat() * 0.5f;
                float randomZ = 0.25f + world.method_8409().nextFloat() * 0.5f;
                world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)(blockPos.method_10264() + 1), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.1, 0.0);
            }
        }
    }

    public static void serverTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, FusionShrineBlockEntity fusionShrineBlockEntity) {
        FusionShrineRecipe recipe;
        if (fusionShrineBlockEntity.upgrades == null) {
            fusionShrineBlockEntity.calculateUpgrades();
        }
        if ((recipe = FusionShrineBlockEntity.getCurrentRecipe(world, fusionShrineBlockEntity)) != null && recipe.getFluidInput().equals(fusionShrineBlockEntity.storedFluid)) {
            FusionShrineRecipeWorldEffect effect;
            if (fusionShrineBlockEntity.craftingTime % 60 == 0) {
                boolean structureCompleteWithSky;
                class_1657 lastInteractedPlayer = PlayerOwned.getPlayerEntityIfOnline(world, fusionShrineBlockEntity.ownerUUID);
                boolean recipeConditionsMet = Support.hasAdvancement(lastInteractedPlayer, recipe.getRequiredAdvancementIdentifier()) && recipe.areConditionMetCurrently(world);
                boolean bl = structureCompleteWithSky = world.method_8320(blockPos.method_10084()).method_26215() && world.method_8311(blockPos) && FusionShrineBlock.verifyStructure(world, blockPos, null);
                if (!recipeConditionsMet || !structureCompleteWithSky) {
                    if (!structureCompleteWithSky) {
                        world.method_8396(null, fusionShrineBlockEntity.method_11016(), SpectrumSoundEvents.FUSION_SHRINE_CRAFTING_ABORTED, class_3419.field_15245, 0.9f + fusionShrineBlockEntity.field_11863.field_9229.nextFloat() * 0.2f, 0.9f + fusionShrineBlockEntity.field_11863.field_9229.nextFloat() * 0.2f);
                        world.method_8396(null, fusionShrineBlockEntity.method_11016(), class_3417.field_15197, class_3419.field_15245, 0.9f + fusionShrineBlockEntity.field_11863.field_9229.nextFloat() * 0.2f, 0.5f + fusionShrineBlockEntity.field_11863.field_9229.nextFloat() * 0.2f);
                        FusionShrineBlock.scatterContents(world, blockPos);
                    }
                    fusionShrineBlockEntity.craftingTime = 0;
                    return;
                }
            }
            ++fusionShrineBlockEntity.craftingTime;
            fusionShrineBlockEntity.method_5431();
            if (fusionShrineBlockEntity.craftingTime == 1 && fusionShrineBlockEntity.craftingTimeTotal > 1) {
                SpectrumS2CPackets.sendPlayBlockBoundSoundInstance(SpectrumSoundEvents.FUSION_SHRINE_CRAFTING, (class_3218)fusionShrineBlockEntity.field_11863, fusionShrineBlockEntity.method_11016(), fusionShrineBlockEntity.craftingTimeTotal - fusionShrineBlockEntity.craftingTime);
            }
            if ((effect = recipe.getWorldEffectForTick(fusionShrineBlockEntity.craftingTime)) != null) {
                effect.doEffect((class_3218)world, blockPos);
            }
            if (fusionShrineBlockEntity.craftingTime == fusionShrineBlockEntity.craftingTimeTotal) {
                FusionShrineBlockEntity.craft(world, blockPos, fusionShrineBlockEntity, recipe);
                fusionShrineBlockEntity.inventory.method_5431();
            }
            fusionShrineBlockEntity.method_5431();
        } else if (fusionShrineBlockEntity.craftingTime > 0) {
            fusionShrineBlockEntity.craftingTime = 0;
            fusionShrineBlockEntity.method_5431();
        }
    }

    private static FusionShrineRecipe getCurrentRecipe(@NotNull class_1937 world, FusionShrineBlockEntity fusionShrineBlockEntity) {
        if (fusionShrineBlockEntity.currentRecipe != null && fusionShrineBlockEntity.currentRecipe.method_8115((class_1263)fusionShrineBlockEntity.inventory, world)) {
            return fusionShrineBlockEntity.currentRecipe;
        }
        FusionShrineRecipe previousRecipe = fusionShrineBlockEntity.currentRecipe;
        FusionShrineRecipe recipe = world.method_8433().method_8132(SpectrumRecipeTypes.FUSION_SHRINE, (class_1263)fusionShrineBlockEntity.inventory, world).orElse(null);
        fusionShrineBlockEntity.craftingTime = 0;
        fusionShrineBlockEntity.currentRecipe = recipe;
        if (recipe == null) {
            SpectrumS2CPackets.sendCancelBlockBoundSoundInstance((class_3218)fusionShrineBlockEntity.field_11863, fusionShrineBlockEntity.field_11867);
        } else {
            fusionShrineBlockEntity.craftingTimeTotal = (int)Math.ceil((double)recipe.getCraftingTime() / fusionShrineBlockEntity.upgrades.get((Object)Upgradeable.UpgradeType.SPEED));
        }
        if (fusionShrineBlockEntity.currentRecipe != previousRecipe) {
            fusionShrineBlockEntity.updateInClientWorld();
        }
        return recipe;
    }

    private static void craft(class_1937 world, class_2338 blockPos, FusionShrineBlockEntity fusionShrineBlockEntity, FusionShrineRecipe recipe) {
        if (!recipe.method_8110().method_7960()) {
            int maxAmount = recipe.method_8110().method_7914();
            block0: for (class_1856 ingredient : recipe.method_8117()) {
                for (int i = 0; i < fusionShrineBlockEntity.INVENTORY_SIZE; ++i) {
                    class_1799 currentStack = fusionShrineBlockEntity.inventory.method_5438(i);
                    if (!ingredient.method_8093(currentStack)) continue;
                    maxAmount = Math.min(maxAmount, currentStack.method_7947());
                    continue block0;
                }
            }
            double efficiencyModifier = fusionShrineBlockEntity.upgrades.get((Object)Upgradeable.UpgradeType.EFFICIENCY);
            if (maxAmount > 0) {
                block2: for (class_1856 ingredient : recipe.method_8117()) {
                    for (int i = 0; i < fusionShrineBlockEntity.INVENTORY_SIZE; ++i) {
                        class_1799 currentStack = fusionShrineBlockEntity.inventory.method_5438(i);
                        if (!ingredient.method_8093(currentStack)) continue;
                        int reducedAmount = Support.getIntFromDecimalWithChance((double)maxAmount / efficiencyModifier, fusionShrineBlockEntity.field_11863.field_9229);
                        if (currentStack.method_7947() - reducedAmount < 1) {
                            fusionShrineBlockEntity.inventory.method_5447(i, class_1799.field_8037);
                            continue block2;
                        }
                        currentStack.method_7934(reducedAmount);
                        continue block2;
                    }
                }
                fusionShrineBlockEntity.setFluid(class_3612.field_15906);
                FusionShrineBlockEntity.spawnCraftingResultAndXP(world, fusionShrineBlockEntity, recipe, maxAmount);
                FusionShrineBlockEntity.scatterContents(world, blockPos.method_10084(), fusionShrineBlockEntity);
                SpectrumS2CPackets.sendPlayFusionCraftingFinishedParticles(world, blockPos, recipe.method_8110());
                fusionShrineBlockEntity.playSound(SpectrumSoundEvents.FUSION_SHRINE_CRAFTING_FINISHED, 1.4f);
            }
        } else {
            block4: for (class_1856 ingredient : recipe.method_8117()) {
                for (int i = 0; i < fusionShrineBlockEntity.INVENTORY_SIZE; ++i) {
                    class_1799 currentStack = fusionShrineBlockEntity.inventory.method_5438(i);
                    if (!ingredient.method_8093(currentStack)) continue;
                    int reducedAmount = Support.getIntFromDecimalWithChance(1.0, fusionShrineBlockEntity.field_11863.field_9229);
                    if (currentStack.method_7947() - reducedAmount < 1) {
                        fusionShrineBlockEntity.inventory.method_5447(i, class_1799.field_8037);
                        continue block4;
                    }
                    currentStack.method_7934(reducedAmount);
                    continue block4;
                }
            }
            fusionShrineBlockEntity.setFluid(class_3612.field_15906);
            FusionShrineBlockEntity.scatterContents(world, blockPos.method_10084(), fusionShrineBlockEntity);
            fusionShrineBlockEntity.playSound(SpectrumSoundEvents.FUSION_SHRINE_CRAFTING_FINISHED, 1.4f);
        }
    }

    public void playSound(class_3414 soundEvent, float volume) {
        Random random = this.field_11863.field_9229;
        this.field_11863.method_8465(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), soundEvent, class_3419.field_15245, volume, 0.9f + random.nextFloat() * 0.15f);
    }

    private void grantPlayerFusionCraftingAdvancement(FusionShrineRecipe recipe, int experience) {
        class_3222 serverPlayerEntity = (class_3222)PlayerOwned.getPlayerEntityIfOnline(this.field_11863, this.ownerUUID);
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.FUSION_SHRINE_CRAFTING.trigger(serverPlayerEntity, recipe.method_8110(), experience);
        }
    }

    public static void spawnCraftingResultAndXP(class_1937 world, FusionShrineBlockEntity blockEntity, FusionShrineRecipe recipe, int amount) {
        int resultAmountBeforeMod = amount * recipe.method_8110().method_7947();
        double yieldModifier = recipe.areYieldUpgradesDisabled() ? 1.0 : blockEntity.upgrades.get((Object)Upgradeable.UpgradeType.YIELD);
        int resultAmountAfterMod = Support.getIntFromDecimalWithChance((double)resultAmountBeforeMod * yieldModifier, blockEntity.field_11863.field_9229);
        EnchanterBlockEntity.spawnItemStackAsEntitySplitViaMaxCount(world, blockEntity.field_11867, recipe.method_8110(), resultAmountAfterMod);
        int spawnedXPAmount = 0;
        if (recipe.getExperience() > 0.0f) {
            double experienceModifier = blockEntity.upgrades.get((Object)Upgradeable.UpgradeType.EXPERIENCE);
            float recipeExperienceBeforeMod = recipe.getExperience();
            spawnedXPAmount = Support.getIntFromDecimalWithChance((double)recipeExperienceBeforeMod * experienceModifier, blockEntity.field_11863.field_9229);
            if (spawnedXPAmount > 0) {
                class_1303 experienceOrbEntity = new class_1303(world, (double)blockEntity.field_11867.method_10263() + 0.5, (double)(blockEntity.field_11867.method_10264() + 1), (double)blockEntity.field_11867.method_10260() + 0.5, spawnedXPAmount);
                world.method_8649((class_1297)experienceOrbEntity);
            }
        }
        blockEntity.grantPlayerFusionCraftingAdvancement(recipe, spawnedXPAmount);
    }

    public static void scatterContents(class_1937 world, class_2338 pos, FusionShrineBlockEntity blockEntity) {
        class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)blockEntity.inventory);
        world.method_8455(pos, world.method_8320(pos).method_26204());
    }

    @NotNull
    public class_3611 getFluid() {
        return this.storedFluid;
    }

    public void setFluid(@NotNull class_3611 fluid) {
        this.storedFluid = fluid;
        this.setLightForFluid(this.field_11863, this.field_11867, fluid);
        this.method_5431();
        this.updateInClientWorld();
    }

    public void setLightForFluid(class_1937 world, class_2338 blockPos, class_3611 fluid) {
        if (SpectrumCommon.fluidLuminance.containsKey(fluid)) {
            int light = SpectrumCommon.fluidLuminance.get(fluid);
            world.method_8652(blockPos, (class_2680)world.method_8320(blockPos).method_11657((class_2769)FusionShrineBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 3);
        }
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound);
        return nbtCompound;
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public void method_7683(class_1662 finder) {
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
    }

    public void updateInClientWorld() {
        ((class_3218)this.field_11863).method_14178().method_14128(this.field_11867);
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void calculateUpgrades() {
        class_3545<Integer, Map<Upgradeable.UpgradeType, Double>> upgrades = Upgradeable.checkUpgradeMods(this.field_11863, this.field_11867, 2, 0);
        this.upgrades = (Map)upgrades.method_15441();
        this.method_5431();
    }
}

