/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.fusion_shrine;

import de.dafuqs.spectrum.InventoryHelper;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlockEntity;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import java.util.Optional;
import net.fabricmc.fabric.mixin.transfer.BucketItemAccessor;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class FusionShrineBlock
extends class_2237 {
    public static final class_2758 LIGHT_LEVEL = class_2758.method_11867((String)"light_level", (int)0, (int)15);
    protected static final class_265 SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);

    public FusionShrineBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIGHT_LEVEL});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FusionShrineBlockEntity(pos, state);
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            FusionShrineBlock.clearCurrentlyRenderedMultiBlock((class_1937)world);
        }
    }

    public static void clearCurrentlyRenderedMultiBlock(class_1937 world) {
        IMultiblock currentlyRenderedMultiBlock;
        if (world.field_9236 && (currentlyRenderedMultiBlock = PatchouliAPI.get().getCurrentMultiblock()) != null && currentlyRenderedMultiBlock.getID().equals((Object)SpectrumMultiblocks.FUSION_SHRINE_IDENTIFIER)) {
            PatchouliAPI.get().clearMultiblock();
        }
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (!world.field_9236 && entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            if (itemEntity.method_19538().field_1352 % 0.5 != 0.0 && itemEntity.method_19538().field_1350 % 0.5 != 0.0) {
                class_1799 remainingStack = this.inputItemStack(world, pos, itemEntity.method_6983());
                if (remainingStack.method_7960()) {
                    itemEntity.method_5650(class_1297.class_5529.field_26999);
                } else {
                    itemEntity.method_6979(remainingStack);
                }
            }
        } else {
            super.method_9554(world, state, pos, entity, fallDistance);
        }
    }

    public class_1799 inputItemStack(class_1937 world, class_2338 pos, class_1799 itemStack) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof FusionShrineBlockEntity) {
            FusionShrineBlockEntity fusionShrineBlockEntity = (FusionShrineBlockEntity)blockEntity;
            if (itemStack.method_7909() instanceof class_1755) {
                return this.inputFluidViaBucket(world, pos, itemStack);
            }
            int previousCount = itemStack.method_7947();
            class_1799 remainingStack = InventoryHelper.smartAddToInventory(itemStack, fusionShrineBlockEntity.getInventory(), null);
            if (remainingStack.method_7947() != previousCount) {
                fusionShrineBlockEntity.method_5431();
                fusionShrineBlockEntity.updateInClientWorld();
                world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.8f, 0.8f + world.field_9229.nextFloat() * 0.6f);
                return remainingStack;
            }
        }
        return itemStack;
    }

    public class_1799 inputFluidViaBucket(class_1937 world, class_2338 blockPos, class_1799 bucketStack) {
        class_2586 blockEntity;
        if (bucketStack.method_7909() instanceof class_1755 && (blockEntity = world.method_8321(blockPos)) instanceof FusionShrineBlockEntity) {
            FusionShrineBlockEntity fusionShrineBlockEntity = (FusionShrineBlockEntity)blockEntity;
            class_3611 storedFluid = fusionShrineBlockEntity.getFluid();
            class_3611 bucketFluid = ((BucketItemAccessor)bucketStack.method_7909()).fabric_getFluid();
            if (storedFluid == class_3612.field_15906 && bucketFluid != class_3612.field_15906) {
                fusionShrineBlockEntity.setFluid(bucketFluid);
                fusionShrineBlockEntity.method_5431();
                fusionShrineBlockEntity.updateInClientWorld();
                Optional soundEvent = storedFluid.method_32359();
                if (soundEvent.isPresent()) {
                    world.method_8396(null, blockPos, class_3417.field_15197, class_3419.field_15248, 0.8f, 0.8f + world.field_9229.nextFloat() * 0.6f);
                }
                return new class_1799((class_1935)class_1802.field_8550);
            }
            if (storedFluid != class_3612.field_15906 && bucketFluid == class_3612.field_15906) {
                fusionShrineBlockEntity.setFluid(class_3612.field_15906);
                fusionShrineBlockEntity.method_5431();
                fusionShrineBlockEntity.updateInClientWorld();
                Optional soundEvent = storedFluid.method_32359();
                if (soundEvent.isPresent()) {
                    world.method_8396(null, blockPos, class_3417.field_15197, class_3419.field_15248, 0.8f, 0.8f + world.field_9229.nextFloat() * 0.6f);
                }
                return storedFluid.method_15774().method_7854();
            }
        }
        return bucketStack;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            FusionShrineBlock.verifyStructure(world, pos, null);
            return class_1269.field_5812;
        }
        class_1799 itemStack = player.method_5998(hand);
        boolean itemsChanged = false;
        Optional soundToPlay = Optional.empty();
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof FusionShrineBlockEntity) {
            FusionShrineBlockEntity fusionShrineBlockEntity = (FusionShrineBlockEntity)blockEntity;
            if (itemStack.method_7909() instanceof class_1755) {
                fusionShrineBlockEntity.setOwner(player);
                class_3611 storedFluid = fusionShrineBlockEntity.getFluid();
                class_3611 bucketFluid = ((BucketItemAccessor)itemStack.method_7909()).fabric_getFluid();
                if (storedFluid == class_3612.field_15906 && bucketFluid != class_3612.field_15906) {
                    fusionShrineBlockEntity.setFluid(bucketFluid);
                    if (!player.method_7337()) {
                        class_1799 handStack = player.method_5998(hand);
                        handStack.method_7934(1);
                        player.method_6122(hand, handStack);
                        player.method_7270(class_1802.field_8550.method_7854());
                    }
                    soundToPlay = bucketFluid.method_32359();
                    itemsChanged = true;
                } else if (storedFluid != class_3612.field_15906 && bucketFluid == class_3612.field_15906) {
                    fusionShrineBlockEntity.setFluid(class_3612.field_15906);
                    if (!player.method_7337()) {
                        class_1799 handStack = player.method_5998(hand);
                        handStack.method_7934(1);
                        player.method_6122(hand, handStack);
                        player.method_7270(new class_1799((class_1935)storedFluid.method_15774()));
                    }
                    soundToPlay = storedFluid.method_32359();
                    itemsChanged = true;
                }
            } else if (player.method_5715()) {
                class_1799 retrievedStack = class_1799.field_8037;
                class_1263 inventory = fusionShrineBlockEntity.getInventory();
                for (int i = inventory.method_5439() - 1; i >= 0 && (retrievedStack = inventory.method_5441(i)).method_7960(); --i) {
                }
                if (!retrievedStack.method_7960()) {
                    player.method_7270(retrievedStack);
                    soundToPlay = Optional.of(class_3417.field_15197);
                    itemsChanged = true;
                }
            } else if (!itemStack.method_7960() && FusionShrineBlock.verifyStructure(world, pos, (class_3222)player)) {
                fusionShrineBlockEntity.setOwner(player);
                class_1799 remainingStack = InventoryHelper.smartAddToInventory(itemStack, fusionShrineBlockEntity.getInventory(), null);
                player.method_6122(hand, remainingStack);
                soundToPlay = Optional.of(class_3417.field_15197);
                itemsChanged = true;
            }
            if (itemsChanged) {
                fusionShrineBlockEntity.method_5431();
                fusionShrineBlockEntity.inventory.method_5431();
                fusionShrineBlockEntity.updateInClientWorld();
                if (soundToPlay.isPresent()) {
                    world.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.8f, 0.8f + world.field_9229.nextFloat() * 0.6f);
                }
            }
        }
        return class_1269.field_21466;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return FusionShrineBlock.method_31618(type, SpectrumBlockEntityRegistry.FUSION_SHRINE, FusionShrineBlockEntity::clientTick);
        }
        return FusionShrineBlock.method_31618(type, SpectrumBlockEntityRegistry.FUSION_SHRINE, FusionShrineBlockEntity::serverTick);
    }

    public static boolean verifyStructure(class_1937 world, class_2338 blockPos, @Nullable class_3222 serverPlayerEntity) {
        IMultiblock multiblock = SpectrumMultiblocks.MULTIBLOCKS.get(SpectrumMultiblocks.FUSION_SHRINE_IDENTIFIER);
        boolean valid = multiblock.validate(world, blockPos.method_10074(), class_2470.field_11467);
        if (valid) {
            if (serverPlayerEntity != null) {
                SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger(serverPlayerEntity, multiblock);
            }
        } else if (world.field_9236) {
            IMultiblock currentMultiBlock = PatchouliAPI.get().getCurrentMultiblock();
            if (currentMultiBlock == multiblock) {
                PatchouliAPI.get().clearMultiblock();
            } else {
                PatchouliAPI.get().showMultiblock(multiblock, (class_2561)new class_2588("multiblock.spectrum.fusion_shrine.structure"), blockPos.method_10087(2), class_2470.field_11467);
            }
        } else {
            FusionShrineBlock.scatterContents(world, blockPos);
        }
        return valid;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!newState.method_26204().equals((Object)this)) {
            FusionShrineBlock.scatterContents(world, pos);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public static void scatterContents(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof FusionShrineBlockEntity) {
            FusionShrineBlockEntity fusionShrineBlockEntity = (FusionShrineBlockEntity)blockEntity;
            class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)fusionShrineBlockEntity.getInventory());
            world.method_8455(pos, block);
            fusionShrineBlockEntity.updateInClientWorld();
        }
    }
}

