/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.enchanter;

import de.dafuqs.spectrum.blocks.enchanter.EnchanterBlockEntity;
import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class EnchanterBlock
extends class_2237 {
    protected static final class_265 SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);

    public EnchanterBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new EnchanterBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return EnchanterBlock.method_31618(type, SpectrumBlockEntityRegistry.ENCHANTER, EnchanterBlockEntity::clientTick);
        }
        return EnchanterBlock.method_31618(type, SpectrumBlockEntityRegistry.ENCHANTER, EnchanterBlockEntity::serverTick);
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            EnchanterBlock.clearCurrentlyRenderedMultiBlock((class_1937)world);
        }
    }

    public static void clearCurrentlyRenderedMultiBlock(class_1937 world) {
        IMultiblock currentlyRenderedMultiBlock;
        if (world.field_9236 && (currentlyRenderedMultiBlock = PatchouliAPI.get().getCurrentMultiblock()) != null && currentlyRenderedMultiBlock.getID().equals((Object)SpectrumMultiblocks.ENCHANTER_IDENTIFIER)) {
            PatchouliAPI.get().clearMultiblock();
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        EnchanterBlock.scatterContents(world, pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            EnchanterBlock.verifyStructure(world, pos, null);
            return class_1269.field_5812;
        }
        if (EnchanterBlock.verifyStructure(world, pos, (class_3222)player)) {
            class_1799 handStack = player.method_5998(hand);
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof EnchanterBlockEntity) {
                int inputInventorySlotIndex;
                EnchanterBlockEntity enchanterBlockEntity = (EnchanterBlockEntity)blockEntity;
                boolean itemsChanged = false;
                class_1263 inventory = enchanterBlockEntity.getInventory();
                int n = handStack.method_7909() instanceof ExperienceStorageItem ? (inventory.method_5438(1).method_7960() ? 1 : 0) : (inputInventorySlotIndex = 0);
                if (player.method_5715() || handStack.method_7960()) {
                    for (int i = 0; i < 2; ++i) {
                        class_1799 retrievedStack = inventory.method_5441(i);
                        if (retrievedStack.method_7960()) continue;
                        player.method_7270(retrievedStack);
                        itemsChanged = true;
                        break;
                    }
                } else {
                    class_1799 currentStack = inventory.method_5438(inputInventorySlotIndex);
                    inventory.method_5447(inputInventorySlotIndex, handStack);
                    if (currentStack.method_7960()) {
                        player.method_6122(hand, class_1799.field_8037);
                    } else {
                        player.method_6122(hand, currentStack);
                    }
                    itemsChanged = true;
                }
                if (itemsChanged) {
                    enchanterBlockEntity.inventoryChanged();
                    enchanterBlockEntity.setItemFacingDirection(player.method_5735());
                    enchanterBlockEntity.setOwner(player);
                    enchanterBlockEntity.method_5431();
                    enchanterBlockEntity.updateInClientWorld();
                    world.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.8f, 0.8f + world.field_9229.nextFloat() * 0.6f);
                }
            }
        }
        return class_1269.field_21466;
    }

    public static boolean verifyStructure(class_1937 world, class_2338 blockPos, @Nullable class_3222 serverPlayerEntity) {
        IMultiblock multiblock = SpectrumMultiblocks.MULTIBLOCKS.get(SpectrumMultiblocks.ENCHANTER_IDENTIFIER);
        boolean valid = multiblock.validate(world, blockPos.method_10087(3), class_2470.field_11467);
        if (valid) {
            if (serverPlayerEntity != null) {
                SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger(serverPlayerEntity, multiblock);
            }
        } else if (world.field_9236) {
            IMultiblock currentMultiBlock = PatchouliAPI.get().getCurrentMultiblock();
            if (currentMultiBlock == multiblock) {
                PatchouliAPI.get().clearMultiblock();
            } else {
                PatchouliAPI.get().showMultiblock(multiblock, (class_2561)new class_2588("multiblock.spectrum.enchanter.structure"), blockPos.method_10087(4), class_2470.field_11467);
            }
        }
        return valid;
    }

    public static void scatterContents(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof EnchanterBlockEntity) {
            EnchanterBlockEntity enchanterBlockEntity = (EnchanterBlockEntity)blockEntity;
            class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)enchanterBlockEntity.getInventory());
            world.method_8455(pos, block);
        }
    }
}

