/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.decay;

import de.dafuqs.spectrum.Support;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3494;
import net.minecraft.class_4970;

public abstract class DecayBlock
extends class_2248 {
    protected final List<class_3494<class_2248>> decayConversionsList = new ArrayList<class_3494<class_2248>>();
    protected final HashMap<class_3494<class_2248>, class_2680> decayConversions = new HashMap();
    protected final class_3494<class_2248> whiteListBlockTag;
    protected final class_3494<class_2248> blackListBlockTag;
    protected final float damageOnTouching;
    protected final int tier;

    public DecayBlock(class_4970.class_2251 settings, class_3494<class_2248> whiteListBlockTag, class_3494<class_2248> blackListBlockTag, int tier, float damageOnTouching) {
        super(settings);
        this.whiteListBlockTag = whiteListBlockTag;
        this.blackListBlockTag = blackListBlockTag;
        this.damageOnTouching = damageOnTouching;
        this.tier = tier;
    }

    public void addDecayConversion(class_3494<class_2248> sourceBlockTag, class_2680 conversionState) {
        this.decayConversionsList.add(sourceBlockTag);
        this.decayConversions.put(sourceBlockTag, conversionState);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (entity instanceof class_1309 && !entity.method_5753() && !class_1890.method_8216((class_1309)((class_1309)entity))) {
            entity.method_5643(SpectrumDamageSources.DECAY, this.damageOnTouching);
        }
        super.method_9591(world, pos, state, entity);
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, Random random) {
        if (this.canSpread(state)) {
            float spreadChance = this.getSpreadChance();
            if (spreadChance < 1.0f && random.nextFloat() > spreadChance) {
                return;
            }
            class_2350 randomDirection = class_2350.method_10162((Random)random);
            class_2338 targetBlockPos = pos.method_10079(randomDirection, 1);
            class_2680 currentBlockState = world.method_8320(targetBlockPos);
            class_2586 blockEntity = world.method_8321(targetBlockPos);
            if (!(blockEntity != null || Support.hasBlockTag(currentBlockState, SpectrumBlockTags.DECAY) || this.whiteListBlockTag != null && !Support.hasBlockTag(currentBlockState, this.whiteListBlockTag) || this.blackListBlockTag != null && Support.hasBlockTag(currentBlockState, this.blackListBlockTag) || currentBlockState.method_26204() != class_2246.field_9987 && (!(currentBlockState.method_26204().method_36555() > -1.0f) || !(currentBlockState.method_26204().method_9520() < 3600000.0f)))) {
                class_2680 destinationBlockState = this.getSpreadState(state);
                for (class_3494<class_2248> currentCheckTag : this.decayConversionsList) {
                    class_2680 targetState = this.decayConversions.get(currentCheckTag);
                    if (!Support.hasBlockTag(currentBlockState, currentCheckTag)) continue;
                    destinationBlockState = targetState;
                    break;
                }
                world.method_8501(targetBlockPos, destinationBlockState);
            }
        }
    }

    protected abstract float getSpreadChance();

    protected abstract boolean canSpread(class_2680 var1);

    protected abstract class_2680 getSpreadState(class_2680 var1);
}

