/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.InventoryHelper;
import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlock;
import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlockEntity;
import de.dafuqs.spectrum.events.ExperienceOrbEntityTransferListener;
import de.dafuqs.spectrum.events.ItemEntityTransferListener;
import de.dafuqs.spectrum.events.SpectrumGameEvents;
import de.dafuqs.spectrum.events.SuckingChestEventListener;
import de.dafuqs.spectrum.inventories.SuckingChestScreenHandler;
import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import de.dafuqs.spectrum.sound.SpectrumSoundEvents;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5575;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class SuckingChestBlockEntity
extends SpectrumChestBlockEntity
implements ExtendedScreenHandlerFactory,
SuckingChestEventListener.Callback {
    private static final int RANGE = 12;
    public static final int INVENTORY_SIZE = 28;
    public static final int ITEM_FILTER_SLOTS = 5;
    public static final int EXPERIENCE_STORAGE_PROVIDER_ITEM_SLOT = 27;
    private final SuckingChestEventListener suckingChestEventListener;
    private final List<class_1792> filterItems;

    public SuckingChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntityRegistry.SUCKING_CHEST, blockPos, blockState);
        this.suckingChestEventListener = new SuckingChestEventListener((class_5716)new class_5707(this.field_11867), 12, this);
        this.filterItems = class_2371.method_10213((int)5, (Object)class_1802.field_8162);
    }

    protected class_2561 method_17823() {
        return new class_2588("block.spectrum.sucking_chest");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new SuckingChestScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        for (int i = 0; i < 5; ++i) {
            tag.method_10582("Filter" + i, class_2378.field_11142.method_10221((Object)this.filterItems.get(i)).toString());
        }
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        for (int i = 0; i < 5; ++i) {
            if (!tag.method_10573("Filter" + i, 8)) continue;
            this.filterItems.set(i, (class_1792)class_2378.field_11142.method_10223(new class_2960(tag.method_10558("Filter" + i))));
        }
    }

    public static void tick(@NotNull class_1937 world, class_2338 pos, class_2680 state, SuckingChestBlockEntity blockEntity) {
        if (world.field_9236) {
            blockEntity.lidAnimator.method_31672();
        } else {
            blockEntity.suckingChestEventListener.tick(world);
            if (world.method_8510() % 40L == 0L && !SpectrumChestBlock.isChestBlocked((class_1936)world, pos)) {
                SuckingChestBlockEntity.triggerNearbyEntities(blockEntity);
            }
        }
    }

    private static void triggerNearbyEntities(@NotNull SuckingChestBlockEntity blockEntity) {
        List itemEntities = blockEntity.field_11863.method_18023((class_5575)class_1299.field_6052, SuckingChestBlockEntity.getBoxWithRadius(blockEntity.field_11867, 12), class_1297::method_5805);
        for (class_1542 itemEntity : itemEntities) {
            if (!itemEntity.method_5805() || itemEntity.method_6983().method_7960()) continue;
            itemEntity.method_32876(SpectrumGameEvents.ENTITY_SPAWNED);
        }
        List experienceOrbEntities = blockEntity.field_11863.method_18023((class_5575)class_1299.field_6044, SuckingChestBlockEntity.getBoxWithRadius(blockEntity.field_11867, 12), class_1297::method_5805);
        for (class_1303 experienceOrbEntity : experienceOrbEntities) {
            if (!experienceOrbEntity.method_5805()) continue;
            experienceOrbEntity.method_32876(SpectrumGameEvents.ENTITY_SPAWNED);
        }
    }

    @Contract(value="_, _ -> new")
    @NotNull
    protected static class_238 getBoxWithRadius(class_2338 blockPos, int radius) {
        return class_238.method_30048((class_243)class_243.method_24953((class_2382)blockPos), (double)radius, (double)radius, (double)radius);
    }

    public int method_5439() {
        return 28;
    }

    public SuckingChestEventListener getEventListener() {
        return this.suckingChestEventListener;
    }

    @Override
    public boolean accepts(class_1937 world, class_5714 listener, class_2338 pos, class_5712 event, class_1297 entity) {
        class_1542 itemEntity;
        boolean isEntitySpawnEvent = event == SpectrumGameEvents.ENTITY_SPAWNED;
        return isEntitySpawnEvent && !SpectrumChestBlock.isChestBlocked((class_1936)this.field_11863, this.field_11867) && (entity instanceof class_1542 && this.acceptsItemStack((itemEntity = (class_1542)entity).method_6983()) || entity instanceof class_1303 && this.hasExperienceStorageItem());
    }

    @Override
    public void accept(class_1937 world, class_5714 listener, class_5712 event, int distance) {
        if (listener instanceof ItemEntityTransferListener) {
            class_1542 itemEntity;
            ItemEntityTransferListener itemEntityTransferListener = (ItemEntityTransferListener)listener;
            if (!SpectrumChestBlock.isChestBlocked((class_1936)world, this.field_11867) && (itemEntity = itemEntityTransferListener.getItemEntity()) != null && itemEntity.method_5805() && this.acceptsItemStack(itemEntity.method_6983())) {
                int previousAmount = itemEntity.method_6983().method_7947();
                class_1799 remainingStack = InventoryHelper.smartAddToInventory(itemEntity.method_6983(), (class_1263)this, class_2350.field_11036);
                if (remainingStack.method_7960()) {
                    SpectrumS2CPackets.sendPlayItemEntityAbsorbedParticle(world, itemEntity);
                    world.method_8396(null, itemEntity.method_24515(), class_3417.field_15197, class_3419.field_15245, 0.9f + this.field_11863.field_9229.nextFloat() * 0.2f, 0.9f + this.field_11863.field_9229.nextFloat() * 0.2f);
                    itemEntity.method_6979(class_1799.field_8037);
                } else if (remainingStack.method_7947() != previousAmount) {
                    SpectrumS2CPackets.sendPlayItemEntityAbsorbedParticle(world, itemEntity);
                    world.method_8396(null, itemEntity.method_24515(), class_3417.field_15197, class_3419.field_15245, 0.9f + this.field_11863.field_9229.nextFloat() * 0.2f, 0.9f + this.field_11863.field_9229.nextFloat() * 0.2f);
                    itemEntity.method_6979(remainingStack);
                }
            }
        } else if (listener instanceof ExperienceOrbEntityTransferListener) {
            class_1303 experienceOrbEntity;
            ExperienceOrbEntityTransferListener experienceOrbEntityTransferListener = (ExperienceOrbEntityTransferListener)listener;
            if (!SpectrumChestBlock.isChestBlocked((class_1936)world, this.field_11867) && (experienceOrbEntity = experienceOrbEntityTransferListener.getExperienceOrbEntity()) != null && experienceOrbEntity.method_5805() && this.hasExperienceStorageItem()) {
                ExperienceStorageItem.addStoredExperience((class_1799)this.inventory.get(27), experienceOrbEntity.method_5919());
                SpectrumS2CPackets.sendPlayExperienceOrbEntityAbsorbedParticle(world, experienceOrbEntity);
                world.method_8396(null, experienceOrbEntity.method_24515(), class_3417.field_14627, class_3419.field_15245, 0.9f + this.field_11863.field_9229.nextFloat() * 0.2f, 0.9f + this.field_11863.field_9229.nextFloat() * 0.2f);
                experienceOrbEntity.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    @Override
    public class_3414 getOpenSound() {
        return SpectrumSoundEvents.SUCKING_CHEST_OPEN;
    }

    @Override
    public class_3414 getCloseSound() {
        return SpectrumSoundEvents.SUCKING_CHEST_CLOSE;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
        for (class_1792 filterItem : this.filterItems) {
            buf.method_10812(class_2378.field_11142.method_10221((Object)filterItem));
        }
    }

    public List<class_1792> getItemFilters() {
        return this.filterItems;
    }

    public void setFilterItem(int slot, class_1792 item) {
        this.filterItems.set(slot, item);
        this.method_5431();
    }

    public boolean acceptsItemStack(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        boolean allAir = true;
        for (int i = 0; i < 5; ++i) {
            class_1792 filterItem = this.filterItems.get(i);
            if (filterItem.equals(itemStack.method_7909())) {
                return true;
            }
            if (filterItem.equals(class_1802.field_8162)) continue;
            allAir = false;
        }
        return allAir;
    }

    public boolean hasExperienceStorageItem() {
        return ((class_1799)this.inventory.get(27)).method_7909() instanceof ExperienceStorageItem;
    }
}

