/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.chests;

import de.dafuqs.spectrum.InventoryHelper;
import de.dafuqs.spectrum.blocks.chests.SpectrumChestBlockEntity;
import de.dafuqs.spectrum.inventories.AutoCompactingInventory;
import de.dafuqs.spectrum.inventories.CompactingChestScreenHandler;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3955;
import net.minecraft.class_3956;

public class CompactingChestBlockEntity
extends SpectrumChestBlockEntity
implements ExtendedScreenHandlerFactory {
    AutoCompactingInventory autoCompactingInventory = new AutoCompactingInventory();
    AutoCompactingInventory.AutoCraftingMode autoCraftingMode = AutoCompactingInventory.AutoCraftingMode.ThreeXTree;
    class_1799 lastCraftingItemStack = class_1799.field_8037;
    class_3955 lastCraftingRecipe = null;
    boolean hasToCraft = false;

    public CompactingChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntityRegistry.COMPACTING_CHEST, blockPos, blockState);
    }

    protected class_2561 method_17823() {
        return new class_2588("block.spectrum.compacting_chest");
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CompactingChestBlockEntity compactingChestBlockEntity) {
        boolean couldCraft;
        if (world.field_9236) {
            compactingChestBlockEntity.lidAnimator.method_31672();
        } else if (compactingChestBlockEntity.hasToCraft && !(couldCraft = compactingChestBlockEntity.tryCraftOnce())) {
            compactingChestBlockEntity.hasToCraft = false;
        }
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("AutoCraftingMode", 3)) {
            int autoCraftingModeInt = tag.method_10550("AutoCraftingMode");
            this.autoCraftingMode = AutoCompactingInventory.AutoCraftingMode.values()[autoCraftingModeInt];
        }
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("AutoCraftingMode", this.autoCraftingMode.ordinal());
    }

    public int method_5439() {
        return 27;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        this.hasToCraft = true;
    }

    public void inventoryChanged() {
        this.hasToCraft = true;
    }

    private boolean tryCraftOnce() {
        Optional<Object> optionalCraftingRecipe = Optional.empty();
        List craftingStacks = null;
        class_2371<class_1799> inventory = this.method_11282();
        if (this.lastCraftingRecipe != null) {
            class_3545<Integer, List<class_1799>> stackPair = InventoryHelper.getStackCountInInventory(this.lastCraftingItemStack, inventory);
            if ((Integer)stackPair.method_15442() >= this.autoCraftingMode.getItemCount()) {
                craftingStacks = (List)stackPair.method_15441();
                optionalCraftingRecipe = Optional.ofNullable(this.lastCraftingRecipe);
            } else {
                this.lastCraftingRecipe = null;
                this.lastCraftingItemStack = class_1799.field_8037;
            }
        }
        if (!optionalCraftingRecipe.isPresent()) {
            for (class_1799 itemStack : inventory) {
                if (itemStack.method_7960()) continue;
                class_3545<Integer, List<class_1799>> stackPair = InventoryHelper.getStackCountInInventory(itemStack, inventory);
                if ((Integer)stackPair.method_15442() >= this.autoCraftingMode.getItemCount()) {
                    craftingStacks = (List)stackPair.method_15441();
                }
                if (craftingStacks == null) continue;
                this.autoCompactingInventory.setCompacting(this.autoCraftingMode, ((class_1799)craftingStacks.get(0)).method_7972());
                optionalCraftingRecipe = this.field_11863.method_8503().method_3772().method_8132(class_3956.field_17545, (class_1263)this.autoCompactingInventory, this.field_11863);
                if (optionalCraftingRecipe.isPresent() && !((class_3955)optionalCraftingRecipe.get()).method_8110().method_7960()) break;
                optionalCraftingRecipe = Optional.empty();
            }
        }
        if (optionalCraftingRecipe.isPresent()) {
            class_1799 craftingInput = ((class_1799)craftingStacks.get(0)).method_7972();
            craftingInput.method_7939(this.autoCraftingMode.getItemCount());
            class_1799 craftingOutput = ((class_3955)optionalCraftingRecipe.get()).method_8110().method_7972();
            if (this.tryCraftInInventory(inventory, craftingInput, craftingOutput)) {
                this.lastCraftingRecipe = (class_3955)optionalCraftingRecipe.get();
                this.lastCraftingItemStack = craftingInput;
                return true;
            }
        }
        return false;
    }

    public boolean tryCraftInInventory(class_2371<class_1799> inventory, class_1799 removalItemStack, class_1799 additionItemStack) {
        boolean spaceInInventory;
        InventoryHelper.removeFromInventory(removalItemStack, inventory);
        ArrayList<class_1799> additionItemStacks = new ArrayList<class_1799>();
        additionItemStacks.add(additionItemStack);
        class_1792 recipeRemainderItem = removalItemStack.method_7909().method_7858();
        if (recipeRemainderItem != null) {
            class_1799 remainderStack = recipeRemainderItem.method_7854();
            remainderStack.method_7939(9);
            additionItemStacks.add(remainderStack);
        }
        if (spaceInInventory = InventoryHelper.smartAddToInventory(additionItemStacks, inventory, true)) {
            InventoryHelper.smartAddToInventory(additionItemStacks, inventory, false);
            this.method_11281(inventory);
            return true;
        }
        InventoryHelper.smartAddToInventory(List.of(removalItemStack), inventory, false);
        return false;
    }

    @Override
    public class_3414 getOpenSound() {
        return class_3417.field_15134;
    }

    @Override
    public class_3414 getCloseSound() {
        return class_3417.field_15228;
    }

    public AutoCompactingInventory.AutoCraftingMode getAutoCraftingMode() {
        return this.autoCraftingMode;
    }

    public void applySettings(class_2540 buf) {
        int autoCraftingModeInt = buf.readInt();
        this.autoCraftingMode = AutoCompactingInventory.AutoCraftingMode.values()[autoCraftingModeInt];
        this.lastCraftingRecipe = null;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new CompactingChestScreenHandler(syncId, playerInventory, this);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
        buf.writeInt(this.autoCraftingMode.ordinal());
    }
}

