/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.progression.ClientAdvancements;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1542;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3494;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

public class Support {
    public static final List<class_243> VECTORS_4 = new ArrayList<class_243>(){
        {
            this.add(new class_243(1.0, 0.0, 0.0));
            this.add(new class_243(0.0, 0.0, 1.0));
            this.add(new class_243(-1.0, 0.0, 0.0));
            this.add(new class_243(0.0, 0.0, -1.0));
        }
    };
    public static final List<class_243> VECTORS_8 = new ArrayList<class_243>(){
        {
            this.add(new class_243(1.0, 0.0, 0.0));
            this.add(new class_243(0.7, 0.0, 0.7));
            this.add(new class_243(0.0, 0.0, 1.0));
            this.add(new class_243(-0.7, 0.0, 0.7));
            this.add(new class_243(-1.0, 0.0, 0.0));
            this.add(new class_243(-0.7, 0.0, -0.7));
            this.add(new class_243(0.0, 0.0, -1.0));
            this.add(new class_243(0.7, 0.0, -0.7));
        }
    };
    public static final List<class_243> VECTORS_16 = new ArrayList<class_243>(){
        {
            this.add(new class_243(1.0, 0.0, 0.0));
            this.add(new class_243(0.75, 0.0, 0.5));
            this.add(new class_243(0.7, 0.0, 0.7));
            this.add(new class_243(0.5, 0.0, 0.75));
            this.add(new class_243(0.0, 0.0, 1.0));
            this.add(new class_243(-0.5, 0.0, 0.75));
            this.add(new class_243(-0.7, 0.0, 0.7));
            this.add(new class_243(-0.75, 0.0, 0.5));
            this.add(new class_243(-1.0, 0.0, 0.0));
            this.add(new class_243(-0.75, 0.0, 0.5));
            this.add(new class_243(-0.7, 0.0, -0.7));
            this.add(new class_243(-0.5, 0.0, -0.75));
            this.add(new class_243(0.0, 0.0, -1.0));
            this.add(new class_243(0.5, 0.0, -0.75));
            this.add(new class_243(0.7, 0.0, -0.7));
            this.add(new class_243(0.75, 0.0, -0.5));
        }
    };
    private static final DecimalFormat df = new DecimalFormat("0.00");

    public static boolean hasBlockTag(@NotNull class_2680 blockState, @NotNull class_3494<class_2248> tag) {
        return tag.method_15141((Object)blockState.method_26204());
    }

    public static Optional<class_3494<class_2248>> getFirstMatchingBlockTag(@NotNull class_2248 block, @NotNull List<class_3494<class_2248>> tags) {
        for (class_3494<class_2248> tag : tags) {
            if (!tag.method_15141((Object)block)) continue;
            return Optional.of(tag);
        }
        return Optional.empty();
    }

    public static String getShortenedNumberString(double number) {
        if (number > 1000000.0) {
            return df.format(number / 1000000.0) + "M";
        }
        if (number > 1000.0) {
            return df.format(number / 1000.0) + "K";
        }
        return df.format(number);
    }

    public static void givePlayer(class_1657 playerEntity, class_1799 itemStack) {
        boolean insertInventorySuccess = playerEntity.method_31548().method_7394(itemStack);
        if (insertInventorySuccess && itemStack.method_7960()) {
            itemStack.method_7939(1);
            class_1542 itemEntity = playerEntity.method_7328(itemStack, false);
            if (itemEntity != null) {
                itemEntity.method_6987();
            }
            playerEntity.field_6002.method_8465(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((playerEntity.method_6051().nextFloat() - playerEntity.method_6051().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            playerEntity.field_7512.method_7623();
        } else {
            class_1542 itemEntity = playerEntity.method_7328(itemStack, false);
            if (itemEntity != null) {
                itemEntity.method_6975();
                itemEntity.method_6984(playerEntity.method_5667());
            }
        }
    }

    public static int getIntFromDecimalWithChance(double d, @NotNull Random random) {
        boolean roundUp;
        boolean bl = roundUp = (double)random.nextFloat() < d % 1.0;
        if (roundUp) {
            return (int)d + 1;
        }
        return (int)d;
    }

    public static void grantAdvancementCriterion(@NotNull class_3222 serverPlayerEntity, String advancementString, String criterion) {
        class_2989 sal = SpectrumCommon.minecraftServer.method_3851();
        class_2985 tracker = serverPlayerEntity.method_14236();
        class_2960 advancementIdentifier = new class_2960("spectrum", advancementString);
        class_161 advancement = sal.method_12896(advancementIdentifier);
        if (advancement == null) {
            SpectrumCommon.log(Level.ERROR, "Trying to grant a criterion \"" + criterion + "\" for an advancement that does not exist: " + advancementIdentifier);
        }
        if (!tracker.method_12882(advancement).method_740()) {
            tracker.method_12878(advancement, criterion);
        }
    }

    public static boolean hasAdvancement(class_1657 playerEntity, class_2960 advancementIdentifier) {
        if (playerEntity == null) {
            return false;
        }
        if (advancementIdentifier == null) {
            return true;
        }
        if (playerEntity instanceof class_3222) {
            class_161 advancement = SpectrumCommon.minecraftServer.method_3851().method_12896(advancementIdentifier);
            if (advancement == null) {
                SpectrumCommon.log(Level.ERROR, "Player " + playerEntity.method_5477() + " was getting an advancement check for an advancement that does not exist: " + advancementIdentifier);
                return false;
            }
            return ((class_3222)playerEntity).method_14236().method_12882(advancement).method_740();
        }
        if (playerEntity.getClass().getCanonicalName().startsWith("net.minecraft")) {
            return Support.hasAdvancementClient(advancementIdentifier);
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean hasAdvancementClient(class_2960 advancementIdentifier) {
        return ClientAdvancements.hasDone(advancementIdentifier);
    }

    @NotNull
    public static String getReadableDimensionString(@NotNull String dimensionKeyString) {
        switch (dimensionKeyString) {
            case "minecraft:overworld": {
                return "Overworld";
            }
            case "minecraft:nether": {
                return "Nether";
            }
            case "minecraft:end": {
                return "End";
            }
        }
        if (dimensionKeyString.contains(":")) {
            return dimensionKeyString.substring(0, dimensionKeyString.indexOf(":"));
        }
        return dimensionKeyString;
    }
}

