/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum;

import de.dafuqs.spectrum.config.SpectrumConfig;
import de.dafuqs.spectrum.dimension.DeeperDownDimension;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.events.SpectrumGameEvents;
import de.dafuqs.spectrum.inventories.SpectrumContainers;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import de.dafuqs.spectrum.items.magic_items.BottomlessBundleItem;
import de.dafuqs.spectrum.items.magic_items.ExchangeStaffItem;
import de.dafuqs.spectrum.items.magic_items.RadianceStaffItem;
import de.dafuqs.spectrum.loot.EnchantmentDrops;
import de.dafuqs.spectrum.loot.SpectrumLootConditionTypes;
import de.dafuqs.spectrum.networking.SpectrumC2SPackets;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.BlockCloakManager;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumCommands;
import de.dafuqs.spectrum.registries.SpectrumComposting;
import de.dafuqs.spectrum.registries.SpectrumDefaultEnchantments;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumFlammableBlocks;
import de.dafuqs.spectrum.registries.SpectrumFluidTags;
import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumItemGroups;
import de.dafuqs.spectrum.registries.SpectrumItemStackDamageImmunities;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import de.dafuqs.spectrum.registries.color.ColorRegistry;
import de.dafuqs.spectrum.sound.SpectrumBlockSoundGroups;
import de.dafuqs.spectrum.sound.SpectrumSoundEvents;
import de.dafuqs.spectrum.worldgen.SpectrumConfiguredFeatures;
import de.dafuqs.spectrum.worldgen.SpectrumFeatures;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2357;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2746;
import net.minecraft.class_3611;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpectrumCommon
implements ModInitializer {
    public static final String MOD_ID = "spectrum";
    public static SpectrumConfig CONFIG;
    private static final Logger LOGGER;
    public static MinecraftServer minecraftServer;
    public static HashMap<class_3611, Integer> fluidLuminance;
    public static final class_2746 LIQUID_CRYSTAL_LOGGED;

    public static void log(Level logLevel, String message) {
        LOGGER.log(logLevel, "[Spectrum] " + message);
    }

    public void onInitialize() {
        SpectrumCommon.log(Level.INFO, "Starting Common Startup");
        SpectrumCommon.log(Level.INFO, "Loading config file...");
        AutoConfig.register(SpectrumConfig.class, JanksonConfigSerializer::new);
        CONFIG = (SpectrumConfig)AutoConfig.getConfigHolder(SpectrumConfig.class).getConfig();
        SpectrumCommon.log(Level.INFO, "Finished loading config file.");
        SpectrumCommon.log(Level.INFO, "Registering Advancement Criteria...");
        SpectrumAdvancementCriteria.register();
        SpectrumCommon.log(Level.INFO, "Registering Particle Types...");
        SpectrumParticleTypes.register();
        SpectrumCommon.log(Level.INFO, "Registering Sound Events...");
        SpectrumSoundEvents.register();
        SpectrumCommon.log(Level.INFO, "Registering BlockSound Groups...");
        SpectrumBlockSoundGroups.register();
        SpectrumCommon.log(Level.INFO, "Registering Fluid Tags...");
        SpectrumFluidTags.register();
        SpectrumCommon.log(Level.INFO, "Fetching Block Tags...");
        SpectrumBlockTags.getReferences();
        SpectrumCommon.log(Level.INFO, "Registering Fluids...");
        SpectrumFluids.register();
        SpectrumCommon.log(Level.INFO, "Registering Blocks...");
        SpectrumBlocks.register();
        SpectrumCommon.log(Level.INFO, "Registering Items...");
        SpectrumItems.register();
        SpectrumCommon.log(Level.INFO, "Fetching Item Tags...");
        SpectrumItemTags.getReferences();
        SpectrumCommon.log(Level.INFO, "Registering Block Entities...");
        SpectrumBlockEntityRegistry.register();
        SpectrumCommon.log(Level.INFO, "Registering Worldgen Features...");
        SpectrumFeatures.register();
        SpectrumCommon.log(Level.INFO, "Registering Configured and Placed Features...");
        SpectrumConfiguredFeatures.register();
        SpectrumCommon.log(Level.INFO, "Registering Dimension...");
        DeeperDownDimension.setup();
        SpectrumCommon.log(Level.INFO, "Registering Recipe Types...");
        SpectrumRecipeTypes.registerSerializer();
        SpectrumCommon.log(Level.INFO, "Registering Loot Conditions...");
        SpectrumLootConditionTypes.register();
        SpectrumCommon.log(Level.INFO, "Registering Containers...");
        SpectrumContainers.register();
        SpectrumCommon.log(Level.INFO, "Registering Screen Handler Types...");
        SpectrumScreenHandlerTypes.register();
        SpectrumCommon.log(Level.INFO, "Registering Default Item Stack Damage Immunities...");
        SpectrumItemStackDamageImmunities.registerDefaultItemStackImmunities();
        SpectrumCommon.log(Level.INFO, "Registering Enchantment Drops...");
        EnchantmentDrops.setup();
        SpectrumCommon.log(Level.INFO, "Registering Items to Fuel Registry...");
        SpectrumItems.registerFuelRegistry();
        SpectrumCommon.log(Level.INFO, "Registering Enchantments...");
        SpectrumEnchantments.register();
        SpectrumCommon.log(Level.INFO, "Registering Default Enchantments...");
        SpectrumDefaultEnchantments.registerDefaultEnchantments();
        SpectrumCommon.log(Level.INFO, "Registering Entity Types...");
        SpectrumEntityTypes.register();
        SpectrumCommon.log(Level.INFO, "Registering Commands...");
        SpectrumCommands.register();
        SpectrumCommon.log(Level.INFO, "Registering Client To ServerPackage Receivers...");
        SpectrumC2SPackets.registerC2SReceivers();
        SpectrumCommon.log(Level.INFO, "Registering Block Cloaker...");
        BlockCloakManager.setupCloaks();
        SpectrumCommon.log(Level.INFO, "Registering MultiBlocks...");
        SpectrumMultiblocks.register();
        SpectrumCommon.log(Level.INFO, "Registering Flammable Blocks...");
        SpectrumFlammableBlocks.register();
        SpectrumCommon.log(Level.INFO, "Registering Compostable Blocks...");
        SpectrumComposting.register();
        SpectrumCommon.log(Level.INFO, "Registering Game Events...");
        SpectrumGameEvents.register();
        SpectrumCommon.log(Level.INFO, "Initializing Item Groups...");
        SpectrumItemGroups.ITEM_GROUP_GENERAL.initialize();
        SpectrumItemGroups.ITEM_GROUP_BLOCKS.initialize();
        SpectrumCommon.log(Level.INFO, "Registering Block / Item Color Registries...");
        ColorRegistry.registerColorRegistries();
        SpectrumCommon.log(Level.INFO, "Registering Dispenser Behaviors..");
        class_2315.method_10009((class_1935)SpectrumItems.BOTTOMLESS_BUNDLE, (class_2357)new BottomlessBundleItem.BottomlessBundlePlacementDispenserBehavior());
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (!world.field_9236 && !player.method_7325()) {
                if (player.method_6047().method_31574(SpectrumItems.EXCHANGE_STAFF)) {
                    Optional<class_2248> blockTarget = ExchangeStaffItem.getBlockTarget(player.method_6047());
                    if (blockTarget.isPresent()) {
                        ExchangeStaffItem.exchange(world, pos, player, blockTarget.get(), player.method_6047(), true);
                    }
                    return class_1269.field_21466;
                }
                if (player.method_6047().method_31574(SpectrumItems.LIGHT_STAFF) && !world.method_8320(pos).method_27852(SpectrumBlocks.WAND_LIGHT_BLOCK)) {
                    class_2338 targetPos = pos.method_10093(direction);
                    if (RadianceStaffItem.placeLight(world, targetPos, player, player.method_6047())) {
                        RadianceStaffItem.playSoundAndParticles(world, targetPos, player, world.field_9229.nextInt(5), world.field_9229.nextInt(5));
                    } else {
                        RadianceStaffItem.playDenySound(world, player);
                    }
                    return class_1269.field_21466;
                }
            }
            return class_1269.field_5811;
        });
        ServerWorldEvents.LOAD.register((minecraftServer, serverWorld) -> {
            SpectrumCommon.minecraftServer = minecraftServer;
            Iterator it = class_2378.field_11146.method_10220().iterator();
            while (it.hasNext()) {
                class_2248 block = (class_2248)it.next();
                if (!(block instanceof class_2404)) continue;
                class_2404 fluidBlock = (class_2404)block;
                fluidLuminance.put(fluidBlock.method_9545(fluidBlock.method_9564()).method_15772(), fluidBlock.method_9564().method_26213());
            }
        });
        SpectrumCommon.log(Level.INFO, "Common startup completed!");
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_ID);
        fluidLuminance = new HashMap();
        LIQUID_CRYSTAL_LOGGED = class_2746.method_11825((String)"liquidcrystallogged");
    }
}

