/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum;

import de.dafuqs.spectrum.GuiOverlay;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.patchouli.PatchouliPages;
import de.dafuqs.spectrum.entity.SpectrumEntityRenderers;
import de.dafuqs.spectrum.inventories.SpectrumContainers;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.items.magic_items.EnderSpliceItem;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.particle.SpectrumParticleFactories;
import de.dafuqs.spectrum.progression.ToggleableBlockColorProvider;
import de.dafuqs.spectrum.progression.ToggleableItemColorProvider;
import de.dafuqs.spectrum.registries.SpectrumBlockEntityRegistry;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumTooltipComponents;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1767;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_326;
import org.apache.logging.log4j.Level;

public class SpectrumClient
implements ClientModInitializer {
    public static ToggleableBlockColorProvider coloredLeavesBlockColorProvider;
    public static ToggleableItemColorProvider coloredLeavesItemColorProvider;
    @Environment(value=EnvType.CLIENT)
    public static class_310 minecraftClient;

    public void onInitializeClient() {
        SpectrumCommon.log(Level.INFO, "Starting Client Startup");
        SpectrumCommon.log(Level.INFO, "Setting up Block Rendering...");
        SpectrumBlocks.registerClient();
        SpectrumCommon.log(Level.INFO, "Setting up Fluid Rendering...");
        SpectrumFluids.registerClient();
        SpectrumCommon.log(Level.INFO, "Setting up GUIs...");
        SpectrumContainers.register();
        SpectrumScreenHandlerTypes.registerClient();
        SpectrumCommon.log(Level.INFO, "Setting up ItemPredicates...");
        SpectrumClient.registerBowPredicates(SpectrumItems.BEDROCK_BOW);
        SpectrumClient.registerCrossbowPredicates(SpectrumItems.BEDROCK_CROSSBOW);
        SpectrumClient.registerFishingRodPredicates(SpectrumItems.BEDROCK_FISHING_ROD);
        SpectrumClient.registerEnderSplicePredicates(SpectrumItems.ENDER_SPLICE);
        this.registerAnimatedWandPredicates(SpectrumItems.NATURES_STAFF);
        this.registerAnimatedWandPredicates(SpectrumItems.LIGHT_STAFF);
        this.registerKnowledgeDropPredicates(SpectrumItems.KNOWLEDGE_GEM);
        SpectrumCommon.log(Level.INFO, "Setting up Block Entity Renderers...");
        SpectrumBlockEntityRegistry.registerClient();
        SpectrumCommon.log(Level.INFO, "Setting up Entity Renderers...");
        SpectrumEntityRenderers.registerClient();
        SpectrumCommon.log(Level.INFO, "Registering Server to Client Package Receivers...");
        SpectrumS2CPackets.registerS2CReceivers();
        SpectrumCommon.log(Level.INFO, "Registering Particle Factories...");
        SpectrumParticleFactories.register();
        SpectrumCommon.log(Level.INFO, "Registering Overlays...");
        GuiOverlay.register();
        SpectrumTooltipComponents.registerTooltipComponents();
        ClientLifecycleEvents.CLIENT_STARTED.register(minecraftClient -> {
            SpectrumClient.minecraftClient = minecraftClient;
            SpectrumClient.registerColorProviders();
        });
        SpectrumCommon.log(Level.INFO, "Registering custom Patchouli Pages...");
        PatchouliPages.register();
        SpectrumCommon.log(Level.INFO, "Client startup completed!");
    }

    private static void registerColorProviders() {
        SpectrumCommon.log(Level.INFO, "Registering Block and Item Color Providers...");
        class_322 leavesBlockColorProvider = (class_322)ColorProviderRegistry.BLOCK.get((Object)class_2246.field_10503);
        class_326 leavesItemColorProvider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10503);
        if (leavesBlockColorProvider != null && leavesItemColorProvider != null) {
            coloredLeavesBlockColorProvider = new ToggleableBlockColorProvider(leavesBlockColorProvider);
            coloredLeavesItemColorProvider = new ToggleableItemColorProvider(leavesItemColorProvider);
            for (class_1767 dyeColor : class_1767.values()) {
                class_2248 block = SpectrumBlocks.getColoredLeavesBlock(dyeColor);
                ColorProviderRegistry.BLOCK.register((Object)coloredLeavesBlockColorProvider, (Object[])new class_2248[]{block});
                ColorProviderRegistry.ITEM.register((Object)coloredLeavesItemColorProvider, (Object[])new class_1935[]{block});
            }
        }
        class_322 grassBlockColorProvider = (class_322)ColorProviderRegistry.BLOCK.get((Object)class_2246.field_10479);
        class_326 grassItemColorProvider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10479.method_8389());
        if (grassBlockColorProvider != null && grassItemColorProvider != null) {
            ColorProviderRegistry.BLOCK.register((Object)grassBlockColorProvider, (Object[])new class_2248[]{SpectrumBlocks.CLOVER});
            ColorProviderRegistry.BLOCK.register((Object)grassBlockColorProvider, (Object[])new class_2248[]{SpectrumBlocks.FOUR_LEAF_CLOVER});
        }
    }

    public static void registerBowPredicates(class_1753 bowItem) {
        FabricModelPredicateProviderRegistry.register((class_1792)bowItem, (class_2960)new class_2960("pull"), (itemStack, world, livingEntity, i) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.method_6030() != itemStack ? 0.0f : (float)(itemStack.method_7935() - livingEntity.method_6014()) / 20.0f;
        });
        FabricModelPredicateProviderRegistry.register((class_1792)bowItem, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
    }

    public static void registerCrossbowPredicates(class_1764 crossbowItem) {
        FabricModelPredicateProviderRegistry.register((class_1792)crossbowItem, (class_2960)new class_2960("pull"), (itemStack, clientWorld, livingEntity, i) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return class_1764.method_7781((class_1799)itemStack) ? 0.0f : (float)(itemStack.method_7935() - livingEntity.method_6014()) / (float)class_1764.method_7775((class_1799)itemStack);
        });
        FabricModelPredicateProviderRegistry.register((class_1792)crossbowItem, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack && !class_1764.method_7781((class_1799)itemStack) ? 1.0f : 0.0f);
        FabricModelPredicateProviderRegistry.register((class_1792)crossbowItem, (class_2960)new class_2960("charged"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && class_1764.method_7781((class_1799)itemStack) ? 1.0f : 0.0f);
        FabricModelPredicateProviderRegistry.register((class_1792)crossbowItem, (class_2960)new class_2960("firework"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && class_1764.method_7781((class_1799)itemStack) && class_1764.method_7772((class_1799)itemStack, (class_1792)class_1802.field_8639) ? 1.0f : 0.0f);
    }

    public static void registerFishingRodPredicates(class_1787 fishingRodItem) {
        FabricModelPredicateProviderRegistry.register((class_1792)fishingRodItem, (class_2960)new class_2960("cast"), (itemStack, clientWorld, livingEntity, i) -> {
            boolean bl2;
            if (livingEntity == null) {
                return 0.0f;
            }
            boolean bl = livingEntity.method_6047() == itemStack;
            boolean bl3 = bl2 = livingEntity.method_6079() == itemStack;
            if (livingEntity.method_6047().method_7909() instanceof class_1787) {
                bl2 = false;
            }
            return (bl || bl2) && livingEntity instanceof class_1657 && ((class_1657)livingEntity).field_7513 != null ? 1.0f : 0.0f;
        });
    }

    public static void registerEnderSplicePredicates(EnderSpliceItem enderSpliceItem) {
        FabricModelPredicateProviderRegistry.register((class_1792)enderSpliceItem, (class_2960)new class_2960("bound"), (itemStack, clientWorld, livingEntity, i) -> {
            class_2487 compoundTag = itemStack.method_7969();
            if (compoundTag != null && compoundTag.method_10545("PosX")) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    private void registerAnimatedWandPredicates(class_1792 item) {
        FabricModelPredicateProviderRegistry.register((class_1792)item, (class_2960)new class_2960("in_use"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
    }

    private void registerKnowledgeDropPredicates(class_1792 item) {
        FabricModelPredicateProviderRegistry.register((class_1792)item, (class_2960)new class_2960("stored_experience_10000"), (itemStack, clientWorld, livingEntity, i) -> {
            if (item instanceof ExperienceStorageItem) {
                return (float)ExperienceStorageItem.getStoredExperience(itemStack) / 10000.0f;
            }
            return 0.0f;
        });
    }
}

