/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_3954;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryHelper {
    public static boolean removeFromInventory(@NotNull class_1657 playerEntity, @NotNull class_1799 stackToRemove) {
        if (playerEntity.method_7337()) {
            return true;
        }
        class_1661 playerInventory = playerEntity.method_31548();
        ArrayList<class_3545> matchingStacks = new ArrayList<class_3545>();
        int paymentStackItemCount = 0;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 currentStack = playerInventory.method_5438(i);
            if (!currentStack.method_7909().equals(stackToRemove.method_7909())) continue;
            matchingStacks.add(new class_3545((Object)i, (Object)currentStack));
            if ((paymentStackItemCount += currentStack.method_7947()) >= stackToRemove.method_7947()) break;
        }
        if (paymentStackItemCount < stackToRemove.method_7947()) {
            return false;
        }
        int amountToRemove = stackToRemove.method_7947();
        for (class_3545 matchingStack : matchingStacks) {
            if (((class_1799)matchingStack.method_15441()).method_7947() <= amountToRemove) {
                playerEntity.method_31548().method_5447(((Integer)matchingStack.method_15442()).intValue(), class_1799.field_8037);
                if ((amountToRemove -= ((class_1799)matchingStack.method_15441()).method_7947()) > 0) continue;
                break;
            }
            ((class_1799)matchingStack.method_15441()).method_7934(amountToRemove);
            return true;
        }
        return true;
    }

    public static class_3545<Integer, List<class_1799>> getStackCountInInventory(class_1799 itemStack, List<class_1799> inventory) {
        ArrayList<class_1799> foundStacks = new ArrayList<class_1799>();
        int count = 0;
        for (class_1799 inventoryStack : inventory) {
            if (!inventoryStack.method_7929(itemStack)) continue;
            foundStacks.add(inventoryStack);
            count += inventoryStack.method_7947();
        }
        return new class_3545((Object)count, foundStacks);
    }

    public static boolean existsStackInInventory(class_1799 itemStack, List<class_1799> inventory) {
        for (class_1799 inventoryStack : inventory) {
            if (!inventoryStack.method_7929(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static class_1799 smartAddToInventory(class_1799 itemStack, class_1263 inventory, @Nullable class_2350 side) {
        if (inventory instanceof class_1278 && side != null) {
            int[] acceptableSlots;
            for (int acceptableSlot : acceptableSlots = ((class_1278)inventory).method_5494(side)) {
                if (!((class_1278)inventory).method_5492(acceptableSlot, itemStack, side)) continue;
                class_1799 existingItemStack = inventory.method_5438(acceptableSlot);
                inventory.method_5447(acceptableSlot, InventoryHelper.combineStacks(existingItemStack, itemStack));
                if (!itemStack.method_7960()) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 existingItemStack = inventory.method_5438(i);
                if (existingItemStack.method_7960()) {
                    inventory.method_5447(i, itemStack);
                    return class_1799.field_8037;
                }
                inventory.method_5447(i, InventoryHelper.combineStacks(existingItemStack, itemStack));
                if (!itemStack.method_7960()) {
                    continue;
                }
                break;
            }
        }
        return itemStack;
    }

    public static class_1799 combineStacks(class_1799 originalStack, class_1799 addingStack) {
        int leftOverAmountInExistingStack;
        if (class_1799.method_31577((class_1799)originalStack, (class_1799)addingStack) && (leftOverAmountInExistingStack = originalStack.method_7914() - originalStack.method_7947()) > 0) {
            int addAmount = Math.min(leftOverAmountInExistingStack, addingStack.method_7947());
            originalStack.method_7933(addAmount);
            addingStack.method_7934(addAmount);
        }
        return originalStack;
    }

    public static boolean smartAddToInventory(List<class_1799> itemStacks, List<class_1799> inventory, boolean test) {
        ArrayList<class_1799> additionStacks = new ArrayList<class_1799>();
        for (class_1799 itemStack : itemStacks) {
            additionStacks.add(itemStack.method_7972());
        }
        boolean tryStackExisting = true;
        for (int i = 0; i < inventory.size(); ++i) {
            class_1799 currentStack = inventory.get(i);
            for (class_1799 additionStack : additionStacks) {
                int canAcceptCount;
                int maxStackCount;
                boolean doneStuff = false;
                if (additionStack.method_7947() <= 0) continue;
                if (currentStack.method_7960() && (test || !tryStackExisting)) {
                    maxStackCount = currentStack.method_7914();
                    int maxAcceptCount = Math.min(additionStack.method_7947(), maxStackCount);
                    if (!test) {
                        class_1799 newStack = additionStack.method_7972();
                        newStack.method_7939(maxAcceptCount);
                        inventory.set(i, newStack);
                    }
                    additionStack.method_7939(additionStack.method_7947() - maxAcceptCount);
                    doneStuff = true;
                } else if (additionStack.method_7929(currentStack) && (canAcceptCount = (maxStackCount = currentStack.method_7914()) - currentStack.method_7947()) > 0) {
                    if (!test) {
                        inventory.get(i).method_7933(Math.min(additionStack.method_7947(), canAcceptCount));
                    }
                    if (canAcceptCount >= additionStack.method_7947()) {
                        additionStack.method_7939(0);
                    } else {
                        additionStack.method_7939(additionStack.method_7947() - canAcceptCount);
                    }
                    doneStuff = true;
                }
                if (!doneStuff) continue;
                boolean allEmpty = true;
                for (class_1799 itemStack : additionStacks) {
                    if (itemStack.method_7947() <= 0) continue;
                    allEmpty = false;
                    break;
                }
                if (!allEmpty) continue;
                return true;
            }
            if (!tryStackExisting || test || i != inventory.size() - 1) continue;
            tryStackExisting = false;
            i = -1;
        }
        return false;
    }

    public static boolean removeFromInventory(List<class_1856> ingredients, class_1263 inventory, boolean test) {
        ArrayList<class_1856> ingredientsToFind = new ArrayList<class_1856>(ingredients);
        for (int i = 0; i < inventory.method_5439() && ingredientsToFind.size() != 0; ++i) {
            class_1799 currentStack = inventory.method_5438(i);
            int amount = currentStack.method_7947();
            for (int j = 0; j < ingredientsToFind.size(); ++j) {
                class_1856 ingredient = (class_1856)ingredientsToFind.get(j);
                if (amount <= 0 || !ingredient.method_8093(currentStack)) continue;
                int ingredientCount = ingredient.method_8105()[0].method_7947();
                if (amount >= ingredientCount) {
                    ingredientsToFind.remove(j);
                } else {
                    ((class_1856)ingredientsToFind.get(j)).method_8105()[0].method_7939(ingredientCount - amount);
                }
                --j;
                amount -= ingredientCount;
                if (test) continue;
                if (amount > 0) {
                    currentStack.method_7939(amount);
                    continue;
                }
                inventory.method_5447(i, class_1799.field_8037);
            }
        }
        return ingredientsToFind.size() == 0;
    }

    public static boolean removeFromInventory(class_1799 removeItemStack, List<class_1799> inventory) {
        int removeItemStackCount = removeItemStack.method_7947();
        for (int i = 0; i < inventory.size(); ++i) {
            class_1799 currentStack = inventory.get(i);
            if (removeItemStack.method_7929(currentStack)) {
                int currentStackCount = currentStack.method_7947();
                if (currentStackCount >= removeItemStackCount) {
                    currentStack.method_7934(removeItemStackCount);
                    inventory.set(i, currentStack);
                    removeItemStackCount = 0;
                } else {
                    removeItemStackCount -= currentStackCount;
                    inventory.set(i, class_1799.field_8037);
                }
            }
            if (removeItemStackCount != 0) continue;
            return true;
        }
        return false;
    }

    public static IntStream getAvailableSlots(class_1263 inventory, class_2350 side) {
        return inventory instanceof class_1278 ? IntStream.of(((class_1278)inventory).method_5494(side)) : IntStream.range(0, inventory.method_5439());
    }

    public static boolean canExtract(class_1263 inv, class_1799 stack, int slot, class_2350 facing) {
        return !(inv instanceof class_1278) || ((class_1278)inv).method_5493(slot, stack, facing);
    }

    private static boolean isInventoryEmpty(class_1263 inv, class_2350 facing) {
        return InventoryHelper.getAvailableSlots(inv, facing).allMatch(i -> inv.method_5438(i).method_7960());
    }

    public static boolean canCombineItemStacks(class_1799 currentItemStack, class_1799 additionalItemStack) {
        return currentItemStack.method_7960() || additionalItemStack.method_7960() || currentItemStack.method_7929(additionalItemStack) && currentItemStack.method_7947() + additionalItemStack.method_7947() <= currentItemStack.method_7914();
    }

    @Nullable
    public static class_1263 getInventoryAt(class_1937 world, double x, double y, double z) {
        List list;
        class_2586 blockEntity;
        class_1278 inventory = null;
        class_2338 blockPos = new class_2338(x, y, z);
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_3954) {
            inventory = ((class_3954)block).method_17680(blockState, (class_1936)world, blockPos);
        } else if (blockState.method_31709() && (blockEntity = world.method_8321(blockPos)) instanceof class_1263 && (inventory = (class_1263)blockEntity) instanceof class_2595 && block instanceof class_2281) {
            inventory = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)blockState, (class_1937)world, (class_2338)blockPos, (boolean)true);
        }
        if (inventory == null && !(list = world.method_8333(null, new class_238(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), class_1301.field_6152)).isEmpty()) {
            inventory = (class_1263)list.get(world.field_9229.nextInt(list.size()));
        }
        return inventory;
    }
}

