/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.entity.block;

import com.nhoryzon.mc.farmersdelight.FarmersDelightMod;
import com.nhoryzon.mc.farmersdelight.block.CookingPotBlock;
import com.nhoryzon.mc.farmersdelight.entity.block.screen.CookingPotScreenHandler;
import com.nhoryzon.mc.farmersdelight.item.inventory.ItemStackHandler;
import com.nhoryzon.mc.farmersdelight.item.inventory.RecipeWrapper;
import com.nhoryzon.mc.farmersdelight.recipe.CookingPotRecipe;
import com.nhoryzon.mc.farmersdelight.registry.BlockEntityTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.RecipeTypesRegistry;
import com.nhoryzon.mc.farmersdelight.tag.Tags;
import java.util.Objects;
import java.util.Random;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class CookingPotBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
class_1275 {
    public static final String TAG_KEY_COOK_TIME = "CookTime";
    public static final String TAG_KEY_COOK_TIME_TOTAL = "CookTimeTotal";
    public static final int MEAL_DISPLAY_SLOT = 6;
    public static final int CONTAINER_SLOT = 7;
    public static final int OUTPUT_SLOT = 8;
    public static final int INVENTORY_SIZE = 9;
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        @Override
        public int[] method_5494(class_2350 side) {
            if (side == class_2350.field_11033) {
                return new int[]{8};
            }
            if (side == class_2350.field_11036) {
                return IntStream.range(0, 6).toArray();
            }
            return new int[]{7};
        }

        @Override
        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            if (dir == null || dir.equals((Object)class_2350.field_11036)) {
                return slot < 6;
            }
            return slot == 7;
        }

        @Override
        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            if (dir == null || dir.equals((Object)class_2350.field_11036)) {
                return slot < 6;
            }
            return slot == 8;
        }

        @Override
        protected void onInventoryLoaded() {
        }

        @Override
        protected void onInventorySlotChanged(int slot) {
            if (slot >= 0 && slot < 6) {
                CookingPotBlockEntity.this.cookTimeTotal = CookingPotBlockEntity.this.getCookTime();
                CookingPotBlockEntity.this.inventoryChanged();
            }
        }
    };
    private class_2561 customName;
    private int cookTime;
    private int cookTimeTotal;
    private class_1799 container;
    protected final class_3913 cookingPotData = new CookingPotSyncedData();
    protected final class_3956<? extends CookingPotRecipe> recipeType;

    public CookingPotBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState, class_3956<? extends CookingPotRecipe> recipeType) {
        super(blockEntityType, blockPos, blockState);
        this.recipeType = recipeType;
        this.container = class_1799.field_8037;
    }

    public CookingPotBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(BlockEntityTypesRegistry.COOKING_POT.get(), blockPos, blockState, RecipeTypesRegistry.COOKING_RECIPE_SERIALIZER.type());
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.fromTag(tag);
    }

    private void fromTag(class_2487 tag) {
        this.itemHandler.fromTag(tag.method_10562("Inventory"));
        this.cookTime = tag.method_10550(TAG_KEY_COOK_TIME);
        this.cookTimeTotal = tag.method_10550(TAG_KEY_COOK_TIME_TOTAL);
        this.container = class_1799.method_7915((class_2487)tag.method_10562("Container"));
        if (tag.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)tag.method_10558("CustomName"));
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569(TAG_KEY_COOK_TIME, this.cookTime);
        tag.method_10569(TAG_KEY_COOK_TIME_TOTAL, this.cookTimeTotal);
        tag.method_10566("Container", (class_2520)this.container.method_7953(new class_2487()));
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        tag.method_10566("Inventory", (class_2520)this.itemHandler.toTag());
    }

    public class_2487 writeMeal(class_2487 tag) {
        if (this.getMeal().method_7960()) {
            return tag;
        }
        ItemStackHandler drops = new ItemStackHandler(9){

            @Override
            protected void onInventoryLoaded() {
            }

            @Override
            protected void onInventorySlotChanged(int slot) {
            }
        };
        for (int i = 0; i < 9; ++i) {
            drops.method_5447(i, i == 6 ? this.itemHandler.method_5438(i) : class_1799.field_8037);
        }
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        tag.method_10566("Container", (class_2520)this.container.method_7953(new class_2487()));
        tag.method_10566("Inventory", (class_2520)drops.toTag());
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10566("Container", (class_2520)this.container.method_7953(new class_2487()));
        nbtCompound.method_10566("Inventory", (class_2520)this.itemHandler.toTag());
        return nbtCompound;
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : FarmersDelightMod.i18n("container.cooking_pot", new Object[0]);
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new CookingPotScreenHandler(syncId, inv, this, this.cookingPotData);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CookingPotBlockEntity blockEntity) {
        if (!world.method_8608()) {
            CookingPotBlockEntity.serverTick(world, blockEntity);
        } else {
            CookingPotBlockEntity.clientTick(blockEntity);
        }
    }

    protected static void serverTick(class_1937 world, CookingPotBlockEntity blockEntity) {
        boolean dirty = false;
        if (blockEntity.isAboveLitHeatSource() && blockEntity.hasInput()) {
            CookingPotRecipe recipe = world.method_8433().method_8132(blockEntity.recipeType, (class_1263)new RecipeWrapper(blockEntity.itemHandler), world).orElse(null);
            if (blockEntity.canCook(recipe)) {
                ++blockEntity.cookTime;
                if (blockEntity.cookTime == blockEntity.cookTimeTotal) {
                    blockEntity.cookTime = 0;
                    blockEntity.cookTimeTotal = blockEntity.getCookTime();
                    blockEntity.cook(recipe);
                    dirty = true;
                }
            } else {
                blockEntity.cookTime = 0;
            }
        } else if (blockEntity.cookTime > 0) {
            blockEntity.cookTime = class_3532.method_15340((int)(blockEntity.cookTime - 2), (int)0, (int)blockEntity.cookTimeTotal);
        }
        class_1799 meal = blockEntity.getMeal();
        if (!meal.method_7960()) {
            if (!blockEntity.doesMealHaveContainer(meal)) {
                blockEntity.moveMealToOutput();
                dirty = true;
            } else if (!blockEntity.itemHandler.method_5438(7).method_7960()) {
                blockEntity.useStoredContainersOnMeal();
                dirty = true;
            }
        }
        if (dirty) {
            blockEntity.inventoryChanged();
        }
    }

    protected static void clientTick(CookingPotBlockEntity blockEntity) {
        if (blockEntity.isAboveLitHeatSource()) {
            blockEntity.animate();
        }
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    protected int getCookTime() {
        return Objects.requireNonNull(this.field_11863).method_8433().method_8132(this.recipeType, (class_1263)new RecipeWrapper(this.itemHandler), this.field_11863).map(CookingPotRecipe::getCookTime).orElse(200);
    }

    protected class_1799 getRecipeContainer() {
        return Objects.requireNonNull(this.field_11863).method_8433().method_8132(this.recipeType, (class_1263)new RecipeWrapper(this.itemHandler), this.field_11863).map(CookingPotRecipe::getContainer).orElse(class_1799.field_8037);
    }

    public class_1799 getContainer() {
        if (!this.container.method_7960()) {
            return this.container;
        }
        return new class_1799((class_1935)this.getMeal().method_7909().method_7858());
    }

    private boolean hasInput() {
        for (int i = 0; i < 6; ++i) {
            if (this.itemHandler.method_5438(i).method_7960()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(class_1860<?> recipeIn) {
        if (this.hasInput() && recipeIn != null) {
            class_1799 recipeOutput = recipeIn.method_8110();
            if (recipeOutput.method_7960()) {
                return false;
            }
            class_1799 currentOutput = this.itemHandler.method_5438(6);
            if (currentOutput.method_7960()) {
                return true;
            }
            if (!currentOutput.method_7929(recipeOutput)) {
                return false;
            }
            if (currentOutput.method_7947() + recipeOutput.method_7947() <= this.itemHandler.getMaxCountForSlot(6)) {
                return true;
            }
            return currentOutput.method_7947() + recipeOutput.method_7947() <= recipeOutput.method_7914();
        }
        return false;
    }

    private void cook(class_1860<?> recipe) {
        if (recipe != null && this.canCook(recipe)) {
            this.container = this.getRecipeContainer();
            class_1799 recipeOutput = recipe.method_8110();
            class_1799 currentOutput = this.itemHandler.method_5438(6);
            if (currentOutput.method_7960()) {
                this.itemHandler.method_5447(6, recipeOutput.method_7972());
            } else if (currentOutput.method_7909() == recipeOutput.method_7909()) {
                currentOutput.method_7933(recipeOutput.method_7947());
            }
        }
        for (int i = 0; i < 6; ++i) {
            class_1799 itemStack = this.itemHandler.method_5438(i);
            if (itemStack.method_7909().method_7857() && this.field_11863 != null) {
                class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)CookingPotBlock.FACING)).method_10160();
                double dropX = (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.25;
                double dropY = (double)this.field_11867.method_10264() + 0.7;
                double dropZ = (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.25;
                class_1542 entity = new class_1542(this.field_11863, dropX, dropY, dropZ, new class_1799((class_1935)this.itemHandler.method_5438(i).method_7909().method_7858()));
                entity.method_18800((double)((float)direction.method_10148() * 0.08f), 0.25, (double)((float)direction.method_10165() * 0.08f));
                this.field_11863.method_8649((class_1297)entity);
            }
            if (this.itemHandler.method_5438(i).method_7960()) continue;
            this.itemHandler.method_5438(i).method_7934(1);
        }
    }

    private void animate() {
        class_1937 world = this.method_10997();
        if (world != null) {
            double baseZ;
            double baseY;
            double baseX;
            class_2338 blockpos = this.method_11016();
            Random random = world.field_9229;
            if (random.nextFloat() < 0.2f) {
                baseX = (double)blockpos.method_10263() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
                baseY = (double)blockpos.method_10264() + 0.7;
                baseZ = (double)blockpos.method_10260() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
                world.method_8406((class_2394)class_2398.field_11241, baseX, baseY, baseZ, 0.0, 0.0, 0.0);
            }
            if (random.nextFloat() < 0.05f) {
                baseX = (double)blockpos.method_10263() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                baseY = (double)blockpos.method_10264() + 0.7;
                baseZ = (double)blockpos.method_10260() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                world.method_8406((class_2394)class_2398.field_11245, baseX, baseY, baseZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public class_1799 getMeal() {
        return this.itemHandler.method_5438(6);
    }

    public boolean isAboveLitHeatSource() {
        if (this.field_11863 == null) {
            return false;
        }
        class_2680 checkState = this.field_11863.method_8320(this.field_11867.method_10074());
        if (Tags.HEAT_SOURCES.method_15141((Object)checkState.method_26204())) {
            if (checkState.method_28498((class_2769)class_2741.field_12548)) {
                return (Boolean)checkState.method_11654((class_2769)class_2741.field_12548);
            }
            return true;
        }
        return false;
    }

    public class_2371<class_1799> getDroppableInventory() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < 9; ++i) {
            drops.add((Object)(i == 6 ? class_1799.field_8037 : this.itemHandler.method_5438(i)));
        }
        return drops;
    }

    private void moveMealToOutput() {
        class_1799 mealDisplay = this.itemHandler.method_5438(6);
        class_1799 finalOutput = this.itemHandler.method_5438(8);
        int mealCount = Math.min(mealDisplay.method_7947(), mealDisplay.method_7914() - finalOutput.method_7947());
        if (finalOutput.method_7960()) {
            this.itemHandler.method_5447(8, mealDisplay.method_7971(mealCount));
        } else if (finalOutput.method_7909() == mealDisplay.method_7909()) {
            mealDisplay.method_7934(mealCount);
            finalOutput.method_7933(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        class_1799 mealDisplay = this.itemHandler.method_5438(6);
        class_1799 containerInput = this.itemHandler.method_5438(7);
        class_1799 finalOutput = this.itemHandler.method_5438(8);
        if (this.isContainerValid(containerInput) && finalOutput.method_7947() < finalOutput.method_7914()) {
            int smallerStack = Math.min(mealDisplay.method_7947(), containerInput.method_7947());
            int mealCount = Math.min(smallerStack, mealDisplay.method_7914() - finalOutput.method_7947());
            if (finalOutput.method_7960()) {
                containerInput.method_7934(mealCount);
                this.itemHandler.method_5447(8, mealDisplay.method_7971(mealCount));
            } else if (finalOutput.method_7909() == mealDisplay.method_7909()) {
                mealDisplay.method_7934(mealCount);
                containerInput.method_7934(mealCount);
                finalOutput.method_7933(mealCount);
            }
        }
    }

    public class_1799 useHeldItemOnMeal(class_1799 container) {
        if (this.isContainerValid(container) && !this.getMeal().method_7960()) {
            container.method_7934(1);
            return this.getMeal().method_7971(1);
        }
        return class_1799.field_8037;
    }

    private boolean doesMealHaveContainer(class_1799 meal) {
        return !this.container.method_7960() || meal.method_7909().method_7857();
    }

    public boolean isContainerValid(class_1799 containerItem) {
        if (containerItem.method_7960()) {
            return false;
        }
        if (!this.container.method_7960()) {
            return this.container.method_7929(containerItem);
        }
        return new class_1799((class_1935)this.getMeal().method_7909().method_7858()).method_7929(containerItem);
    }

    public ItemStackHandler getInventory() {
        return this.itemHandler;
    }

    private void inventoryChanged() {
        this.method_5431();
        Objects.requireNonNull(this.field_11863).method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }

    private class CookingPotSyncedData
    implements class_3913 {
        private CookingPotSyncedData() {
        }

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> CookingPotBlockEntity.this.cookTime;
                case 1 -> CookingPotBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                CookingPotBlockEntity.this.cookTime = value;
            } else if (index == 1) {
                CookingPotBlockEntity.this.cookTimeTotal = value;
            }
        }

        public int method_17389() {
            return 2;
        }
    }
}

