/*
 * Decompiled with CFR 0.152.
 */
package me.steven.mocolors.gui;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.netty.buffer.Unpooled;
import java.util.Locale;
import java.util.regex.Pattern;
import me.steven.mocolors.MoColors;
import me.steven.mocolors.gui.WColorVisualizer;
import me.steven.mocolors.items.PainterItem;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.apache.logging.log4j.LogManager;

public class PainterScreenHandler
extends SyncedGuiDescription {
    public static final class_2960 PAINTER_SCREEN_BG = new class_2960("mocolors", "textures/gui/painter_bg.png");
    private static final Pattern VALID_REGEX = Pattern.compile("#[A-F0-9]+");
    public static final class_2960 SCREEN_ID = new class_2960("mocolors", "painter_screen");
    private final WTextField hexCode = new WTextField();

    public PainterScreenHandler(int syncId, class_1661 playerInventory) {
        super(MoColors.DYE_MIXER_TYPE, syncId, playerInventory);
        WGridPanel root = new WGridPanel();
        this.rootPanel = root;
        WColorVisualizer colorVisualizer = new WColorVisualizer();
        root.add((WWidget)colorVisualizer, 3, 2);
        colorVisualizer.setLocation(72, 37);
        colorVisualizer.setColorProvider(() -> {
            if (VALID_REGEX.matcher(this.hexCode.getText().toUpperCase(Locale.ROOT)).matches()) {
                return Integer.decode("0x" + this.hexCode.getText().substring(1));
            }
            return -1;
        });
        WLabel label = new WLabel("Color (#RRGGBB)");
        root.add((WWidget)label, 0, 1);
        label.setLocation(0, 22);
        class_1799 mainHandStack = playerInventory.method_7391();
        int color = PainterItem.getColor(mainHandStack);
        this.hexCode.setText("#" + Integer.toHexString(color).toUpperCase(Locale.ROOT));
        this.hexCode.setTextPredicate(s -> VALID_REGEX.matcher(s.toUpperCase(Locale.ROOT)).matches());
        this.hexCode.setMaxLength(7);
        root.add((WWidget)this.hexCode, 0, 2);
        this.hexCode.setSize(50, 20);
        root.validate((GuiDescription)this);
    }

    public void addPainters() {
        if (this.rootPanel != null && !this.fullscreen) {
            this.rootPanel.setBackgroundPainter((matrices, x, y, panel) -> ScreenDrawing.texturedRect((class_4587)matrices, (int)(x - 6), (int)(y - 6), (int)(panel.getWidth() + 12), (int)(panel.getHeight() + 12), (class_2960)PAINTER_SCREEN_BG, (int)-1));
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.world.field_9236) {
            int i;
            if (!VALID_REGEX.matcher(this.hexCode.getText().toUpperCase(Locale.ROOT)).matches()) {
                return;
            }
            try {
                i = Integer.decode("0x" + this.hexCode.getText().substring(1));
            }
            catch (NumberFormatException e) {
                LogManager.getLogger((String)"PainterGUI").warn("Received false match! " + this.hexCode.toString());
                return;
            }
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(i);
            ClientPlayNetworking.send((class_2960)MoColors.UPDATE_PAINTER_COLOR_PACKET, (class_2540)buf);
        }
    }
}

