/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.mixin;

import com.glisco.conjuring.Conjuring;
import com.glisco.conjuring.items.soul_alloy_tools.CopycatPlayerDamageSource;
import com.glisco.conjuring.items.soul_alloy_tools.SoulAlloyTool;
import com.glisco.conjuring.items.soul_alloy_tools.SoulAlloyToolAbilities;
import com.glisco.conjuring.util.ConjuringParticleEvents;
import io.wispforest.owo.particles.ServerParticles;
import io.wispforest.owo.util.VectorSerializer;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    private float damageReduction = -1.0f;

    @Shadow
    protected abstract void method_6074(class_1282 var1, float var2);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"applyDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyArmorToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F")})
    public void applySwordAoe(class_1282 source, float amount, CallbackInfo ci) {
        if (source instanceof CopycatPlayerDamageSource) {
            return;
        }
        if (!source.method_5525().equals("player")) {
            return;
        }
        if (!(source instanceof class_1285)) {
            return;
        }
        class_1657 player = (class_1657)source.method_5529();
        if (!SoulAlloyToolAbilities.canAoeHit(player)) {
            return;
        }
        int scopeLevel = SoulAlloyTool.getModifierLevel(player.method_6047(), SoulAlloyTool.SoulAlloyModifier.SCOPE);
        int range = 2 + scopeLevel;
        List entities = this.field_6002.method_8333((class_1297)this, new class_238(this.method_19538().method_1023((double)range, 1.0, (double)range), this.method_19538().method_1031((double)range, 1.0, (double)range)), entity -> entity instanceof class_1309);
        entities.remove(player);
        for (int i = 0; i < Conjuring.CONFIG.tools_config.sword_scope_max_entities && i < entities.size(); ++i) {
            ((class_1297)entities.get(i)).method_5643((class_1282)new CopycatPlayerDamageSource(player), amount * Conjuring.CONFIG.tools_config.sword_scope_damage_multiplier * (float)scopeLevel);
            player.method_6047().method_7956(4 * scopeLevel, (class_1309)player, playerEntity -> player.method_20236(class_1268.field_5808));
            if (this.field_6002.method_8608()) continue;
            int entityIndex = i;
            ServerParticles.issueEvent((class_3218)((class_3218)this.field_6002), (class_243)this.method_19538(), (class_2960)ConjuringParticleEvents.LINE, byteBuf -> {
                VectorSerializer.write((class_243)this.method_19538().method_1031(0.0, 0.25 + this.field_5974.nextDouble(), 0.0), (class_2540)byteBuf);
                VectorSerializer.write((class_243)((class_1297)entities.get(entityIndex)).method_19538().method_1031(0.0, 0.25 + this.field_5974.nextDouble(), 0.0), (class_2540)byteBuf);
            });
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V")})
    public void calculateDamageReduction(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!source.method_5525().equals("player")) {
            return;
        }
        if (!(source instanceof class_1285)) {
            return;
        }
        class_1657 player = (class_1657)source.method_5529();
        if (!SoulAlloyToolAbilities.canArmorPierce(player)) {
            return;
        }
        float pierceDamage = (float)SoulAlloyTool.getModifierLevel(player.method_6047(), SoulAlloyTool.SoulAlloyModifier.IGNORANCE) * Conjuring.CONFIG.tools_config.sword_ignorance_multiplier * amount;
        this.method_6074((class_1282)new CopycatPlayerDamageSource(player).pierceArmor(), pierceDamage);
        this.damageReduction = pierceDamage;
    }

    @ModifyVariable(method={"applyDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isInvulnerableTo(Lnet/minecraft/entity/damage/DamageSource;)Z", shift=At.Shift.AFTER), ordinal=0)
    public float applyDamageReduction(float amount) {
        if (this.damageReduction == -1.0f) {
            return amount;
        }
        float reductionCopy = this.damageReduction;
        this.damageReduction = -1.0f;
        return amount - reductionCopy;
    }
}

