/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.items.soul_alloy_tools;

import com.glisco.conjuring.items.ConjuringItems;
import com.glisco.conjuring.items.soul_alloy_tools.SoulAlloyTool;
import io.wispforest.owo.ops.WorldOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class SoulAlloyToolAbilities {
    public static final Predicate<class_2680> NO_TOOL_OVERRIDE = blockState -> false;

    public static void registerCommonEvents() {
        PlayerBlockBreakEvents.BEFORE.register((world, playerEntity, blockPos, blockState, blockEntity) -> {
            if (!SoulAlloyToolAbilities.canAoeDig(playerEntity)) {
                return true;
            }
            class_1799 playerStack = playerEntity.method_6047();
            for (class_2338 pos : SoulAlloyToolAbilities.getBlocksToDig(playerEntity, ((SoulAlloyTool)playerStack.method_7909()).getAoeToolOverridePredicate())) {
                WorldOps.breakBlockWithItem((class_1937)world, (class_2338)pos, (class_1799)playerStack);
                playerStack.method_7956(SoulAlloyTool.getModifierLevel(playerStack, SoulAlloyTool.SoulAlloyModifier.SCOPE) * 2, (class_1309)playerEntity, p -> p.method_20236(class_1268.field_5808));
            }
            return true;
        });
    }

    public static boolean canAoeDig(class_1657 player) {
        return player.method_6047().method_7909() instanceof SoulAlloyTool && SoulAlloyTool.isSecondaryEnabled(player.method_6047()) && SoulAlloyTool.getModifiers(player.method_6047()).containsKey((Object)SoulAlloyTool.SoulAlloyModifier.SCOPE);
    }

    public static boolean canArmorPierce(class_1657 player) {
        return player.method_6047().method_7909() == ConjuringItems.SOUL_ALLOY_SWORD && SoulAlloyTool.getModifierLevel(player.method_6047(), SoulAlloyTool.SoulAlloyModifier.IGNORANCE) > 0;
    }

    public static boolean canAoeHit(class_1657 player) {
        return player.method_6047().method_7909() == ConjuringItems.SOUL_ALLOY_SWORD && SoulAlloyTool.isSecondaryEnabled(player.method_6047()) && SoulAlloyTool.getModifierLevel(player.method_6047(), SoulAlloyTool.SoulAlloyModifier.SCOPE) > 0;
    }

    public static List<class_2338> getBlocksToDig(class_1657 player, Predicate<class_2680> toolOverridePredicate) {
        class_2338 hit;
        SoulAlloyTool tool;
        class_1792 class_17922 = player.method_6047().method_7909();
        if (!(class_17922 instanceof SoulAlloyTool) || !(tool = (SoulAlloyTool)class_17922).canAoeDig()) {
            return Collections.emptyList();
        }
        ArrayList<class_2338> blocksToDig = new ArrayList<class_2338>();
        class_239 target = player.method_5745(player.method_31549().field_7477 ? 5.0 : 4.5, 0.0f, false);
        if (target.method_17783() != class_239.class_240.field_1332) {
            return blocksToDig;
        }
        class_2338 origin = hit = ((class_3965)target).method_17777();
        class_2350 side = ((class_3965)target).method_17780();
        int scopeLevel = SoulAlloyTool.getModifiers(player.method_6047()).get((Object)SoulAlloyTool.SoulAlloyModifier.SCOPE);
        class_2680 targetState = player.field_6002.method_8320(hit);
        if (!toolOverridePredicate.test(targetState) && player.method_6047().method_7909().method_7865(player.method_6047(), targetState) == 1.0f) {
            return blocksToDig;
        }
        switch (side.method_10166()) {
            case field_11048: {
                hit = hit.method_10069(0, -1 * scopeLevel, -1 * scopeLevel);
                for (int i = 0; i < 1 + 2 * scopeLevel; ++i) {
                    for (int j = 0; j < 1 + 2 * scopeLevel; ++j) {
                        blocksToDig.add(hit.method_10069(0, i, j));
                    }
                }
                break;
            }
            case field_11052: {
                hit = hit.method_10069(-1 * scopeLevel, 0, -1 * scopeLevel);
                for (int i = 0; i < 1 + 2 * scopeLevel; ++i) {
                    for (int j = 0; j < 1 + 2 * scopeLevel; ++j) {
                        blocksToDig.add(hit.method_10069(j, 0, i));
                    }
                }
                break;
            }
            case field_11051: {
                hit = hit.method_10069(-1 * scopeLevel, -1 * scopeLevel, 0);
                for (int i = 0; i < 1 + 2 * scopeLevel; ++i) {
                    for (int j = 0; j < 1 + 2 * scopeLevel; ++j) {
                        blocksToDig.add(hit.method_10069(j, i, 0));
                    }
                }
                break;
            }
        }
        blocksToDig.remove(origin);
        blocksToDig.removeIf(blockPos -> {
            class_2680 state = player.field_6002.method_8320(blockPos);
            if (state.method_26214((class_1922)player.field_6002, blockPos) < 0.0f) {
                return true;
            }
            if (toolOverridePredicate.test(state)) {
                return false;
            }
            return player.method_6047().method_7909().method_7865(player.method_6047(), state) <= 1.0f;
        });
        return blocksToDig;
    }
}

