/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.items.soul_alloy_tools;

import com.glisco.conjuring.items.soul_alloy_tools.SoulAlloyToolAbilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_5251;

public interface SoulAlloyTool {
    default public boolean canAoeDig() {
        return false;
    }

    default public Predicate<class_2680> getAoeToolOverridePredicate() {
        return SoulAlloyToolAbilities.NO_TOOL_OVERRIDE;
    }

    public static void toggleEnabledState(class_1799 stack) {
        boolean currentState = stack.method_7948().method_10545("SecondaryEnabled") && stack.method_7948().method_10577("SecondaryEnabled");
        currentState = !currentState;
        stack.method_7948().method_10556("SecondaryEnabled", currentState);
    }

    public static boolean isSecondaryEnabled(class_1799 stack) {
        return stack.method_7948().method_10545("SecondaryEnabled") && stack.method_7948().method_10577("SecondaryEnabled");
    }

    public static void addModifier(class_1799 stack, SoulAlloyModifier modifier) {
        class_2487 modifierTag = stack.method_7911("Modifiers");
        int level = modifierTag.method_10545(modifier.name()) ? modifierTag.method_10550(modifier.name()) : 0;
        modifierTag.method_10569(modifier.name(), ++level);
    }

    public static boolean canAddModifier(class_1799 stack, SoulAlloyModifier modifier) {
        class_2487 modifierTag = stack.method_7911("Modifiers");
        if (modifierTag.method_10541().size() >= 2 && SoulAlloyTool.getModifierLevel(stack, modifier) == 0) {
            return false;
        }
        if (SoulAlloyTool.getModifierLevel(stack, modifier) >= 3) {
            return false;
        }
        return modifierTag.method_10541().stream().mapToInt(arg_0 -> ((class_2487)modifierTag).method_10550(arg_0)).sum() < 5;
    }

    public static boolean canAddModifiers(class_1799 stack, List<SoulAlloyModifier> modifiers) {
        HashMap<SoulAlloyModifier, Integer> modifierMap = SoulAlloyTool.getModifiers(stack);
        for (SoulAlloyModifier soulAlloyModifier : modifiers) {
            if (!modifierMap.containsKey((Object)soulAlloyModifier)) {
                modifierMap.put(soulAlloyModifier, 1);
                continue;
            }
            modifierMap.put(soulAlloyModifier, modifierMap.get((Object)soulAlloyModifier) + 1);
        }
        for (Map.Entry entry : modifierMap.entrySet()) {
            if ((Integer)entry.getValue() < 3) continue;
            if ((Integer)entry.getValue() > 3) {
                return false;
            }
            if (!modifierMap.entrySet().stream().anyMatch(currentEntry -> currentEntry != entry && (Integer)currentEntry.getValue() > 2)) continue;
            return false;
        }
        return modifierMap.size() <= 2;
    }

    public static List<class_2561> getTooltip(class_1799 stack) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        class_2487 modifiers = stack.method_7911("Modifiers");
        for (String key : modifiers.method_10541()) {
            SoulAlloyModifier modifier = SoulAlloyModifier.valueOf(key);
            String level = "\u25cf".repeat(Math.max(0, modifiers.method_10550(key)));
            tooltip.add((class_2561)new class_2588(modifier.translation_key).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)modifier.textColor))).method_27693(": \u00a77" + level));
        }
        if (!tooltip.isEmpty() && stack.method_7942()) {
            tooltip.add((class_2561)new class_2585(""));
        }
        return tooltip;
    }

    public static int getModifierLevel(class_1799 stack, SoulAlloyModifier modifier) {
        return stack.method_7911("Modifiers").method_10545(modifier.name()) ? stack.method_7911("Modifiers").method_10550(modifier.name()) : 0;
    }

    public static HashMap<SoulAlloyModifier, Integer> getModifiers(class_1799 stack) {
        HashMap<SoulAlloyModifier, Integer> modifierMap = new HashMap<SoulAlloyModifier, Integer>();
        class_2487 modifierTag = stack.method_7911("Modifiers");
        modifierTag.method_10541().forEach(s -> modifierMap.put(SoulAlloyModifier.valueOf(s), modifierTag.method_10550(s)));
        return modifierMap;
    }

    public static enum SoulAlloyModifier {
        HASTE(31256, "modifier.conjuring.haste"),
        ABUNDANCE(11013889, "modifier.conjuring.abundance"),
        SCOPE(5079428, "modifier.conjuring.scope"),
        IGNORANCE(1195913, "modifier.conjuring.ignorance");

        public final int textColor;
        public final String translation_key;

        private SoulAlloyModifier(int textColor, String translation_key) {
            this.textColor = textColor;
            this.translation_key = translation_key;
        }
    }
}

