/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.items.soul_alloy_tools;

import com.glisco.conjuring.util.ConjuringParticleEvents;
import io.wispforest.owo.ops.WorldOps;
import io.wispforest.owo.particles.ServerParticles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiFunction;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class BlockCrawler {
    public static final BiFunction<class_2248, class_2680, Boolean> IDENTITY_PREDICATE = (block, blockState) -> block == blockState.method_26204();
    private static final ConcurrentLinkedQueue<CrawlData> blocksToCrawl = new ConcurrentLinkedQueue();

    public static void crawl(class_1937 world, class_2338 firstBlock, class_1799 breakStack, int maxBlocks) {
        BlockCrawler.crawl(world, firstBlock, breakStack, maxBlocks, IDENTITY_PREDICATE);
    }

    public static void crawl(class_1937 world, class_2338 firstBlock, class_1799 breakStack, int maxBlocks, BiFunction<class_2248, class_2680, Boolean> predicate) {
        if (world.method_8608()) {
            return;
        }
        class_2248 blockType = world.method_8320(firstBlock).method_26204();
        ArrayList<class_2338> foundBlocks = new ArrayList<class_2338>(Collections.singletonList(firstBlock));
        ConcurrentLinkedQueue<class_2338> scanBlocks = new ConcurrentLinkedQueue<class_2338>(foundBlocks);
        int counter = 0;
        block0: do {
            for (class_2338 foundBlock : scanBlocks) {
                scanBlocks.remove(foundBlock);
                for (class_2338 pos : BlockCrawler.getNeighbors(foundBlock)) {
                    if (foundBlocks.size() >= maxBlocks) continue block0;
                    if (!predicate.apply(blockType, world.method_8320(pos)).booleanValue() || foundBlocks.contains(pos)) continue;
                    foundBlocks.add(pos);
                    scanBlocks.add(pos);
                }
            }
        } while (!scanBlocks.isEmpty() && ++counter < 25);
        blocksToCrawl.add(new CrawlData((class_5321<class_1937>)world.method_27983(), breakStack, foundBlocks));
    }

    public static void tick(class_1937 world) {
        if (world.method_8510() % 2L != 0L) {
            return;
        }
        for (CrawlData data : blocksToCrawl) {
            if (!data.world.method_29177().equals((Object)world.method_27983().method_29177())) continue;
            if (data.isEmpty()) {
                blocksToCrawl.remove(data);
                continue;
            }
            class_2338 pos = data.getFirstAndRemove();
            WorldOps.breakBlockWithItem((class_1937)world, (class_2338)pos, (class_1799)data.mineItem);
            ServerParticles.issueEvent((class_3218)((class_3218)world), (class_243)class_243.method_24954((class_2382)pos), (class_2960)ConjuringParticleEvents.BREAK_BLOCK, packetByteBuf -> {});
        }
    }

    public static List<class_2338> getNeighbors(class_2338 center) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        class_2338 original = center;
        center = center.method_10084();
        for (int i = 0; i < 3; ++i) {
            list.add(center);
            list.add(center.method_10078());
            list.add(center.method_10067());
            list.add(center.method_10095());
            list.add(center.method_10072());
            list.add(center.method_10072().method_10067());
            list.add(center.method_10072().method_10078());
            list.add(center.method_10095().method_10067());
            list.add(center.method_10095().method_10078());
            center = center.method_10074();
        }
        list.remove(original);
        return list;
    }

    private static class CrawlData {
        public final class_5321<class_1937> world;
        public final class_1799 mineItem;
        private final List<class_2338> blocksToMine;

        public CrawlData(class_5321<class_1937> world, class_1799 mineItem, List<class_2338> blocksToMine) {
            this.world = world;
            this.mineItem = mineItem;
            this.blocksToMine = blocksToMine;
        }

        public boolean isEmpty() {
            return this.blocksToMine.isEmpty();
        }

        public class_2338 getFirstAndRemove() {
            class_2338 pos = this.blocksToMine.get(0);
            this.blocksToMine.remove(0);
            return pos;
        }
    }
}

