/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.compat.rei;

import com.glisco.conjuring.blocks.soulfire_forge.SoulfireForgeRecipe;
import com.glisco.conjuring.compat.rei.ConjuringCommonPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class SoulfireForgeDisplay
implements Display {
    protected final int smeltTime;
    protected final List<EntryIngredient> input;
    protected final List<EntryIngredient> output;

    public SoulfireForgeDisplay(SoulfireForgeRecipe recipe) {
        this.smeltTime = recipe.getSmeltTime();
        this.input = EntryIngredients.ofIngredients(recipe.getInputs());
        this.output = Collections.singletonList(EntryIngredients.of((class_1799)recipe.method_8110()));
    }

    public SoulfireForgeDisplay(int smeltTime, List<EntryIngredient> input, List<EntryIngredient> output) {
        this.smeltTime = smeltTime;
        this.input = input;
        this.output = output;
    }

    @NotNull
    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ConjuringCommonPlugin.SOULFIRE_FORGE;
    }

    @NotNull
    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public int getSmeltTime() {
        return this.smeltTime;
    }

    public static class Serializer
    implements DisplaySerializer<SoulfireForgeDisplay> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public class_2487 save(class_2487 tag, SoulfireForgeDisplay display) {
            tag.method_10569("smeltTime", display.getSmeltTime());
            class_2499 input = new class_2499();
            display.input.forEach(entryStacks -> input.add((Object)entryStacks.save()));
            tag.method_10566("input", (class_2520)input);
            class_2499 output = new class_2499();
            display.output.forEach(entryStacks -> output.add((Object)entryStacks.save()));
            tag.method_10566("output", (class_2520)output);
            return tag;
        }

        public SoulfireForgeDisplay read(class_2487 tag) {
            int smeltTime = tag.method_10550("smeltTime");
            ArrayList<EntryIngredient> input = new ArrayList<EntryIngredient>();
            tag.method_10554("input", 9).forEach(nbtElement -> input.add(EntryIngredient.read((class_2499)((class_2499)nbtElement))));
            ArrayList<EntryIngredient> output = new ArrayList<EntryIngredient>();
            tag.method_10554("output", 9).forEach(nbtElement -> output.add(EntryIngredient.read((class_2499)((class_2499)nbtElement))));
            return new SoulfireForgeDisplay(smeltTime, input, output);
        }
    }
}

