/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.compat.config;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="conjuring")
public class ConjuringConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public ConjurerConfig conjurer_config = new ConjurerConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public ToolsConfig tools_config = new ToolsConfig();

    public ConjuringConfig() {
        this.conjurer_config.conjurer_blacklist.add("minecraft:wither");
        this.conjurer_config.conjurer_blacklist.add("minecraft:ender_dragon");
    }

    public static class ConjurerConfig {
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Whether Fortune should affect the amount of Conjuration Essence you can get when breaking a spawner")
        public boolean fortuneEnabled = false;
        @Comment(value="How many extra mobs to spawn per abundance charm")
        public int abundance_multiplier = 2;
        @Comment(value="How many ticks of waiting to remove per haste charm")
        public float haste_multiplier = 93.75f;
        @Comment(value="How many blocks of range to add per scope charm")
        public int scope_multiplier = 6;
        @Comment(value="How many extra mobs are allowed close to the conjurer per ignorance charm")
        public int ignorance_multiplier = 2;
        @Comment(value="Which mob types you shouldn't be able to create a conjuring focus for")
        public List<String> conjurer_blacklist = new ArrayList<String>();
    }

    public static class ToolsConfig {
        @Comment(value="What percentage (additive) of the original damage to apply to each entity in the aoe per scope level")
        public float sword_scope_damage_multiplier = 0.3f;
        @Comment(value="How many entities the sword's aoe is allowed to affect")
        public int sword_scope_max_entities = 15;
        @Comment(value="What percentage (additive) of the original damage to make armor piercing per ignorance level")
        public float sword_ignorance_multiplier = 0.1f;
        @Comment(value="Exponent for the haste level, attack speed calculation goes like this: -2.4f + haste_level^exponent")
        public double sword_haste_exponent = 1.5;
        @Comment(value="How much durability firing a projectile with sword costs")
        public int sword_secondary_durability_cost = 20;
        @Comment(value="Cooldown for firing projectiles with the sword, in ticks")
        public int sword_secondary_cooldown = 30;
        @Comment(value="How much of the sword's damage each fired projectile deals")
        public float sword_projectile_damage_multiplier = 0.2f;
        @Comment(value="The exponent for the scope level, tree cutting range is calculated like this: 8 + scope_level^exponent * 8")
        public double axe_scope_exponent = 3.0;
        @Comment(value="How much durability firing a projectile with the hatchet costs, base value")
        public int axe_secondary_base_durability_cost = 10;
        @Comment(value="How much durability firing a projectile with the hatchet costs, added per scope level")
        public int axe_secondary_per_scope_durability_cost = 5;
        @Comment(value="Cooldown for firing projectiles with the hatchet, in ticks")
        public int axe_secondary_cooldown = 15;
        @Comment(value="The exponent for the scope level, tree cutting range is calculated like this: 8 + scope_level^exponent * 8")
        public double scythe_scope_exponent = 3.0;
        @Comment(value="How much durability firing a projectile with the scythe costs, base value")
        public int scythe_secondary_base_durability_cost = 10;
        @Comment(value="How much durability firing a projectile with the scythe costs, added per scope level")
        public int scythe_secondary_per_scope_durability_cost = 5;
        @Comment(value="Cooldown for firing projectiles with the scythe, in ticks")
        public int scythe_secondary_cooldown = 15;
        @Comment(value="How much durability firing a projectile with the pickaxe costs")
        public int pickaxe_secondary_durability_cost = 15;
        @Comment(value="Cooldown for firing projectiles with the pickaxe, in ticks")
        public int pickaxe_secondary_cooldown = 15;
        @Comment(value="How many ores the pickaxe's projectile can mine in one go")
        public int pickaxe_veinmine_max_blocks = 32;
        @Comment(value="From what distance the shovel's projectile pulls in items")
        public int shovel_magnet_range = 4;
    }
}

