/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.blocks.soulfire_forge;

import com.glisco.conjuring.blocks.soulfire_forge.SoulfireForgeRecipe;
import com.glisco.conjuring.blocks.soulfire_forge.SoulfireForgeRecipeJson;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SoulfireForgeRecipeSerializer
implements class_1865<SoulfireForgeRecipe> {
    public static final SoulfireForgeRecipeSerializer INSTANCE = new SoulfireForgeRecipeSerializer();
    public static final class_2960 ID = SoulfireForgeRecipe.Type.ID;

    private SoulfireForgeRecipeSerializer() {
    }

    public SoulfireForgeRecipe read(class_2960 id, JsonObject json) {
        SoulfireForgeRecipeJson recipe = (SoulfireForgeRecipeJson)new Gson().fromJson((JsonElement)json, SoulfireForgeRecipeJson.class);
        if (recipe.key == null || recipe.pattern == null || recipe.result == null || recipe.smeltTime == 0) {
            throw new JsonSyntaxException("Missing recipe attributes");
        }
        HashMap<Character, Iterator> keys = new HashMap<Character, Iterator>();
        for (Map.Entry key : recipe.key.entrySet()) {
            if (((String)key.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key '" + (String)key.getKey() + " ', must be 1 char in length");
            }
            Iterator ingredient = class_1856.method_8102((JsonElement)((JsonElement)key.getValue()));
            if (ingredient.method_8103()) {
                throw new JsonSyntaxException("Invalid key '" + (String)key.getKey() + " ', no item found");
            }
            keys.put(Character.valueOf(((String)key.getKey()).charAt(0)), ingredient);
        }
        class_2371 inputs = class_2371.method_10213((int)9, (Object)class_1856.field_9017);
        int rowCounter = 0;
        for (JsonElement e : recipe.pattern) {
            String row = e.getAsString();
            if (row.length() != 3) {
                throw new JsonSyntaxException("Wrong pattern length");
            }
            int columnCounter = 0;
            for (char c : row.toCharArray()) {
                if (c == ' ') {
                    inputs.set(rowCounter * 3 + columnCounter, (Object)class_1856.field_9017);
                } else {
                    inputs.set(rowCounter * 3 + columnCounter, (Object)((class_1856)keys.get(Character.valueOf(c))));
                }
                ++columnCounter;
            }
            ++rowCounter;
        }
        class_1792 resultItem = (class_1792)class_2378.field_11142.method_17966(class_2960.method_12829((String)recipe.result.get("item").getAsString())).orElseThrow(() -> new JsonSyntaxException("No such item '" + recipe.result.get("item").getAsString() + "'"));
        class_1799 result = new class_1799((class_1935)resultItem, recipe.result.get("count").getAsInt());
        return new SoulfireForgeRecipe(id, result, recipe.smeltTime, (class_2371<class_1856>)inputs);
    }

    public SoulfireForgeRecipe read(class_2960 id, class_2540 buf) {
        int smeltTime = buf.readInt();
        class_1799 result = buf.method_10819();
        class_2371 inputs = class_2371.method_10213((int)9, (Object)class_1856.field_9017);
        for (int i = 0; i < 9; ++i) {
            inputs.set(i, (Object)class_1856.method_8086((class_2540)buf));
        }
        return new SoulfireForgeRecipe(id, result, smeltTime, (class_2371<class_1856>)inputs);
    }

    public void write(class_2540 buf, SoulfireForgeRecipe recipe) {
        buf.writeInt(recipe.getSmeltTime());
        buf.method_10793(recipe.method_8110());
        for (class_1856 ingredient : recipe.getInputs()) {
            ingredient.method_8088(buf);
        }
    }
}

