/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.conjuring.blocks.soulfire_forge;

import com.glisco.conjuring.blocks.ConjuringBlocks;
import com.glisco.conjuring.blocks.soulfire_forge.SoulfireForgeBlock;
import com.glisco.conjuring.blocks.soulfire_forge.SoulfireForgeRecipe;
import com.glisco.conjuring.util.ConjuringParticleEvents;
import com.glisco.conjuring.util.SoulfireForgeScreenHandler;
import io.wispforest.owo.ops.ItemOps;
import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.particles.ServerParticles;
import io.wispforest.owo.util.ImplementedInventory;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5558;

public class SoulfireForgeBlockEntity
extends class_2586
implements ImplementedInventory,
class_1278,
class_3908 {
    public static final class_5558<SoulfireForgeBlockEntity> SERVER_TICKER = (world1, pos1, state, blockEntity) -> blockEntity.tickServer();
    public static final class_5558<SoulfireForgeBlockEntity> CLIENT_TICKER = (world1, pos1, state, blockEntity) -> blockEntity.tickClient();
    private final class_2371<class_1799> items = class_2371.method_10213((int)10, (Object)class_1799.field_8037);
    private final int[] SIDE_AND_TOP_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private final int[] BOTTOM_SLOT = new int[]{9};
    private int progress;
    private int smeltTime;
    private int targetSmeltTime;
    private SoulfireForgeRecipe cachedRecipe;
    private final class_3913 properties = new class_3913(){

        public int method_17390(int index) {
            return SoulfireForgeBlockEntity.this.progress;
        }

        public void method_17391(int index, int value) {
            SoulfireForgeBlockEntity.this.progress = value;
        }

        public int method_17389() {
            return 1;
        }
    };

    public SoulfireForgeBlockEntity(class_2338 pos, class_2680 state) {
        super(ConjuringBlocks.Entities.SOULFIRE_FORGE, pos, state);
    }

    public void tickClient() {
        if (!((Boolean)this.method_11010().method_11654((class_2769)SoulfireForgeBlock.BURNING)).booleanValue()) {
            return;
        }
        class_243 loc = class_243.method_24954((class_2382)this.field_11867);
        ClientParticles.setParticleCount((int)4);
        ClientParticles.spawnPrecise((class_2394)class_2398.field_11251, (class_1937)this.field_11863, (class_243)loc.method_1031(0.5, 0.6, 0.5), (double)0.3, (double)0.0, (double)0.3);
    }

    public void tickServer() {
        if (!((Boolean)this.method_11010().method_11654((class_2769)SoulfireForgeBlock.BURNING)).booleanValue() || !this.updateCachedRecipe()) {
            return;
        }
        this.targetSmeltTime = this.cachedRecipe.getSmeltTime();
        if (this.smeltTime == this.targetSmeltTime) {
            this.decrementCraftingItems();
            this.incrementOutput(this.cachedRecipe.method_8110());
            this.progress = 0;
            this.smeltTime = 0;
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)SoulfireForgeBlock.BURNING, (Comparable)Boolean.valueOf(false)));
            this.method_5431();
        } else {
            ++this.smeltTime;
            this.progress = Math.round((float)this.smeltTime / (float)this.targetSmeltTime * 32.0f);
            if (this.field_11863.field_9229.nextDouble() < 0.05) {
                ServerParticles.issueEvent((class_3218)((class_3218)this.field_11863), (class_243)class_243.method_24954((class_2382)this.field_11867), (class_2960)ConjuringParticleEvents.SOULFIRE_FORGE_SOULS);
            }
        }
        this.field_11863.method_8455(this.field_11867, ConjuringBlocks.SOULFIRE_FORGE);
    }

    private boolean updateCachedRecipe() {
        Optional recipe = this.field_11863.method_8433().method_8132((class_3956)SoulfireForgeRecipe.Type.INSTANCE, (class_1263)this, this.field_11863);
        if (recipe.isPresent()) {
            this.cachedRecipe = (SoulfireForgeRecipe)recipe.get();
            return ItemOps.canStack((class_1799)((class_1799)this.getItems().get(9)), (class_1799)((SoulfireForgeRecipe)recipe.get()).method_8110());
        }
        this.progress = 0;
        this.smeltTime = 0;
        return false;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
        tag.method_10569("Progress", this.progress);
        tag.method_10569("SmeltTime", this.smeltTime);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_1262.method_5429((class_2487)tag, this.items);
        this.progress = tag.method_10550("Progress");
        this.smeltTime = tag.method_10550("SmeltTime");
    }

    public boolean isRunning() {
        return this.smeltTime > 0;
    }

    public int getProgress() {
        return this.progress;
    }

    public void finishInstantly() {
        if (this.field_11863.method_8608()) {
            return;
        }
        this.smeltTime = this.targetSmeltTime;
        ServerParticles.issueEvent((class_3218)((class_3218)this.field_11863), (class_243)class_243.method_24954((class_2382)this.field_11867), (class_2960)ConjuringParticleEvents.CONJURER_SUMMON);
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new SoulfireForgeScreenHandler(syncId, inv, (class_1263)this, this.properties);
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public int[] method_5494(class_2350 side) {
        return side == class_2350.field_11033 ? this.BOTTOM_SLOT : this.SIDE_AND_TOP_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return slot != 9 && ((class_1799)this.items.get(slot)).method_7960();
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 9;
    }

    private void decrementCraftingItems() {
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = (class_1799)this.items.get(i);
            if (ItemOps.emptyAwareDecrement((class_1799)stack)) continue;
            this.items.set(i, (Object)class_1799.field_8037);
        }
    }

    private void incrementOutput(class_1799 craftingResult) {
        if (((class_1799)this.items.get(9)).method_7960()) {
            this.items.set(9, (Object)craftingResult);
        } else {
            ((class_1799)this.items.get(9)).method_7933(craftingResult.method_7947());
        }
    }

    public class_2561 method_5476() {
        return new class_2588("conjuring.gui.soulfire_forge");
    }
}

